/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.groups.AdHocGroup;
import org.netbeans.modules.project.ui.groups.DirectoryGroup;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.SubprojectsGroup;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NewGroupPanel
extends JPanel {
    public static final String PROP_READY = "ready";
    private JLabel adHocKindLabel;
    private JRadioButton adHocKindRadio;
    private JCheckBox autoSynchCheckbox;
    private JButton directoryButton;
    private JTextField directoryField;
    private JLabel directoryKindLabel;
    private JRadioButton directoryKindRadio;
    private JLabel directoryLabel;
    private ButtonGroup kindButtonGroup;
    private JButton masterProjectButton;
    private JTextField masterProjectField;
    private JLabel masterProjectLabel;
    private JTextField nameField;
    private JLabel nameLabel;
    private JLabel subprojectsKindLabel;
    private JRadioButton subprojectsKindRadio;
    private JCheckBox useOpenCheckbox;

    public NewGroupPanel() {
        this.initComponents();
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                NewGroupPanel.this.firePropertyChange(NewGroupPanel.PROP_READY, null, null);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NewGroupPanel.this.firePropertyChange(NewGroupPanel.PROP_READY, null, null);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.directoryField.getDocument().addDocumentListener(documentListener);
        this.nameField.getDocument().addDocumentListener(documentListener);
        this.updateNameField();
    }

    public boolean isReady() {
        if (this.adHocKindRadio.isSelected()) {
            return this.nameField.getText() != null && this.nameField.getText().trim().length() > 0;
        }
        if (this.subprojectsKindRadio.isSelected()) {
            File file;
            FileObject fileObject;
            String string = this.masterProjectField.getText();
            if (string != null && string.length() > 0 && (fileObject = FileUtil.toFileObject((File)(file = new File(string)))) != null && fileObject.isFolder()) {
                try {
                    return ProjectManager.getDefault().findProject(fileObject) != null;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return false;
        }
        assert (this.directoryKindRadio.isSelected());
        if (this.nameField.getText() == null || this.nameField.getText().trim().length() == 0) {
            return false;
        }
        String string = this.directoryField.getText();
        if (string != null) {
            return new File(string.trim()).isDirectory();
        }
        return false;
    }

    private void updateNameField() {
        String string;
        if (this.adHocKindRadio.isSelected() && this.useOpenCheckbox.isSelected()) {
            Project project = OpenProjects.getDefault().getMainProject();
            if (project != null) {
                this.nameField.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
            }
        } else if (this.subprojectsKindRadio.isSelected()) {
            File file;
            FileObject fileObject;
            String string2 = this.masterProjectField.getText();
            if (string2 != null && string2.length() > 0 && (fileObject = FileUtil.toFileObject((File)(file = new File(string2)))) != null && fileObject.isFolder()) {
                try {
                    Project project = ProjectManager.getDefault().findProject(fileObject);
                    if (project != null) {
                        this.nameField.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        } else if (this.directoryKindRadio.isSelected() && (string = this.directoryField.getText()) != null && string.length() > 0) {
            File file = new File(string);
            this.nameField.setText(file.getName());
        }
    }

    public Group create() {
        assert (this.isReady());
        if (this.adHocKindRadio.isSelected()) {
            AdHocGroup adHocGroup = AdHocGroup.create(this.nameField.getText().trim(), this.autoSynchCheckbox.isSelected());
            if (this.useOpenCheckbox.isSelected()) {
                adHocGroup.setProjects(new HashSet<Project>(Arrays.asList(OpenProjects.getDefault().getOpenProjects())));
                adHocGroup.setMainProject(OpenProjects.getDefault().getMainProject());
            }
            return adHocGroup;
        }
        if (this.subprojectsKindRadio.isSelected()) {
            FileObject fileObject = FileUtil.toFileObject((File)new File(this.masterProjectField.getText()));
            try {
                return SubprojectsGroup.create(ProjectManager.getDefault().findProject(fileObject));
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
        assert (this.directoryKindRadio.isSelected());
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.directoryField.getText().trim())));
        try {
            return DirectoryGroup.create(this.nameField.getText().trim(), fileObject);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new AssertionError((Object)fileStateInvalidException);
        }
    }

    private void initComponents() {
        this.kindButtonGroup = new ButtonGroup();
        this.adHocKindRadio = new JRadioButton();
        this.adHocKindLabel = new JLabel();
        this.useOpenCheckbox = new JCheckBox();
        this.autoSynchCheckbox = new JCheckBox();
        this.subprojectsKindRadio = new JRadioButton();
        this.subprojectsKindLabel = new JLabel();
        this.masterProjectLabel = new JLabel();
        this.masterProjectField = new JTextField();
        this.masterProjectButton = new JButton();
        this.directoryKindRadio = new JRadioButton();
        this.directoryKindLabel = new JLabel();
        this.directoryLabel = new JLabel();
        this.directoryField = new JTextField();
        this.directoryButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.kindButtonGroup.add(this.adHocKindRadio);
        this.adHocKindRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.adHocKindRadio, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.adHocKindRadio.text"));
        this.adHocKindRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.adHocKindRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewGroupPanel.this.adHocKindRadioActionPerformed(actionEvent);
            }
        });
        this.adHocKindLabel.setLabelFor(this.adHocKindRadio);
        Mnemonics.setLocalizedText((JLabel)this.adHocKindLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.adHocKindLabel.text"));
        this.useOpenCheckbox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.useOpenCheckbox, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.useOpenCheckbox.text"));
        this.autoSynchCheckbox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.autoSynchCheckbox, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.autoSynchCheckbox.text"));
        this.kindButtonGroup.add(this.subprojectsKindRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.subprojectsKindRadio, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.subprojectsKindRadio.text"));
        this.subprojectsKindRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.subprojectsKindRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewGroupPanel.this.subprojectsKindRadioActionPerformed(actionEvent);
            }
        });
        this.subprojectsKindLabel.setLabelFor(this.subprojectsKindRadio);
        Mnemonics.setLocalizedText((JLabel)this.subprojectsKindLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.subprojectsKindLabel.text"));
        this.subprojectsKindLabel.setEnabled(false);
        this.masterProjectLabel.setLabelFor(this.masterProjectField);
        Mnemonics.setLocalizedText((JLabel)this.masterProjectLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.masterProjectLabel.text"));
        this.masterProjectLabel.setEnabled(false);
        this.masterProjectField.setEditable(false);
        this.masterProjectField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.masterProjectButton, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.masterProjectButton.text"));
        this.masterProjectButton.setEnabled(false);
        this.masterProjectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewGroupPanel.this.masterProjectButtonActionPerformed(actionEvent);
            }
        });
        this.kindButtonGroup.add(this.directoryKindRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.directoryKindRadio, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryKindRadio.text"));
        this.directoryKindRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.directoryKindRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewGroupPanel.this.directoryKindRadioActionPerformed(actionEvent);
            }
        });
        this.directoryKindLabel.setLabelFor(this.directoryKindRadio);
        Mnemonics.setLocalizedText((JLabel)this.directoryKindLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryKindLabel.text"));
        this.directoryKindLabel.setEnabled(false);
        this.directoryLabel.setLabelFor(this.directoryField);
        Mnemonics.setLocalizedText((JLabel)this.directoryLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryLabel.text"));
        this.directoryLabel.setEnabled(false);
        this.directoryField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.directoryButton, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryButton.text"));
        this.directoryButton.setEnabled(false);
        this.directoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewGroupPanel.this.directoryButtonActionPerformed(actionEvent);
            }
        });
        this.nameLabel.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.nameLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.nameLabel).addPreferredGap(0).add((Component)this.nameField, -1, 570, Short.MAX_VALUE)).add((Component)this.directoryKindRadio).add((Component)this.adHocKindRadio).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.directoryLabel).addPreferredGap(0).add((Component)this.directoryField, -1, 465, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.directoryButton)).add((Component)this.directoryKindLabel))).add((Component)this.subprojectsKindRadio).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.masterProjectLabel).addPreferredGap(0).add((Component)this.masterProjectField, -1, 495, Short.MAX_VALUE)).add((Component)this.subprojectsKindLabel)).addPreferredGap(0).add((Component)this.masterProjectButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.adHocKindLabel)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.autoSynchCheckbox).add((Component)this.useOpenCheckbox)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.nameField, -2, -1, -2)).add(18, 18, 18).add((Component)this.adHocKindRadio).addPreferredGap(0).add((Component)this.adHocKindLabel).addPreferredGap(0).add((Component)this.useOpenCheckbox, -2, 23, -2).addPreferredGap(0).add((Component)this.autoSynchCheckbox).addPreferredGap(0).add((Component)this.subprojectsKindRadio).addPreferredGap(0).add((Component)this.subprojectsKindLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.masterProjectLabel).add((Component)this.masterProjectButton).add((Component)this.masterProjectField, -2, -1, -2)).addPreferredGap(0).add((Component)this.directoryKindRadio).addPreferredGap(0).add((Component)this.directoryKindLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.directoryLabel).add((Component)this.directoryField, -2, -1, -2).add((Component)this.directoryButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void directoryButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        File file2 = ProjectChooser.getProjectsFolder();
        if (this.directoryField.getText() != null && this.directoryField.getText().trim().length() > 0) {
            file2 = new File(this.directoryField.getText().trim());
        }
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, (File)file2);
        if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.directoryField.setText(file.getAbsolutePath());
            this.updateNameField();
        }
    }

    private void masterProjectButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.masterProjectField.setText(file.getAbsolutePath());
            this.updateNameField();
            this.firePropertyChange(PROP_READY, null, null);
        }
    }

    private void directoryKindRadioActionPerformed(ActionEvent actionEvent) {
        this.adHocKindLabel.setEnabled(false);
        this.useOpenCheckbox.setEnabled(false);
        this.autoSynchCheckbox.setEnabled(false);
        this.subprojectsKindLabel.setEnabled(false);
        this.masterProjectLabel.setEnabled(false);
        this.masterProjectField.setEnabled(false);
        this.masterProjectButton.setEnabled(false);
        this.directoryKindLabel.setEnabled(true);
        this.directoryLabel.setEnabled(true);
        this.directoryField.setEnabled(true);
        this.directoryButton.setEnabled(true);
        this.updateNameField();
        this.firePropertyChange(PROP_READY, null, null);
    }

    private void subprojectsKindRadioActionPerformed(ActionEvent actionEvent) {
        this.adHocKindLabel.setEnabled(false);
        this.useOpenCheckbox.setEnabled(false);
        this.autoSynchCheckbox.setEnabled(false);
        this.subprojectsKindLabel.setEnabled(true);
        this.masterProjectLabel.setEnabled(true);
        this.masterProjectField.setEnabled(true);
        this.masterProjectButton.setEnabled(true);
        this.directoryKindLabel.setEnabled(false);
        this.directoryLabel.setEnabled(false);
        this.directoryField.setEnabled(false);
        this.directoryButton.setEnabled(false);
        this.updateNameField();
        this.firePropertyChange(PROP_READY, null, null);
    }

    private void adHocKindRadioActionPerformed(ActionEvent actionEvent) {
        this.adHocKindLabel.setEnabled(true);
        this.useOpenCheckbox.setEnabled(true);
        this.autoSynchCheckbox.setEnabled(true);
        this.subprojectsKindLabel.setEnabled(false);
        this.masterProjectLabel.setEnabled(false);
        this.masterProjectField.setEnabled(false);
        this.masterProjectButton.setEnabled(false);
        this.directoryKindLabel.setEnabled(false);
        this.directoryLabel.setEnabled(false);
        this.directoryField.setEnabled(false);
        this.directoryButton.setEnabled(false);
        this.updateNameField();
        this.firePropertyChange(PROP_READY, null, null);
    }
}

