/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.PhysicalView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.XMLUtil;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

public class ProjectsRootNode
extends AbstractNode {
    static final int PHYSICAL_VIEW = 0;
    static final int LOGICAL_VIEW = 1;
    private static final String ICON_BASE = "org/netbeans/modules/project/ui/resources/projectsRootNode.gif";
    private static final String ACTIONS_FOLDER = "ProjectsTabActions";
    private ResourceBundle bundle;
    private final int type;

    public ProjectsRootNode(int n) {
        super((Children)new ProjectChildren(n));
        this.setIconBaseWithExtension(ICON_BASE);
        this.type = n;
    }

    public String getName() {
        return "OpenProjects";
    }

    public String getDisplayName() {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(ProjectsRootNode.class);
        }
        return this.bundle.getString("LBL_OpenProjectsNode_Name");
    }

    public boolean canRename() {
        return false;
    }

    public Node.Handle getHandle() {
        return new Handle(this.type);
    }

    public Action[] getActions(boolean bl) {
        if (bl || this.type == 0) {
            return new Action[0];
        }
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (Object e : Lookups.forPath((String)ACTIONS_FOLDER).lookupAll(Object.class)) {
            if (e instanceof Action) {
                arrayList.add((Action)e);
                continue;
            }
            if (!(e instanceof JSeparator)) continue;
            arrayList.add(null);
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    Node findNode(FileObject fileObject) {
        ProjectChildren projectChildren = (ProjectChildren)this.getChildren();
        if (projectChildren.type == 1) {
            int n;
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            int n2 = n = project != null ? 0 : 1;
            while (n < 2) {
                for (Node node : projectChildren.getNodes(true)) {
                    Node node2;
                    LogicalViewProvider logicalViewProvider;
                    Project project2 = (Project)node.getLookup().lookup(Project.class);
                    assert (project2 != null) : "Should have had a Project in lookup of " + node;
                    if (n == 0 && project2 != project || (logicalViewProvider = (LogicalViewProvider)project2.getLookup().lookup(LogicalViewProvider.class)) == null || (node2 = logicalViewProvider.findPath(node, (Object)fileObject)) == null) continue;
                    return node2;
                }
                ++n;
            }
            return null;
        }
        if (projectChildren.type == 0) {
            for (Node node : projectChildren.getNodes(true)) {
                Node node3;
                PhysicalView.PathFinder pathFinder = (PhysicalView.PathFinder)node.getLookup().lookup(PhysicalView.PathFinder.class);
                if (pathFinder == null || (node3 = pathFinder.findPath(node, fileObject)) == null) continue;
                return node3;
            }
            return null;
        }
        return null;
    }

    static SearchInfo alwaysSearchableSearchInfo(Project project) {
        return new AlwaysSearchableSearchInfo(project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AlwaysSearchableSearchInfo
    implements SearchInfo {
        private final SearchInfo delegate;

        public AlwaysSearchableSearchInfo(Project project) {
            SearchInfo searchInfo = (SearchInfo)project.getLookup().lookup(SearchInfo.class);
            if (searchInfo != null) {
                this.delegate = searchInfo;
            } else {
                SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
                FileObject[] fileObjectArray = new FileObject[sourceGroupArray.length];
                for (int i = 0; i < sourceGroupArray.length; ++i) {
                    fileObjectArray[i] = sourceGroupArray[i].getRootFolder();
                }
                this.delegate = SearchInfoFactory.createSearchInfo((FileObject[])fileObjectArray, (boolean)true, (FileObjectFilter[])new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER});
            }
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator<DataObject> objectsToSearch() {
            return this.delegate.objectsToSearch();
        }
    }

    private static final class BadgingLookup
    extends ProxyLookup {
        public BadgingLookup(Lookup ... lookupArray) {
            super(lookupArray);
        }

        public void setMyLookups(Lookup ... lookupArray) {
            this.setLookups(lookupArray);
        }

        public boolean isSearchInfo() {
            return this.getLookups().length > 1;
        }
    }

    private static final class BadgingNode
    extends FilterNode
    implements PropertyChangeListener,
    Runnable,
    FileStatusListener {
        private static String badgedNamePattern = NbBundle.getMessage(ProjectsRootNode.class, (String)"LBL_MainProject_BadgedNamePattern");
        private final FileObject file;
        private final Set<FileObject> files;
        private FileStatusListener fileSystemListener;
        private RequestProcessor.Task task;
        private volatile boolean nameChange;
        private final boolean logicalView;
        private final ProjectChildren.Pair pair;

        public BadgingNode(ProjectChildren.Pair pair, Node node, boolean bl, boolean bl2) {
            super(node, null, BadgingNode.badgingLookup(node, bl));
            this.pair = pair;
            this.logicalView = bl2;
            OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
            Project project = (Project)this.getOriginal().getLookup().lookup(Project.class);
            if (project != null) {
                this.file = project.getProjectDirectory();
                assert (this.file != null) : "Project returns null directory: " + project;
                this.files = Collections.singleton(this.file);
                try {
                    FileSystem fileSystem = this.file.getFileSystem();
                    this.fileSystemListener = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileSystem);
                    fileSystem.addFileStatusListener(this.fileSystemListener);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager errorManager = ErrorManager.getDefault();
                    errorManager.annotate((Throwable)fileStateInvalidException, "Can not get " + this.file + " filesystem, ignoring...");
                    errorManager.notify(1, (Throwable)fileStateInvalidException);
                }
            } else {
                this.file = null;
                this.files = null;
            }
        }

        private static Lookup badgingLookup(Node node, boolean bl) {
            if (bl) {
                return new BadgingLookup(node.getLookup(), Lookups.singleton((Object)ProjectsRootNode.alwaysSearchableSearchInfo((Project)node.getLookup().lookup(Project.class))));
            }
            return new BadgingLookup(node.getLookup());
        }

        public void run() {
            if (this.nameChange) {
                this.fireDisplayNameChange(null, null);
                this.nameChange = false;
            }
        }

        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            if (!this.nameChange && fileStatusEvent.isNameChange() && fileStatusEvent.hasChanged(this.file)) {
                this.nameChange |= fileStatusEvent.isNameChange();
            }
            this.task.schedule(50);
        }

        public String getDisplayName() {
            String string = super.getDisplayName();
            Project project = (Project)this.getOriginal().getLookup().lookup(Project.class);
            if (project != null) {
                try {
                    string = project.getProjectDirectory().getFileSystem().getStatus().annotateName(string, Collections.singleton(project.getProjectDirectory()));
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            }
            return this.isMain() ? MessageFormat.format(badgedNamePattern, string) : string;
        }

        public String getHtmlDisplayName() {
            Project project;
            String string = this.getOriginal().getHtmlDisplayName();
            String string2 = null;
            if (this.isMain() && string == null) {
                string2 = super.getDisplayName();
                try {
                    string2 = XMLUtil.toElementContent((String)string2);
                }
                catch (CharConversionException charConversionException) {
                    // empty catch block
                }
            }
            if ((project = (Project)this.getOriginal().getLookup().lookup(Project.class)) != null) {
                try {
                    FileSystem.HtmlStatus htmlStatus;
                    String string3;
                    FileSystem.Status status = project.getProjectDirectory().getFileSystem().getStatus();
                    if (status instanceof FileSystem.HtmlStatus && (string3 = (htmlStatus = (FileSystem.HtmlStatus)status).annotateNameHtml(super.getDisplayName(), Collections.singleton(project.getProjectDirectory()))) != null && !super.getDisplayName().equals(string3)) {
                        return this.isMain() ? "<b>" + string3 + "</b>" : string3;
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            }
            return this.isMain() ? "<b>" + (string == null ? string2 : string) + "</b>" : string;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("MainProject".equals(propertyChangeEvent.getPropertyName())) {
                this.fireDisplayNameChange(null, null);
            }
            if ("ReplaceProject".equals(propertyChangeEvent.getPropertyName())) {
                OpenProjectList.LOGGER.log(Level.FINER, "replacing for {0}", this);
                Project project = (Project)this.getLookup().lookup(Project.class);
                if (project == null) {
                    OpenProjectList.LOGGER.log(Level.FINE, "no project in lookup {0}", this);
                    return;
                }
                FileObject fileObject = project.getProjectDirectory();
                Project project2 = (Project)propertyChangeEvent.getNewValue();
                assert (project2 != null);
                if (project2.getProjectDirectory().equals(fileObject)) {
                    Object object;
                    ProjectChildren projectChildren = (ProjectChildren)this.getParentNode().getChildren();
                    Node node = null;
                    if (this.logicalView) {
                        node = projectChildren.logicalViewForProject(project2, null);
                        OpenProjectList.LOGGER.log(Level.FINER, "logical view {0}", node);
                    } else {
                        object = PhysicalView.createNodesForProject(project2);
                        OpenProjectList.LOGGER.log(Level.FINER, "physical view {0}", Arrays.asList(object));
                        if (((Node[])object).length > 1) {
                            this.pair.project = project2;
                            OpenProjectList.LOGGER.log(Level.FINER, "refreshing for {0}", project2);
                            projectChildren.refresh(project2);
                            OpenProjectList.LOGGER.log(Level.FINER, "refreshed for {0}", project2);
                            return;
                        }
                        for (Node node2 : object) {
                            if (!PhysicalView.isProjectDirNode(node2)) continue;
                            node = node2;
                            break;
                        }
                        assert (node != null) : "newProject yields null node: " + project2;
                    }
                    OpenProjectList.LOGGER.log(Level.FINER, "change original: {0}", node);
                    this.changeOriginal(node, true);
                    object = (BadgingLookup)this.getLookup();
                    if (((BadgingLookup)((Object)object)).isSearchInfo()) {
                        OpenProjectList.LOGGER.log(Level.FINER, "is search info {0}", object);
                        ((BadgingLookup)((Object)object)).setMyLookups(node.getLookup(), Lookups.singleton((Object)ProjectsRootNode.alwaysSearchableSearchInfo(project2)));
                    } else {
                        OpenProjectList.LOGGER.log(Level.FINER, "no search info {0}", object);
                        ((BadgingLookup)((Object)object)).setMyLookups(node.getLookup());
                    }
                    OpenProjectList.LOGGER.log(Level.FINER, "done {0}", this);
                } else {
                    OpenProjectList.LOGGER.log(Level.FINE, "wrong directories. current: " + fileObject + " new " + project2.getProjectDirectory());
                }
            }
        }

        private boolean isMain() {
            Project project = (Project)this.getLookup().lookup(Project.class);
            return project != null && OpenProjectList.getDefault().isMainProject(project);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProjectChildren
    extends Children.Keys<Pair>
    implements ChangeListener,
    PropertyChangeListener {
        private Map<Sources, Reference<Project>> sources2projects = new WeakHashMap<Sources, Reference<Project>>();
        int type;

        public ProjectChildren(int n) {
            this.type = n;
        }

        public void addNotify() {
            OpenProjectList.getDefault().addPropertyChangeListener(this);
            this.setKeys(this.getKeys());
        }

        public void removeNotify() {
            OpenProjectList.getDefault().removePropertyChangeListener(this);
            for (Sources sources : this.sources2projects.keySet()) {
                sources.removeChangeListener((ChangeListener)this);
            }
            this.sources2projects.clear();
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(Pair pair) {
            Node[] nodeArray;
            Project project = pair.project;
            Node[] nodeArray2 = null;
            boolean[] blArray = new boolean[]{true};
            if (this.type == 0) {
                nodeArray = ProjectUtils.getSources((Project)project);
                nodeArray.removeChangeListener((ChangeListener)this);
                nodeArray.addChangeListener((ChangeListener)this);
                this.sources2projects.put((Sources)nodeArray, new WeakReference<Project>(project));
                nodeArray2 = PhysicalView.createNodesForProject(project);
            } else {
                nodeArray2 = new Node[]{this.logicalViewForProject(project, blArray)};
            }
            nodeArray = new Node[nodeArray2.length];
            for (int i = 0; i < nodeArray2.length; ++i) {
                nodeArray[i] = this.type == 0 && !PhysicalView.isProjectDirNode(nodeArray2[i]) ? nodeArray2[i] : new BadgingNode(pair, nodeArray2[i], this.type == 1 && blArray[0], this.type == 1);
            }
            return nodeArray;
        }

        final Node logicalViewForProject(Project project, boolean[] blArray) {
            Node node;
            LogicalViewProvider logicalViewProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
            if (logicalViewProvider == null) {
                ErrorManager.getDefault().log(16, "Warning - project " + ProjectUtils.getInformation((Project)project).getName() + " failed to supply a LogicalViewProvider in its lookup");
                Sources sources = ProjectUtils.getSources((Project)project);
                sources.removeChangeListener((ChangeListener)this);
                sources.addChangeListener((ChangeListener)this);
                Node[] nodeArray = PhysicalView.createNodesForProject(project);
                node = nodeArray.length > 0 ? nodeArray[0] : Node.EMPTY;
            } else {
                node = logicalViewProvider.createLogicalView();
                if (node.getLookup().lookup(Project.class) != project) {
                    ErrorManager.getDefault().log(16, "Warning - project " + ProjectUtils.getInformation((Project)project).getName() + " failed to supply itself in the lookup of the root node of its own logical view");
                    if (blArray != null) {
                        blArray[0] = false;
                    }
                }
            }
            return node;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("OpenProjects".equals(propertyChangeEvent.getPropertyName())) {
                this.setKeys(this.getKeys());
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Reference<Project> reference = this.sources2projects.get(changeEvent.getSource());
            if (reference == null) {
                return;
            }
            final Project project = reference.get();
            if (project == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProjectChildren.this.refresh(project);
                }
            });
        }

        final void refresh(Project project) {
            this.refreshKey(new Pair(project, project.getProjectDirectory()));
        }

        public Collection<Pair> getKeys() {
            List<Project> list = Arrays.asList(OpenProjectList.getDefault().getOpenProjects());
            Collections.sort(list, OpenProjectList.PROJECT_BY_DISPLAYNAME);
            List<Pair> list2 = Arrays.asList(new Pair[list.size()]);
            for (int i = 0; i < list.size(); ++i) {
                Project project = list.get(i);
                list2.set(i, new Pair(project, project.getProjectDirectory()));
            }
            return list2;
        }

        private static final class Pair {
            public Project project;
            public final FileObject fo;

            public Pair(Project project, FileObject fileObject) {
                this.project = project;
                this.fo = fileObject;
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                Pair pair = (Pair)object;
                return this.fo == pair.fo || this.fo != null && this.fo.equals(pair.fo);
            }

            public int hashCode() {
                int n = 7;
                n = 53 * n + (this.fo != null ? this.fo.hashCode() : 0);
                return n;
            }
        }
    }

    private static class Handle
    implements Node.Handle {
        private static final long serialVersionUID = 78374332058L;
        private int viewType;

        public Handle(int n) {
            this.viewType = n;
        }

        public Node getNode() {
            return new ProjectsRootNode(this.viewType);
        }
    }
}

