/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.archive.project.ArchiveProject;
import org.netbeans.modules.j2ee.archive.project.ArchiveProjectProperties;
import org.netbeans.modules.j2ee.archive.ui.ConfigFilesNode;
import org.netbeans.modules.j2ee.archive.ui.ModuleNode;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class RootNode
extends AbstractNode {
    public RootNode(ArchiveProject archiveProject) {
        super((Children)new LogicalViewChildren(archiveProject), RootNode.createLookup(archiveProject));
        super.setName(ProjectUtils.getInformation((Project)archiveProject).getDisplayName());
        this.setIconBaseWithExtension("org/netbeans/modules/j2ee/archive/project/resources/packaged_archive_16.png");
        ArchiveProjectProperties archiveProjectProperties = archiveProject.getArchiveProjectProperties();
        String string = archiveProject.getPropertyEvaluator().evaluate((String)archiveProjectProperties.get("source.archive"));
        this.setShortDescription(NbBundle.getMessage(RootNode.class, (String)"LBL_ProjectToolTip", (Object)string));
    }

    public Action[] getActions(boolean bl) {
        Action[] actionArray = bl ? super.getActions(true) : this.getAdditionalActions();
        return actionArray;
    }

    private Action[] getAdditionalActions() {
        ResourceBundle resourceBundle = NbBundle.getBundle(RootNode.class);
        ArrayList<Action> arrayList = new ArrayList<Action>(30);
        arrayList.add(CommonProjectActions.newFileAction());
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"verify", (String)resourceBundle.getString("LBL_VerifyAction_Name"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null));
        arrayList.add(null);
        arrayList.add(CommonProjectActions.setAsMainProjectAction());
        arrayList.add(CommonProjectActions.openSubprojectsAction());
        arrayList.add(CommonProjectActions.closeProjectAction());
        arrayList.add(null);
        arrayList.add(CommonProjectActions.renameProjectAction());
        arrayList.add(CommonProjectActions.moveProjectAction());
        arrayList.add(CommonProjectActions.copyProjectAction());
        arrayList.add(CommonProjectActions.deleteProjectAction());
        arrayList.add(null);
        arrayList.add((Action)SystemAction.get(FindAction.class));
        Lookup lookup = Lookups.forPath((String)"Projects/Actions");
        Lookup.Template template = new Lookup.Template(Object.class);
        Iterator iterator = lookup.lookup(template).allInstances().iterator();
        if (iterator.hasNext()) {
            arrayList.add(null);
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Action) {
                arrayList.add((Action)e);
                continue;
            }
            if (!(e instanceof JSeparator)) continue;
            arrayList.add(null);
        }
        arrayList.add(null);
        arrayList.add(CommonProjectActions.customizeProjectAction());
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private static Lookup createLookup(Project project) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        return Lookups.fixed((Object[])new Object[]{project, dataFolder});
    }

    static final class LogicalViewChildren
    extends Children.Keys
    implements FileChangeListener {
        private static final String KEY_DOC_BASE = "docBase";
        private static final String KEY_SETUP_DIR = "setupDir";
        private ArchiveProject project;

        public LogicalViewChildren(ArchiveProject archiveProject) {
            assert (archiveProject != null);
            this.project = archiveProject;
        }

        protected void addNotify() {
            super.addNotify();
            this.project.getProjectDirectory().addFileChangeListener((FileChangeListener)this);
            this.createNodes();
        }

        private void createNodes() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            DataFolder dataFolder = this.getFolder((String)this.project.getArchiveProjectProperties().get("proxy.project.dir"));
            if (dataFolder != null) {
                arrayList.add(KEY_DOC_BASE);
            }
            arrayList.add(KEY_SETUP_DIR);
            String string = (String)this.project.getArchiveProjectProperties().get("proxy.project.dir");
            FileObject fileObject = this.project.getProjectDirectory().getFileObject("subarchives");
            if (null != fileObject) {
                FileObject[] fileObjectArray;
                for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                    DataFolder dataFolder2;
                    FileObject fileObject3 = null;
                    if (null != fileObject2) {
                        fileObject3 = fileObject2.getFileObject("tmpproj");
                    }
                    if (null == fileObject3 || !fileObject3.isFolder() || null == (dataFolder2 = this.getFolder("subarchives/" + fileObject2.getName() + "/" + string))) continue;
                    ModuleNode moduleNode = new ModuleNode(dataFolder2, NbBundle.getMessage(RootNode.class, (String)"LBL_ModuleNode", (Object)this.project.getEarPath(fileObject2.getName())));
                    arrayList.add((Object)moduleNode);
                }
            }
            this.setKeys(arrayList);
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.project.getProjectDirectory().removeFileChangeListener((FileChangeListener)this);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            Node[] nodeArray;
            Object object2 = object == KEY_DOC_BASE ? new ConfigFilesNode(this.getFolder((String)this.project.getArchiveProjectProperties().get("proxy.project.dir"))) : (object == KEY_SETUP_DIR ? J2eeProjectView.createServerResourcesNode((Project)this.project) : (Node)object);
            if (object2 == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = object2;
            }
            return nodeArray;
        }

        private DataFolder getFolder(String string) {
            FileObject fileObject = this.project.getProjectDirectory();
            if (null == string) {
                return null;
            }
            if (null != fileObject) {
                fileObject = fileObject.getFileObject(string);
            }
            if (null == fileObject) {
                return null;
            }
            if (null != (fileObject = fileObject.getFileObject("web"))) {
                if ((fileObject = fileObject.getFileObject("WEB-INF")) != null) {
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    return dataFolder;
                }
                return null;
            }
            fileObject = this.project.getProjectDirectory().getFileObject(string);
            if (null == fileObject) {
                return null;
            }
            if (null == (fileObject = fileObject.getFileObject("src"))) {
                return null;
            }
            if (null == (fileObject = fileObject.getFileObject("conf"))) {
                return null;
            }
            return DataFolder.findFolder((FileObject)fileObject);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.createNodes();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.createNodes();
        }
    }
}

