/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.customizer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.archive.customizer.ArchiveProjectCustomizer;
import org.netbeans.modules.j2ee.archive.project.ArchiveProject;
import org.netbeans.modules.j2ee.archive.project.ArchiveProjectProperties;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class ProvidesCustomizer
implements CustomizerProvider {
    private final Project project;
    private final AntProjectHelper antProjectHelper;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";

    public ProvidesCustomizer(Project project, AntProjectHelper antProjectHelper) {
        this.project = project;
        this.antProjectHelper = antProjectHelper;
    }

    public void showCustomizer() {
        Dialog dialog = this.createDialog();
        dialog.setVisible(true);
    }

    Dialog createDialog() {
        Object[] objectArray = new JButton[]{new JButton(NbBundle.getMessage(ProvidesCustomizer.class, (String)"LBL_Customizer_Ok_Option")), new JButton(NbBundle.getMessage(ProvidesCustomizer.class, (String)"LBL_Customizer_Cancel_Option"))};
        objectArray[0].setActionCommand(COMMAND_OK);
        objectArray[1].setActionCommand(COMMAND_CANCEL);
        ArchiveProjectProperties archiveProjectProperties = new ArchiveProjectProperties((ArchiveProject)this.project, this.antProjectHelper);
        OptionListener optionListener = new OptionListener(this.project, archiveProjectProperties);
        objectArray[0].addActionListener(optionListener);
        objectArray[1].addActionListener(optionListener);
        ArchiveProjectCustomizer archiveProjectCustomizer = new ArchiveProjectCustomizer(archiveProjectProperties);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)archiveProjectCustomizer, NbBundle.getMessage(ProvidesCustomizer.class, (String)"LBL_Customizer_Title", (Object)ProjectUtils.getInformation((Project)this.project).getDisplayName()), false, objectArray, (Object)objectArray[0], 0, null, null);
        archiveProjectCustomizer.setDialogDescriptor(dialogDescriptor);
        dialogDescriptor.setClosingOptions(new Object[]{objectArray[0], objectArray[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        return dialog;
    }

    private static class OptionListener
    implements ActionListener {
        private Project project;
        private ArchiveProjectProperties apProperties;

        OptionListener(Project project, ArchiveProjectProperties archiveProjectProperties) {
            this.project = project;
            this.apProperties = archiveProjectProperties;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (ProvidesCustomizer.COMMAND_OK.equals(string)) {
                this.apProperties.save();
                try {
                    ProjectManager.getDefault().saveProject(this.project);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    }
}

