/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstanceLookup;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.wizard.AddServerInstanceWizard;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ServersCustomizer
extends JPanel
implements PropertyChangeListener,
VetoableChangeListener,
ExplorerManager.Provider {
    private static final Dimension MINIMUM_SIZE = new Dimension(720, 400);
    private ServerCategoriesChildren children;
    private ExplorerManager manager;
    private ServerInstance initialInstance;
    private JButton addButton;
    private JPanel cards;
    private JPanel clientArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel messageArea;
    private JButton removeButton;
    private JTextField serverName;
    private JTextField serverType;
    private BeanTreeView servers;
    private JLabel serversLabel;

    public ServersCustomizer(ServerInstance serverInstance) {
        this.initComponents();
        this.serverName.setColumns(30);
        this.serverType.setColumns(30);
        this.servers.setPreferredSize(new Dimension(200, 200));
        this.initialInstance = serverInstance;
        this.setPreferredSize(MINIMUM_SIZE);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray.length != 1) {
                this.selectServer(null);
            } else {
                this.selectServer(nodeArray[0]);
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Node[] nodeArray;
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = (Node[])propertyChangeEvent.getNewValue()).length > 1) {
            throw new PropertyVetoException("Invalid length", propertyChangeEvent);
        }
    }

    public synchronized ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.setRootContext((Node)new AbstractNode((Children)this.getChildren()));
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.manager.addVetoableChangeListener((VetoableChangeListener)this);
        }
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        this.expandServers(this.initialInstance);
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.servers = new PlatformsView();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.cards = new JPanel();
        this.messageArea = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.serverName = new JTextField();
        this.jLabel2 = new JLabel();
        this.serverType = new JTextField();
        this.clientArea = new JPanel();
        this.serversLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.servers.setPreferredSize(new Dimension(220, 400));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 6, 6);
        this.add((Component)this.servers, gridBagConstraints);
        this.servers.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_InstalledServers"));
        this.servers.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_InstalledServers"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ServersCustomizer.class, (String)"CTL_AddServer"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServersCustomizer.this.addServer(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 12, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_AddServer"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_AddServer"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ServersCustomizer.class, (String)"CTL_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServersCustomizer.this.removeServer(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 12, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_Remove"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_Remove"));
        this.cards.setLayout(new CardLayout());
        this.messageArea.setLayout(new GridBagLayout());
        this.cards.add((Component)this.messageArea, "card3");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.serverName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ServersCustomizer.class, (String)"CTL_ServerName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_ServerName"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_ServerName"));
        this.serverName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.serverName, gridBagConstraints);
        this.serverName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_ServerName"));
        this.serverName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_ServerName"));
        this.jLabel2.setLabelFor(this.serverType);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ServersCustomizer.class, (String)"CTL_ServerType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_ServerType"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_Server Type"));
        this.serverType.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.jPanel1.add((Component)this.serverType, gridBagConstraints);
        this.serverType.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_ServerType"));
        this.serverType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_Server Type"));
        this.clientArea.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.clientArea, gridBagConstraints);
        this.cards.add((Component)this.jPanel1, "card2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 12);
        this.add((Component)this.cards, gridBagConstraints);
        this.serversLabel.setLabelFor((Component)this.servers);
        Mnemonics.setLocalizedText((JLabel)this.serversLabel, (String)NbBundle.getMessage(ServersCustomizer.class, (String)"CTL_Servers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.serversLabel, gridBagConstraints);
        this.serversLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"LBL_Servers"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/deployment/impl/ui/Bundle");
        this.serversLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ServerList"));
        this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ASCN_ServerManager"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_ServerCustomizer"));
    }

    private void removeServer(ActionEvent actionEvent) {
        ServerInstance serverInstance;
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray.length != 1) {
            assert (false) : "Illegal number of selected nodes";
            return;
        }
        if (nodeArray[0] instanceof ServerNode && !(serverInstance = ((ServerNode)nodeArray[0]).getServerInstance()).isRemoveForbidden()) {
            serverInstance.remove();
            this.getChildren().refreshServers();
            this.expandServers(null);
        }
    }

    private void addServer(ActionEvent actionEvent) {
        String string = AddServerInstanceWizard.showAddServerInstanceWizard();
        if (string != null) {
            this.getChildren().refreshServers();
            ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(string);
            if (serverInstance != null) {
                this.expandServers(serverInstance);
            }
        }
    }

    private synchronized ServerCategoriesChildren getChildren() {
        if (this.children == null) {
            this.children = new ServerCategoriesChildren();
        }
        return this.children;
    }

    private void selectServer(Node node) {
        Serializable serializable;
        Object object;
        this.clientArea.removeAll();
        if (node instanceof ServerNode) {
            object = ((ServerNode)node).getServerInstance();
            this.serverName.setText(((ServerInstance)object).getDisplayName());
            this.serverType.setText(((ServerInstance)object).getServer().getDisplayName());
            if (((ServerInstance)object).isRemoveForbidden()) {
                this.removeButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(true);
            }
        } else {
            this.removeButton.setEnabled(false);
            ((CardLayout)this.cards.getLayout()).first(this.cards);
            return;
        }
        if (node.hasCustomizer() && (object = node.getCustomizer()) != null) {
            ServersCustomizer.addComponent(this.clientArea, (Component)object);
        }
        int n = this.getHeight();
        int n2 = this.getWidth();
        this.setPreferredSize(null);
        this.revalidate();
        Dimension dimension = this.getPreferredSize();
        int n3 = (int)(dimension.getWidth() > MINIMUM_SIZE.getWidth() ? dimension.getWidth() : MINIMUM_SIZE.getWidth());
        int n4 = (int)(dimension.getHeight() > MINIMUM_SIZE.getHeight() ? dimension.getHeight() : MINIMUM_SIZE.getHeight());
        if (n4 > n || n3 > n2) {
            this.setPreferredSize(new Dimension(n3 > n2 ? n3 : n2, n4 > n ? n4 : n));
            for (serializable = this.getParent(); serializable != null; serializable = ((Component)serializable).getParent()) {
                if (!(serializable instanceof Window)) continue;
                ((Window)serializable).pack();
                break;
            }
        }
        serializable = (CardLayout)this.cards.getLayout();
        ((CardLayout)serializable).last(this.cards);
    }

    private static void addComponent(Container container, Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        ((GridBagLayout)container.getLayout()).setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void expandServers(ServerInstance serverInstance) {
        ExplorerManager explorerManager = this.getExplorerManager();
        Node node = explorerManager.getRootContext();
        ServersCustomizer.expandAllNodes(this.servers, node, explorerManager, serverInstance);
    }

    private static void expandAllNodes(BeanTreeView beanTreeView, Node node, ExplorerManager explorerManager, ServerInstance serverInstance) {
        beanTreeView.expandNode(node);
        Children children = node.getChildren();
        if (serverInstance != null && children == Children.LEAF && node instanceof ServerNode) {
            try {
                if (((ServerNode)node).getServerInstance() == serverInstance) {
                    explorerManager.setSelectedNodes(new Node[]{node});
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (serverInstance == null && children == Children.LEAF && explorerManager.getSelectedNodes().length == 0) {
            try {
                explorerManager.setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        Node[] nodeArray = children.getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            ServersCustomizer.expandAllNodes(beanTreeView, nodeArray[i], explorerManager, serverInstance);
        }
    }

    private static class ServerCategoriesChildren
    extends Children.Keys {
        private ServerCategoriesChildren() {
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshServers();
        }

        protected void removeNotify() {
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof ServerCategoriesDescriptor) {
                ServerCategoriesDescriptor serverCategoriesDescriptor = (ServerCategoriesDescriptor)object;
                return new Node[]{new ServerCategoryNode(serverCategoriesDescriptor)};
            }
            if (object instanceof Node) {
                return new Node[]{new FilterNode((Node)object, Children.LEAF)};
            }
            return new Node[0];
        }

        private void refreshServers() {
            Collection collection = ServerRegistry.getInstance().getInstances();
            HashMap<String, ServerCategoriesDescriptor> hashMap = new HashMap<String, ServerCategoriesDescriptor>();
            String string = NbBundle.getMessage(ServersCustomizer.class, (String)"LBL_J2eeServersNode");
            ServerCategoriesDescriptor serverCategoriesDescriptor = new ServerCategoriesDescriptor(string);
            for (ServerInstance serverInstance : collection) {
                serverCategoriesDescriptor.add((Node)new ServerNode(serverInstance));
            }
            hashMap.put(string, serverCategoriesDescriptor);
            ArrayList arrayList = new ArrayList(hashMap.values());
            Collections.sort(arrayList);
            this.setKeys(arrayList);
        }
    }

    private static class ServerCategoryNode
    extends AbstractNode {
        private final ServerCategoriesDescriptor desc;
        private Node iconDelegate;

        public ServerCategoryNode(ServerCategoriesDescriptor serverCategoriesDescriptor) {
            super((Children)new ServersChildren(serverCategoriesDescriptor.getServers()));
            this.desc = serverCategoriesDescriptor;
            this.iconDelegate = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        }

        public String getDisplayName() {
            return this.desc.getName();
        }

        public Image getIcon(int n) {
            return this.iconDelegate.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.iconDelegate.getOpenedIcon(n);
        }
    }

    private static class ServerNode
    extends FilterNode
    implements Comparable {
        private final ServerInstance serverInstance;

        public ServerNode(ServerInstance serverInstance) {
            super(serverInstance.getServer().getRegistryNodeFactory().getManagerNode(new ServerInstanceLookup(serverInstance, serverInstance.getServer().getDeploymentFactory(), null)));
            this.disableDelegation(15);
            this.serverInstance = serverInstance;
            this.setChildren(FilterNode.Children.LEAF);
            this.setDisplayName(serverInstance.getDisplayName());
            this.setName(serverInstance.getUrl());
        }

        public ServerInstance getServerInstance() {
            return this.serverInstance;
        }

        public int compareTo(Object object) {
            if (!(object instanceof ServerNode)) {
                throw new IllegalArgumentException();
            }
            return this.serverInstance.compareTo(((ServerNode)object).serverInstance);
        }
    }

    private static class ServersChildren
    extends Children.Keys {
        private List servers;

        public ServersChildren(List list) {
            this.servers = list;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.servers);
        }

        protected void removeNotify() {
            super.removeNotify();
            this.setKeys(new Object[0]);
        }

        protected Node[] createNodes(Object object) {
            return new Node[]{(Node)object};
        }
    }

    private static class ServerCategoriesDescriptor
    implements Comparable {
        private final String categoryName;
        private final List servers;

        public ServerCategoriesDescriptor(String string) {
            assert (string != null);
            this.categoryName = string;
            this.servers = new ArrayList();
        }

        public String getName() {
            return this.categoryName;
        }

        public List getServers() {
            Collections.sort(this.servers);
            return Collections.unmodifiableList(this.servers);
        }

        public void add(Node node) {
            this.servers.add(node);
        }

        public int hashCode() {
            return this.categoryName.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ServerCategoriesDescriptor) {
                ServerCategoriesDescriptor serverCategoriesDescriptor = (ServerCategoriesDescriptor)object;
                return this.categoryName.equals(serverCategoriesDescriptor.categoryName) && this.servers.size() == serverCategoriesDescriptor.servers.size();
            }
            return false;
        }

        public int compareTo(Object object) {
            if (!(object instanceof ServerCategoriesDescriptor)) {
                throw new IllegalArgumentException();
            }
            ServerCategoriesDescriptor serverCategoriesDescriptor = (ServerCategoriesDescriptor)object;
            return this.categoryName.compareTo(serverCategoriesDescriptor.categoryName);
        }
    }

    private static class PlatformsView
    extends BeanTreeView {
        public PlatformsView() {
            this.setPopupAllowed(false);
            this.setDefaultActionAllowed(false);
            this.setRootVisible(false);
            this.tree.setEditable(false);
            this.tree.setShowsRootHandles(false);
            this.setBorder(UIManager.getBorder("Nb.ScrollPane.border"));
        }
    }
}

