/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.CustomizerAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.DebugAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.ProfileAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.RefreshAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.RemoveInstanceAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.RestartAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.StartAction;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.StopAction;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class InstanceNodeDecorator
extends FilterNode
implements ServerInstance.StateListener {
    private static final String WAITING_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/waiting.png";
    private static final String RUNNING_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/running.png";
    private static final String DEBUGGING_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/debugging.png";
    private static final String SUSPENDED_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/suspended.png";
    private static final String PROFILING_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/profiling.png";
    private static final String PROFILER_BLOCKING_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/profilerblocking.png";
    private ServerInstance si;

    public InstanceNodeDecorator(Node node, ServerInstance serverInstance) {
        super(node);
        this.si = serverInstance;
        serverInstance.addStateListener(this);
    }

    public String getDisplayName() {
        return this.si.getDisplayName();
    }

    public String getName() {
        return this.si.getUrl();
    }

    public Action[] getActions(boolean bl) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(Arrays.asList(SystemAction.get(StartAction.class), SystemAction.get(DebugAction.class)));
        if (this.si.isProfileSupported()) {
            arrayList.add((Action)SystemAction.get(ProfileAction.class));
        }
        arrayList.addAll(Arrays.asList(SystemAction.get(RestartAction.class), SystemAction.get(StopAction.class), SystemAction.get(RefreshAction.class), null, SystemAction.get(RemoveInstanceAction.class)));
        arrayList.addAll(Arrays.asList(this.getOriginal().getActions(bl)));
        arrayList.add(null);
        arrayList.add((Action)SystemAction.get(CustomizerAction.class));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public Image getIcon(int n) {
        return this.badgeIcon(this.getOriginal().getIcon(n));
    }

    public Image getOpenedIcon(int n) {
        return this.badgeIcon(this.getOriginal().getOpenedIcon(n));
    }

    private Image badgeIcon(Image image) {
        Image image2 = null;
        switch (this.si.getServerState()) {
            case 1: {
                image2 = Utilities.loadImage((String)WAITING_ICON);
                break;
            }
            case 3: {
                image2 = Utilities.loadImage((String)RUNNING_ICON);
                break;
            }
            case 4: {
                image2 = Utilities.loadImage((String)DEBUGGING_ICON);
                break;
            }
            case 5: {
                image2 = Utilities.loadImage((String)SUSPENDED_ICON);
                break;
            }
            case 6: {
                image2 = Utilities.loadImage((String)PROFILING_ICON);
                break;
            }
            case 7: {
                image2 = Utilities.loadImage((String)PROFILER_BLOCKING_ICON);
                break;
            }
            case 8: {
                image2 = Utilities.loadImage((String)WAITING_ICON);
            }
        }
        return image2 != null ? Utilities.mergeImages((Image)image, (Image)image2, (int)15, (int)8) : image;
    }

    public void stateChanged(int n, int n2) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                InstanceNodeDecorator.this.fireIconChange();
            }
        });
    }
}

