/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.bridge;

import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerLookup<T>
extends AbstractLookup
implements ServerRegistry.PluginListener {
    private static final Logger LOGGER = Logger.getLogger(AbstractServerLookup.class.getName());
    private final InstanceContent content;
    private final Map<Server, T> serversMap = new HashMap<Server, T>();
    private boolean initialized;

    protected AbstractServerLookup(InstanceContent instanceContent) {
        super((AbstractLookup.Content)instanceContent);
        this.content = instanceContent;
    }

    @Override
    public final void serverAdded(Server server) {
        this.stateChanged();
    }

    @Override
    public final void serverRemoved(Server server) {
        this.stateChanged();
    }

    protected abstract T createBridgingInstance(Server var1);

    protected abstract void afterAddition(T var1);

    protected abstract void beforeFinish(T var1);

    protected abstract void finishBridgingInstance(Server var1, T var2);

    protected final void beforeLookup(Lookup.Template<?> template) {
        this.init();
        super.beforeLookup(template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        AbstractServerLookup abstractServerLookup = this;
        synchronized (abstractServerLookup) {
            if (this.initialized) {
                return;
            }
            ServerRegistry serverRegistry = ServerRegistry.getInstance();
            serverRegistry.addPluginListener((ServerRegistry.PluginListener)WeakListeners.create(ServerRegistry.PluginListener.class, (EventListener)this, (Object)serverRegistry));
            LOGGER.log(Level.FINE, "Registered bridging listener");
            this.initialized = true;
        }
        this.stateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChanged() {
        LOGGER.log(Level.FINE, "Updating the lookup content");
        HashSet hashSet = new HashSet(ServerRegistry.getInstance().getServers());
        AbstractServerLookup abstractServerLookup = this;
        synchronized (abstractServerLookup) {
            Server server;
            Iterator<Map.Entry<Server, Object>> iterator = this.serversMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                server = object.getKey();
                if (!hashSet.contains(server)) {
                    this.beforeFinish(object.getValue());
                    this.content.remove(this.serversMap.get(server));
                    iterator.remove();
                    this.finishBridgingInstance(server, object.getValue());
                    continue;
                }
                hashSet.remove(server);
            }
            for (Object object : hashSet) {
                server = this.createBridgingInstance((Server)object);
                if (server == null) continue;
                this.content.add((Object)server);
                this.serversMap.put((Server)object, server);
                this.afterAddition(server);
            }
        }
        LOGGER.log(Level.FINE, "Lookup content updated");
    }
}

