/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class InstancePropertiesImpl
extends InstanceProperties
implements InstanceListener {
    private final String url;
    private transient FileObject fo;

    public InstancePropertiesImpl(ServerInstance serverInstance) {
        this(serverInstance.getUrl());
    }

    public InstancePropertiesImpl(String string) {
        this.url = string;
    }

    private FileObject getFO() {
        if (this.fo == null) {
            ServerInstance serverInstance = ServerRegistry.getInstance().getServerInstance(this.url);
            if (serverInstance == null) {
                throw new IllegalStateException(NbBundle.getMessage(InstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url));
            }
            ServerRegistry.getInstance();
            this.fo = ServerRegistry.getInstanceFileObject(this.url);
            if (this.fo == null) {
                throw new IllegalStateException(NbBundle.getMessage(InstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url));
            }
        }
        return this.fo;
    }

    public void instanceRemoved(String string) {
        if (string != null && this.url.equals(string)) {
            this.fo = null;
        }
    }

    public void instanceAdded(String string) {
    }

    public void changeDefaultInstance(String string, String string2) {
    }

    public String getProperty(String string) throws IllegalStateException {
        Object object = this.getFO().getAttribute(string);
        return object == null ? null : object.toString();
    }

    public Enumeration propertyNames() throws IllegalStateException {
        return this.getFO().getAttributes();
    }

    public void setProperty(String string, String string2) throws IllegalStateException {
        try {
            String string3 = this.getProperty(string);
            this.getFO().setAttribute(string, (Object)string2);
            this.firePropertyChange(new PropertyChangeEvent(this, string, string3, string2));
        }
        catch (IOException iOException) {
            String string4 = NbBundle.getMessage(InstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url);
            throw new IllegalStateException(Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string4));
        }
    }

    public void setProperties(Properties properties) throws IllegalStateException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.setProperty(string, string2);
        }
    }

    public DeploymentManager getDeploymentManager() {
        ServerRegistry serverRegistry = ServerRegistry.getInstance();
        ServerInstance serverInstance = serverRegistry.getServerInstance(this.url);
        return serverInstance.getDeploymentManager();
    }

    public Target getDefaultTarget() {
        ServerRegistry serverRegistry = ServerRegistry.getInstance();
        ServerString serverString = serverRegistry.getDefaultInstance();
        Target[] targetArray = serverString.toTargets();
        if (targetArray != null && targetArray.length > 0) {
            return targetArray[0];
        }
        return null;
    }

    public void setAsDefaultServer(String string) {
        ServerRegistry serverRegistry = ServerRegistry.getInstance();
        ServerInstance serverInstance = serverRegistry.getServerInstance(this.url);
        ServerString serverString = new ServerString(serverInstance, string);
        serverRegistry.setDefaultInstance(serverString);
    }

    public boolean isDefaultInstance() {
        ServerRegistry serverRegistry = ServerRegistry.getInstance();
        ServerString serverString = serverRegistry.getDefaultInstance();
        return serverString.getUrl().equals(this.url);
    }

    public void refreshServerInstance() {
        ServerRegistry serverRegistry = ServerRegistry.getInstance();
        ServerInstance serverInstance = serverRegistry.getServerInstance(this.url);
        if (serverInstance != null) {
            serverInstance.refresh();
        }
    }
}

