/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.Target;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.execution.ModuleConfigurationProvider;
import org.netbeans.modules.j2ee.deployment.impl.ServerFileDistributor;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerProgress;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class InitialServerFileDistributor
extends ServerProgress {
    private static final Logger LOGGER = Logger.getLogger(InitialServerFileDistributor.class.getName());
    private final ServerString serverString;
    private final DeploymentTarget dtarget;
    private final IncrementalDeployment incDeployment;
    private final Target target;
    boolean inPlace = false;

    public InitialServerFileDistributor(DeploymentTarget deploymentTarget, Target target) {
        super(deploymentTarget.getServer().getServerInstance());
        this.serverString = deploymentTarget.getServer();
        this.dtarget = deploymentTarget;
        this.target = target;
        this.incDeployment = this.serverString.getServerInstance().getIncrementalDeployment();
    }

    public File distribute() {
        ModuleConfigurationProvider moduleConfigurationProvider = this.dtarget.getModuleConfigurationProvider();
        J2eeModule j2eeModule = this.dtarget.getModule();
        String string = this.dtarget.getDeploymentName();
        File file = this.incDeployment.getDirectoryForNewApplication(string, this.target, moduleConfigurationProvider.getModuleConfiguration());
        try {
            if (file == null) {
                this.inPlace = true;
                if (this.dtarget.getModule().getContentDirectory() != null) {
                    file = FileUtil.toFile((FileObject)this.dtarget.getModule().getContentDirectory());
                }
                if (file == null) {
                    String string2 = NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_InPlaceNoSupport");
                    this.setStatusDistributeFailed(string2);
                    return null;
                }
                this.setStatusDistributeCompleted(NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_InPlaceDeployment", (Object)file));
                return file;
            }
            this.setStatusDistributeRunning(NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_RunningInitialDeploy", (Object)this.dtarget.getDeploymentName(), (Object)file));
            this._distribute(j2eeModule.getArchiveContents(), file, null);
            if (j2eeModule instanceof J2eeApplication) {
                J2eeModule[] j2eeModuleArray = ((J2eeApplication)j2eeModule).getModules();
                for (int i = 0; i < j2eeModuleArray.length; ++i) {
                    String string3 = j2eeModuleArray[i].getUrl();
                    J2eeModule j2eeModule2 = moduleConfigurationProvider.getJ2eeModule(string3);
                    File file2 = this.incDeployment.getDirectoryForNewModule(file, string3, j2eeModule2, moduleConfigurationProvider.getModuleConfiguration());
                    this._distribute(j2eeModuleArray[i].getArchiveContents(), file2, string3);
                }
            }
            this.setStatusDistributeCompleted(NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_DoneInitialDistribute", (Object)this.dtarget.getDeploymentName()));
            return file;
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, null, exception);
            this.setStatusDistributeFailed(exception.getMessage());
            if (!this.inPlace && !this.cleanup(file)) {
                this.setStatusDistributeFailed("Failed to cleanup the data after unsucesful distribution");
            }
            return null;
        }
    }

    public void cleanup() {
        if (this.inPlace) {
            return;
        }
        ModuleConfigurationProvider moduleConfigurationProvider = this.dtarget.getModuleConfigurationProvider();
        J2eeModule j2eeModule = moduleConfigurationProvider.getJ2eeModule(null);
        File file = this.incDeployment.getDirectoryForNewApplication(this.target, j2eeModule, moduleConfigurationProvider.getModuleConfiguration());
        if (!this.cleanup(file)) {
            this.setStatusDistributeFailed("Failed to cleanup the data after unsucesful distribution");
        }
    }

    private boolean cleanup(File file) {
        String[] stringArray = file.list();
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file.getAbsolutePath(), stringArray[i]);
            bl = file2.isDirectory() ? bl && this.cleanup(file2) : bl && file2.delete();
        }
        bl = bl && file.delete();
        return bl;
    }

    private void _distribute(Iterator iterator, File file, String string) {
        Object var4_4 = null;
        try {
            Object object;
            FileObject fileObject = FileUtil.createFolder((File)file);
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                try {
                    fileObjectArray[i].delete();
                    continue;
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINER, null, iOException);
                    if (Utilities.isWindows()) {
                        object = fileObjectArray[i].getExt().toLowerCase(Locale.ENGLISH);
                        if ("jar".equals(object) || "zip".equals(object)) {
                            this.zeroOutArchive(fileObjectArray[i]);
                            continue;
                        }
                        throw iOException;
                    }
                    throw iOException;
                }
            }
            while (iterator.hasNext()) {
                J2eeModule.RootedEntry rootedEntry = (J2eeModule.RootedEntry)iterator.next();
                String string2 = rootedEntry.getRelativePath();
                object = rootedEntry.getFileObject();
                FileObject fileObject2 = ServerFileDistributor.findOrCreateParentFolder(fileObject, string2);
                if (!object.isData()) continue;
                if (Utilities.isWindows()) {
                    this.copyFile((FileObject)object, file, string2);
                    continue;
                }
                FileUtil.copyFile((FileObject)object, (FileObject)fileObject2, (String)object.getName());
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINER, null, exception);
            String string3 = NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_IncrementalDeployFailed", (Object)exception);
            this.setStatusDistributeFailed(string3);
            throw new RuntimeException(exception);
        }
        finally {
            if (var4_4 != null) {
                try {
                    var4_4.releaseLock();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void setStatusDistributeRunning(String string) {
        this.notify(this.createRunningProgressEvent(CommandType.DISTRIBUTE, string));
    }

    private void setStatusDistributeFailed(String string) {
        this.notify(this.createFailedProgressEvent(CommandType.DISTRIBUTE, string));
    }

    private void setStatusDistributeCompleted(String string) {
        this.notify(this.createCompletedProgressEvent(CommandType.DISTRIBUTE, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(FileObject fileObject, File file, String string) throws IOException {
        FileObject fileObject2 = FileUtil.createData((File)new File(file, string));
        InputStream inputStream = fileObject.getInputStream();
        try {
            OutputStream outputStream = fileObject2.getOutputStream();
            try {
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zeroOutArchive(FileObject fileObject) throws IOException, FileAlreadyLockedException {
        OutputStream outputStream = fileObject.getOutputStream();
        try {
            JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
            try {
                jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                jarOutputStream.write("Manifest-Version: 1.0\n".getBytes("UTF-8"));
            }
            finally {
                jarOutputStream.close();
            }
        }
        finally {
            outputStream.close();
        }
    }
}

