/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.io.PrintWriter;
import java.util.Map;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.netbeans.modules.java.source.usages.ClassFileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolDumper
extends SimpleTypeVisitor6<Void, Boolean> {
    private PrintWriter output;
    private Types types;
    private boolean hasErrors;

    public SymbolDumper(PrintWriter printWriter, Types types) {
        this.output = printWriter;
        this.types = types;
    }

    @Override
    public Void visitPrimitive(PrimitiveType primitiveType, Boolean bl) {
        switch (primitiveType.getKind()) {
            case BOOLEAN: {
                this.output.append('Z');
                break;
            }
            case BYTE: {
                this.output.append('B');
                break;
            }
            case SHORT: {
                this.output.append('S');
                break;
            }
            case INT: {
                this.output.append('I');
                break;
            }
            case LONG: {
                this.output.append('J');
                break;
            }
            case CHAR: {
                this.output.append('C');
                break;
            }
            case FLOAT: {
                this.output.append('F');
                break;
            }
            case DOUBLE: {
                this.output.append('D');
                break;
            }
            default: {
                throw new IllegalArgumentException("Should not happend. Or can it?");
            }
        }
        return null;
    }

    @Override
    public Void visitNoType(NoType noType, Boolean bl) {
        switch (noType.getKind()) {
            case VOID: {
                this.output.append('V');
                break;
            }
            case PACKAGE: {
                new Exception("what should be printed here?").printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Void visitNull(NullType nullType, Boolean bl) {
        new Exception("what should be printed here?").printStackTrace();
        return null;
    }

    @Override
    public Void visitArray(ArrayType arrayType, Boolean bl) {
        this.output.append('[');
        this.visit(arrayType.getComponentType());
        return null;
    }

    @Override
    public Void visitDeclared(DeclaredType declaredType, Boolean bl) {
        if (declaredType.getEnclosingType() != null && declaredType.getEnclosingType().getKind() == TypeKind.DECLARED) {
            this.visit(declaredType.getEnclosingType(), Boolean.TRUE);
            this.output.append('$');
            this.output.append(declaredType.asElement().getSimpleName());
        } else {
            this.output.append('L');
            this.output.append(ClassFileUtil.encodeClassName((TypeElement)declaredType.asElement()));
        }
        java.util.List<? extends TypeMirror> list = declaredType.getTypeArguments();
        if (!list.isEmpty()) {
            this.output.append('<');
            for (TypeMirror typeMirror : list) {
                this.visit(typeMirror);
            }
            this.output.append('>');
        }
        if (bl != Boolean.TRUE) {
            this.output.append(';');
        }
        return null;
    }

    @Override
    public Void visitError(ErrorType errorType, Boolean bl) {
        TypeElement typeElement = (TypeElement)errorType.asElement();
        this.output.append('R');
        if (typeElement != null) {
            this.output.append(typeElement.getSimpleName().toString());
        }
        this.output.append(';');
        this.hasErrors = true;
        return null;
    }

    @Override
    public Void visitTypeVariable(TypeVariable typeVariable, Boolean bl) {
        if (bl == Boolean.TRUE) {
            this.output.append(typeVariable.asElement().getSimpleName().toString());
            this.output.append(':');
            assert (typeVariable.getLowerBound().getKind() == TypeKind.NULL) : "currently not handled!";
            Type type = (Type)typeVariable.getUpperBound();
            if (type.isCompound()) {
                if (type.getKind() == TypeKind.EXECUTABLE || type.getKind() == TypeKind.PACKAGE) {
                    throw new IllegalArgumentException(type.toString());
                }
                Type type2 = this.types.supertype(type);
                this.visit(type2 == Type.noType || type2 == type || type2 == null ? this.types.interfaces(type) : this.types.interfaces(type).prepend(type2));
            } else {
                this.visit(typeVariable.getUpperBound());
            }
            this.output.append(';');
        } else {
            this.output.append('Q');
            this.output.append(typeVariable.asElement().getSimpleName().toString());
            this.output.append(';');
        }
        return null;
    }

    @Override
    public Void visitWildcard(WildcardType wildcardType, Boolean bl) {
        boolean bl2 = false;
        if (wildcardType.getExtendsBound() != null) {
            this.output.append("+");
            this.visit(wildcardType.getExtendsBound());
            bl2 = true;
        }
        if (wildcardType.getSuperBound() != null) {
            this.output.append("-");
            this.visit(wildcardType.getSuperBound());
            bl2 = true;
        }
        if (!bl2) {
            this.output.append('?');
        }
        return null;
    }

    @Override
    public Void visitExecutable(ExecutableType executableType, Boolean bl) {
        throw new IllegalStateException("This cannot be handled correctly, and should hopefully never happen...");
    }

    @Override
    public Void visitUnknown(TypeMirror typeMirror, Boolean bl) {
        new Exception("what should be printed here?").printStackTrace();
        return null;
    }

    public void visit(java.util.List<? extends TypeMirror> list) {
        for (TypeMirror typeMirror : list) {
            this.visit(typeMirror);
        }
    }

    public void visit(java.util.List<? extends TypeMirror> list, Boolean bl) {
        for (TypeMirror typeMirror : list) {
            this.visit(typeMirror, bl);
        }
    }

    public static boolean dump(PrintWriter printWriter, Types types, TransTypes transTypes, TypeElement typeElement, Element element) {
        boolean bl = SymbolDumper.dumpImpl(printWriter, types, typeElement, element);
        printWriter.append('\n');
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)typeElement;
        List<Symbol> list = List.nil();
        ListBuffer listBuffer = classSymbol.members().elems;
        while (listBuffer != null) {
            try {
                if (!(((Scope.Entry)((Object)listBuffer)).sym.getKind().isClass() || ((Scope.Entry)((Object)listBuffer)).sym.getKind().isInterface() || ((Scope.Entry)((Object)listBuffer)).sym == null || (((Scope.Entry)((Object)listBuffer)).sym.flags() & 0x1000L) != 0L && (((Scope.Entry)((Object)listBuffer)).sym.flags() & 0x80000000L) == 0L || ((Scope.Entry)((Object)listBuffer)).sym.owner != classSymbol)) {
                    list = list.prepend(((Scope.Entry)((Object)listBuffer)).sym);
                }
            }
            catch (Symbol.CompletionFailure completionFailure) {
                // empty catch block
            }
            listBuffer = ((Scope.Entry)((Object)listBuffer)).sibling;
        }
        for (Symbol symbol : list) {
            if ((symbol.flags() & 0x80000000L) != 0L) {
                symbol.flags_field |= 0x1000L;
            }
            bl |= SymbolDumper.dumpImpl(printWriter, types, symbol);
        }
        listBuffer = new ListBuffer();
        JCDiagnostic.SimpleDiagnosticPosition simpleDiagnosticPosition = new JCDiagnostic.SimpleDiagnosticPosition(-1);
        transTypes.getBridges(simpleDiagnosticPosition, classSymbol, listBuffer);
        for (JCTree jCTree : listBuffer) {
            if (jCTree.getKind() != Tree.Kind.METHOD) continue;
            assert (((JCTree.JCMethodDecl)jCTree).sym != null);
            bl |= SymbolDumper.dumpImpl(printWriter, types, (Element)((JCTree.JCMethodDecl)jCTree).sym);
        }
        printWriter.append('W');
        SymbolDumper symbolDumper = new SymbolDumper(printWriter, types);
        SymbolDumper.dumpAnnotations(symbolDumper, typeElement);
        return bl | symbolDumper.hasErrors;
    }

    private static boolean dumpImpl(PrintWriter printWriter, Types types, TypeElement typeElement, Element element) {
        SymbolDumper symbolDumper = new SymbolDumper(printWriter, types);
        printWriter.append('G');
        SymbolDumper.dumpFlags(printWriter, ((Symbol)((Object)typeElement)).flags_field & 0xFFFFFF7FAFFFFFFFL);
        java.util.List<? extends TypeParameterElement> list = typeElement.getTypeParameters();
        if (!list.isEmpty()) {
            printWriter.append('<');
            for (TypeParameterElement typeParameterElement : list) {
                symbolDumper.visit(typeParameterElement.asType(), Boolean.TRUE);
            }
            printWriter.append('>');
        }
        SymbolDumper.dumpName(printWriter, ClassFileUtil.encodeClassName(typeElement));
        SymbolDumper.dumpEnclosingElement(symbolDumper, element);
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (typeMirror.getKind() != TypeKind.NONE) {
            symbolDumper.visit(typeMirror);
        } else if (!"java.lang.Object".equals(typeElement.getQualifiedName().toString())) {
            printWriter.append("Ljava.lang.Object;");
        } else {
            printWriter.append(";");
        }
        symbolDumper.visit(typeElement.getInterfaces());
        printWriter.append(';');
        SymbolDumper.dumpInnerclasses(printWriter, ElementFilter.typesIn(typeElement.getEnclosedElements()));
        return symbolDumper.hasErrors;
    }

    private static void dumpEnclosingElement(SymbolDumper symbolDumper, Element element) {
        if (element != null) {
            if (element.getKind().isClass() || element.getKind().isInterface()) {
                SymbolDumper.dumpName(symbolDumper.output, ClassFileUtil.encodeClassName((TypeElement)element));
            } else {
                SymbolDumper.dumpName(symbolDumper.output, ClassFileUtil.encodeClassName((TypeElement)element.getEnclosingElement()));
                ExecutableElement executableElement = (ExecutableElement)element;
                SymbolDumper.dumpName(symbolDumper.output, executableElement.getSimpleName());
                ExecutableType executableType = (ExecutableType)((Object)((Symbol)((Object)executableElement)).externalType(symbolDumper.types));
                symbolDumper.output.append('(');
                symbolDumper.visit(executableType.getParameterTypes());
                symbolDumper.output.append(')');
                symbolDumper.output.append('(');
                symbolDumper.visit(executableType.getThrownTypes());
                symbolDumper.output.append(')');
                symbolDumper.visit(executableType.getReturnType());
            }
        }
        symbolDumper.output.append(';');
    }

    private static void dumpInnerclasses(PrintWriter printWriter, java.util.List<TypeElement> list) {
        for (TypeElement typeElement : list) {
            SymbolDumper.dumpName(printWriter, typeElement.getSimpleName());
            SymbolDumper.dumpFlags(printWriter, ((Symbol)((Object)typeElement)).flags_field & 0xFFFFFF7FAFFFFFFFL);
        }
        printWriter.append(';');
    }

    private static boolean dumpImpl(PrintWriter printWriter, Types types, Element element) {
        if (element.getKind().isField()) {
            boolean bl = SymbolDumper.dumpImpl(printWriter, types, (VariableElement)element);
            printWriter.append('\n');
            return bl;
        }
        if (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR) {
            boolean bl = SymbolDumper.dumpImpl(printWriter, types, (ExecutableElement)element);
            printWriter.append('\n');
            return bl;
        }
        Logger.getLogger(SymbolDumper.class.getName()).info("Unhandled ElementKind: " + (Object)((Object)element.getKind()));
        return false;
    }

    private static boolean dumpImpl(PrintWriter printWriter, Types types, VariableElement variableElement) {
        SymbolDumper symbolDumper;
        block13: {
            block12: {
                symbolDumper = new SymbolDumper(printWriter, types);
                printWriter.append('A');
                SymbolDumper.dumpFlags(printWriter, ((Symbol)((Object)variableElement)).flags_field);
                symbolDumper.visit(variableElement.asType());
                SymbolDumper.dumpName(printWriter, variableElement.getSimpleName());
                if (!variableElement.getModifiers().contains((Object)Modifier.STATIC) || variableElement.getConstantValue() == null) break block12;
                switch (variableElement.asType().getKind()) {
                    case BOOLEAN: {
                        printWriter.append('Z');
                        printWriter.append(String.valueOf(variableElement.getConstantValue()));
                        break;
                    }
                    case BYTE: {
                        printWriter.append('B');
                        printWriter.append(String.valueOf(variableElement.getConstantValue()));
                        break;
                    }
                    case SHORT: {
                        printWriter.append('S');
                        printWriter.append(String.valueOf(variableElement.getConstantValue()));
                        break;
                    }
                    case INT: {
                        printWriter.append('I');
                        printWriter.append(String.valueOf(variableElement.getConstantValue()));
                        break;
                    }
                    case LONG: {
                        printWriter.append('J');
                        printWriter.append(String.valueOf(variableElement.getConstantValue()));
                        break;
                    }
                    case CHAR: {
                        printWriter.append('C');
                        SymbolDumper.appendEscapedString(printWriter, String.valueOf(variableElement.getConstantValue()));
                        break;
                    }
                    case FLOAT: {
                        printWriter.append('F');
                        printWriter.append(String.valueOf(variableElement.getConstantValue()));
                        break;
                    }
                    case DOUBLE: {
                        printWriter.append('D');
                        printWriter.append(String.valueOf(variableElement.getConstantValue()));
                        break;
                    }
                    case DECLARED: {
                        printWriter.append('L');
                        TypeMirror typeMirror = variableElement.asType();
                        if (typeMirror.getKind() == TypeKind.DECLARED && "java.lang.String".equals(((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString())) {
                            SymbolDumper.appendEscapedString(printWriter, String.valueOf(variableElement.getConstantValue()));
                            break;
                        }
                        break block13;
                    }
                    default: {
                        printWriter.append("X");
                        break;
                    }
                }
                break block13;
            }
            printWriter.append("X");
        }
        printWriter.append(";");
        SymbolDumper.dumpAnnotations(symbolDumper, variableElement);
        return symbolDumper.hasErrors;
    }

    private static boolean dumpImpl(PrintWriter printWriter, Types types, ExecutableElement executableElement) {
        SymbolDumper symbolDumper = new SymbolDumper(printWriter, types);
        ExecutableType executableType = (ExecutableType)executableElement.asType();
        printWriter.append('E');
        SymbolDumper.dumpFlags(printWriter, ((Symbol)((Object)executableElement)).flags_field);
        SymbolDumper.dumpTypeVariables(symbolDumper, executableType.getTypeVariables());
        SymbolDumper.dumpName(printWriter, executableElement.getSimpleName());
        printWriter.append('(');
        java.util.List<? extends TypeMirror> list = executableType.getParameterTypes();
        java.util.List<? extends VariableElement> list2 = executableElement.getParameters();
        assert (list2.size() == list.size());
        for (int i = 0; i < list.size(); ++i) {
            SymbolDumper.dumpFlags(printWriter, ((Symbol)((Object)list2.get((int)i))).flags_field);
            symbolDumper.visit(list.get(i), Boolean.FALSE);
            SymbolDumper.dumpName(printWriter, list2.get(i).getSimpleName());
        }
        printWriter.append(')');
        printWriter.append('(');
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            symbolDumper.visit(typeMirror);
        }
        printWriter.append(')');
        symbolDumper.visit(executableType.getReturnType());
        SymbolDumper.dumpAnnotations(symbolDumper, executableElement);
        AnnotationValue annotationValue = executableElement.getDefaultValue();
        if (annotationValue != null) {
            new AnnotationValueVisitorImpl().visit(annotationValue, symbolDumper);
        } else {
            printWriter.append(';');
        }
        return symbolDumper.hasErrors;
    }

    private static void appendEscapedString(PrintWriter printWriter, String string) {
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll("@", "\\\\a");
        string = string.replaceAll(";", "\\\\b");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ') {
                stringBuffer.append('\\');
                String string2 = Integer.toHexString(c);
                stringBuffer.append("0000".substring(0, 4 - string2.length()));
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c);
        }
        printWriter.append(stringBuffer.toString());
    }

    private static void dumpName(PrintWriter printWriter, CharSequence charSequence) {
        printWriter.append('N');
        printWriter.append(((Object)charSequence).toString());
        printWriter.append(';');
    }

    private static void dumpTypeVariables(SymbolDumper symbolDumper, java.util.List<? extends TypeVariable> list) {
        if (list.isEmpty()) {
            return;
        }
        symbolDumper.output.append('<');
        symbolDumper.visit(list, Boolean.TRUE);
        symbolDumper.output.append('>');
    }

    private static void dumpFlags(PrintWriter printWriter, long l) {
        printWriter.append('M');
        printWriter.append(Long.toHexString(l));
        printWriter.append(';');
    }

    private static void dumpAnnotations(SymbolDumper symbolDumper, Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            SymbolDumper.dumpAnnotation(symbolDumper, annotationMirror);
        }
        symbolDumper.output.append(';');
    }

    private static void dumpAnnotation(SymbolDumper symbolDumper, AnnotationMirror annotationMirror) {
        symbolDumper.visit(annotationMirror.getAnnotationType());
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            SymbolDumper.dumpName(symbolDumper.output, entry.getKey().getSimpleName().toString());
            new AnnotationValueVisitorImpl().visit(entry.getValue(), symbolDumper);
        }
        symbolDumper.output.append(';');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationValueVisitorImpl
    extends SimpleAnnotationValueVisitor6<Void, SymbolDumper> {
        private AnnotationValueVisitorImpl() {
        }

        @Override
        public Void visitBoolean(boolean bl, SymbolDumper symbolDumper) {
            symbolDumper.output.append('Z');
            symbolDumper.output.append(String.valueOf(bl));
            symbolDumper.output.append(';');
            return null;
        }

        @Override
        public Void visitByte(byte by, SymbolDumper symbolDumper) {
            symbolDumper.output.append('B');
            symbolDumper.output.append(String.valueOf(by));
            symbolDumper.output.append(';');
            return null;
        }

        @Override
        public Void visitChar(char c, SymbolDumper symbolDumper) {
            symbolDumper.output.append('C');
            SymbolDumper.appendEscapedString(symbolDumper.output, String.valueOf(c));
            symbolDumper.output.append(';');
            return null;
        }

        @Override
        public Void visitDouble(double d, SymbolDumper symbolDumper) {
            symbolDumper.output.append('D');
            symbolDumper.output.append(String.valueOf(d));
            symbolDumper.output.append(';');
            return null;
        }

        @Override
        public Void visitFloat(float f, SymbolDumper symbolDumper) {
            symbolDumper.output.append('F');
            symbolDumper.output.append(String.valueOf(f));
            symbolDumper.output.append(';');
            return null;
        }

        @Override
        public Void visitInt(int n, SymbolDumper symbolDumper) {
            symbolDumper.output.append('I');
            symbolDumper.output.append(String.valueOf(n));
            symbolDumper.output.append(';');
            return null;
        }

        @Override
        public Void visitLong(long l, SymbolDumper symbolDumper) {
            symbolDumper.output.append('J');
            symbolDumper.output.append(String.valueOf(l));
            symbolDumper.output.append(';');
            return null;
        }

        @Override
        public Void visitShort(short s, SymbolDumper symbolDumper) {
            symbolDumper.output.append('S');
            symbolDumper.output.append(String.valueOf(s));
            symbolDumper.output.append(';');
            return null;
        }

        @Override
        public Void visitString(String string, SymbolDumper symbolDumper) {
            symbolDumper.output.append('L');
            SymbolDumper.appendEscapedString(symbolDumper.output, String.valueOf(string));
            symbolDumper.output.append(';');
            return null;
        }

        @Override
        public Void visitType(TypeMirror typeMirror, SymbolDumper symbolDumper) {
            symbolDumper.output.append('Y');
            symbolDumper.visit(typeMirror);
            return null;
        }

        @Override
        public Void visitEnumConstant(VariableElement variableElement, SymbolDumper symbolDumper) {
            symbolDumper.output.append('O');
            symbolDumper.visit(variableElement.getEnclosingElement().asType());
            SymbolDumper.dumpName(symbolDumper.output, variableElement.getSimpleName());
            return null;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror annotationMirror, SymbolDumper symbolDumper) {
            symbolDumper.output.append('P');
            SymbolDumper.dumpAnnotation(symbolDumper, annotationMirror);
            return null;
        }

        @Override
        public Void visitArray(java.util.List<? extends AnnotationValue> list, SymbolDumper symbolDumper) {
            symbolDumper.output.append('[');
            for (AnnotationValue annotationValue : list) {
                this.visit(annotationValue, symbolDumper);
            }
            symbolDumper.output.append(';');
            return null;
        }

        @Override
        public Void visitUnknown(AnnotationValue annotationValue, SymbolDumper symbolDumper) {
            throw new UnsupportedOperationException("SymbolDumper should be fixed to incorporate unknown value: " + annotationValue);
        }
    }
}

