/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.source.Comment;
import org.netbeans.modules.java.source.query.CommentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentSetImpl
implements Cloneable,
CommentSet {
    private final List<Comment> precedingComments = new ArrayList<Comment>();
    private final List<Comment> trailingComments = new ArrayList<Comment>();
    private boolean commentsMapped;

    @Override
    public void addPrecedingComment(String string) {
        this.addPrecedingComment(Comment.create(string));
        this.commentsMapped();
    }

    @Override
    public void addPrecedingComment(Comment comment) {
        this.precedingComments.add(comment);
        this.commentsMapped();
    }

    @Override
    public void addPrecedingComments(List<Comment> list) {
        this.precedingComments.addAll(list);
        this.commentsMapped();
    }

    @Override
    public void addTrailingComment(String string) {
        this.addTrailingComment(Comment.create(string));
        this.commentsMapped();
    }

    @Override
    public void addTrailingComment(Comment comment) {
        this.trailingComments.add(comment);
        this.commentsMapped();
    }

    @Override
    public void addTrailingComments(List<Comment> list) {
        this.trailingComments.addAll(list);
        this.commentsMapped();
    }

    @Override
    public List<Comment> getPrecedingComments() {
        return this.precedingComments;
    }

    @Override
    public List<Comment> getTrailingComments() {
        return this.trailingComments;
    }

    @Override
    public boolean hasComments() {
        return this.precedingComments.size() > 0 || this.trailingComments.size() > 0;
    }

    @Override
    public int pos() {
        return this.precedingComments.size() > 0 ? this.precedingComments.get(0).pos() : -2;
    }

    @Override
    public boolean hasChanges() {
        for (Comment comment : this.precedingComments) {
            if (!comment.isNew()) continue;
            return true;
        }
        for (Comment comment : this.trailingComments) {
            if (!comment.isNew()) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Unexpected " + cloneNotSupportedException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        stringBuffer.append('{');
        for (Comment comment : this.precedingComments) {
            if (!bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append(comment.getText());
            bl = false;
        }
        for (Comment comment : this.trailingComments) {
            if (!bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append(comment.getText());
            bl = false;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public boolean areCommentsMapped() {
        return this.commentsMapped;
    }

    public void commentsMapped() {
        this.commentsMapped = true;
    }
}

