/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.source.JavaSourceSupportAccessor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OpenedEditors
implements PropertyChangeListener {
    private List<JTextComponent> visibleEditors = new ArrayList<JTextComponent>();
    private Map<JTextComponent, DataObject> visibleEditors2Files = new HashMap<JTextComponent, DataObject>();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static OpenedEditors DEFAULT;

    private OpenedEditors() {
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                OpenedEditors.this.stateChanged();
            }
        });
    }

    public static synchronized OpenedEditors getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new OpenedEditors();
        }
        return DEFAULT;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        ArrayList<ChangeListener> arrayList = null;
        OpenedEditors openedEditors = this;
        synchronized (openedEditors) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public synchronized List<JTextComponent> getVisibleEditors() {
        LinkedList<JTextComponent> linkedList = new LinkedList<JTextComponent>();
        for (JTextComponent jTextComponent : this.visibleEditors) {
            if (this.visibleEditors2Files.get(jTextComponent) == null) continue;
            linkedList.add(jTextComponent);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public synchronized Collection<FileObject> getVisibleEditorsFiles() {
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        for (DataObject dataObject : this.visibleEditors2Files.values()) {
            if (dataObject == null) continue;
            linkedList.add(dataObject.getPrimaryFile());
        }
        return Collections.unmodifiableCollection(linkedList);
    }

    public synchronized void stateChanged() {
        JTextComponent jTextComponent2;
        for (JTextComponent jTextComponent2 : this.visibleEditors) {
            jTextComponent2.removePropertyChangeListener(this);
            DataObject dataObject = this.visibleEditors2Files.remove(jTextComponent2);
            if (dataObject == null) continue;
            dataObject.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.visibleEditors.clear();
        JTextComponent jTextComponent3 = EditorRegistry.lastFocusedComponent();
        Object object = jTextComponent2 = jTextComponent3 != null ? OpenedEditors.getDataObject(jTextComponent3) : null;
        if (jTextComponent3 instanceof JEditorPane && jTextComponent2 != null && JavaSource.forFileObject(jTextComponent2.getPrimaryFile()) != null) {
            this.visibleEditors.add(jTextComponent3);
        }
        for (JTextComponent jTextComponent4 : this.visibleEditors) {
            jTextComponent4.addPropertyChangeListener(this);
            DataObject dataObject = OpenedEditors.getDataObject(jTextComponent4);
            dataObject.addPropertyChangeListener((PropertyChangeListener)this);
            this.visibleEditors2Files.put(jTextComponent4, dataObject);
        }
        this.fireChangeEvent();
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof DataObject && "primaryFile".equals(propertyChangeEvent.getPropertyName())) {
            this.fireChangeEvent();
            return;
        }
        if (propertyChangeEvent.getSource() instanceof JTextComponent) {
            DataObject dataObject;
            JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getSource();
            DataObject dataObject2 = this.visibleEditors2Files.get(jTextComponent);
            if (dataObject2 != (dataObject = OpenedEditors.getDataObject(jTextComponent))) {
                this.visibleEditors2Files.put(jTextComponent, dataObject);
                this.fireChangeEvent();
            }
            return;
        }
    }

    private static DataObject getDataObject(JTextComponent jTextComponent) {
        Object object = jTextComponent.getDocument().getProperty("stream");
        if (!(object instanceof DataObject)) {
            return null;
        }
        return (DataObject)object;
    }

    static FileObject getFileObject(JTextComponent jTextComponent) {
        DataObject dataObject = OpenedEditors.getDataObject(jTextComponent);
        return dataObject != null ? dataObject.getPrimaryFile() : null;
    }

    public static boolean isSupported(FileObject fileObject, String ... stringArray) throws NullPointerException {
        Parameters.notNull((CharSequence)"files", (Object)fileObject);
        return !OpenedEditors.filterSupportedMIMETypes(Collections.singletonList(fileObject), stringArray).isEmpty();
    }

    public static List<FileObject> filterSupportedMIMETypes(Collection<FileObject> collection, String ... stringArray) throws NullPointerException {
        Parameters.notNull((CharSequence)"files", collection);
        boolean bl = false;
        if (stringArray == null) {
            stringArray = new String[]{"text/x-java"};
            bl = true;
        }
        List<String> list = Arrays.asList(stringArray);
        boolean bl2 = list.contains("*");
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        Logger.getLogger(OpenedEditors.class.getName()).log(Level.FINER, "mimeTypesList={0}", list);
        block0: for (FileObject fileObject : collection) {
            int n;
            int n2;
            Logger.getLogger(OpenedEditors.class.getName()).log(Level.FINER, "analyzing={0}", fileObject);
            if (JavaSource.forFileObject(fileObject) == null) continue;
            if (bl2) {
                linkedList.add(fileObject);
                continue;
            }
            if (bl && "java".equals(fileObject.getExt())) {
                linkedList.add(fileObject);
                continue;
            }
            String string = FileUtil.getMIMEType((FileObject)fileObject);
            Logger.getLogger(OpenedEditors.class.getName()).log(Level.FINER, "fileMimeType={0}", string);
            if (list.contains(string)) {
                linkedList.add(fileObject);
                continue;
            }
            String string2 = string;
            while ((n2 = string2.indexOf(47)) != -1 && (n = string2.indexOf(43, n2)) != -1) {
                if (!list.contains(string2 = string2.substring(0, n2 + 1) + string2.substring(n + 1))) continue;
                linkedList.add(fileObject);
                continue block0;
            }
        }
        Logger.getLogger(OpenedEditors.class.getName()).log(Level.FINE, "filter({0}, {1})={2}", new Object[]{collection, list, linkedList});
        return linkedList;
    }

    static {
        JavaSourceSupportAccessor.ACCESSOR = new JavaSourceSupportAccessor(){

            @Override
            public Collection<FileObject> getVisibleEditorsFiles() {
                return OpenedEditors.getDefault().getVisibleEditorsFiles();
            }
        };
    }
}

