/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfoImpl;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.PositionConverter;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.TreeFactory;
import org.netbeans.modules.java.source.engine.SourceReader;
import org.netbeans.modules.java.source.engine.SourceRewriter;
import org.netbeans.modules.java.source.pretty.ImportAnalysis2;
import org.netbeans.modules.java.source.pretty.VeryPretty;
import org.netbeans.modules.java.source.save.CasualDiff;
import org.netbeans.modules.java.source.transform.ImmutableTreeTranslator;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingCopy
extends CompilationController {
    private Map<Tree, Tree> changes;
    private Map<JavaFileObject, CompilationUnitTree> externalChanges;
    private Set<CasualDiff.Diff> textualChanges;
    private Map<Integer, String> userInfo;
    private boolean afterCommit = false;
    private TreeMaker treeMaker;
    private static boolean REWRITE_WHOLE_FILE = Boolean.getBoolean(WorkingCopy.class.getName() + ".rewrite-whole-file");

    WorkingCopy(CompilationInfoImpl compilationInfoImpl) {
        super(compilationInfoImpl);
    }

    private synchronized void init() {
        if (this.changes != null) {
            return;
        }
        this.treeMaker = new TreeMaker(this, TreeFactory.instance(this.getContext()));
        this.changes = new IdentityHashMap<Tree, Tree>();
        this.externalChanges = null;
        this.textualChanges = new HashSet<CasualDiff.Diff>();
        this.userInfo = new HashMap<Integer, String>();
    }

    private Context getContext() {
        return this.impl.getJavacTask().getContext();
    }

    @Override
    public JavaSource.Phase toPhase(JavaSource.Phase phase) throws IOException {
        JavaSource.Phase phase2 = super.toPhase(phase);
        if (phase2.compareTo(JavaSource.Phase.PARSED) >= 0) {
            this.init();
        }
        return phase2;
    }

    public synchronized TreeMaker getTreeMaker() {
        this.checkConfinement();
        if (this.treeMaker == null) {
            throw new IllegalStateException("Cannot call getTreeMaker before toPhase.");
        }
        return this.treeMaker;
    }

    Map<Tree, Tree> getChangeSet() {
        return this.changes;
    }

    public synchronized void rewrite(Tree tree, Tree tree2) {
        this.checkConfinement();
        if (this.changes == null) {
            throw new IllegalStateException("Cannot call rewrite before toPhase.");
        }
        if (tree == tree2) {
            return;
        }
        if (tree == null && Tree.Kind.COMPILATION_UNIT == tree2.getKind()) {
            this.createCompilationUnit((JCTree.JCCompilationUnit)tree2);
            return;
        }
        if (tree == null || tree2 == null) {
            throw new IllegalArgumentException("Null values are not allowed.");
        }
        this.changes.put(tree, tree2);
    }

    public synchronized void rewriteInComment(int n, int n2, String string) throws IllegalArgumentException {
        int n3;
        int n4;
        this.checkConfinement();
        TokenSequence tokenSequence = this.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            throw new IllegalArgumentException("Cannot rewriteInComment start=" + n + ", text length=" + this.getText().length());
        }
        if (tokenSequence.token().id() != JavaTokenId.LINE_COMMENT && tokenSequence.token().id() != JavaTokenId.BLOCK_COMMENT && tokenSequence.token().id() != JavaTokenId.JAVADOC_COMMENT) {
            throw new IllegalArgumentException("Cannot rewriteInComment: attempt to rewrite non-comment token: " + tokenSequence.token().id());
        }
        if (tokenSequence.offset() + tokenSequence.token().length() <= n + n2) {
            throw new IllegalArgumentException("Cannot rewriteInComment: attempt to rewrite text after comment token. Token end offset: " + (tokenSequence.offset() + tokenSequence.token().length()) + ", rewrite end offset: " + (n + n2));
        }
        switch ((JavaTokenId)tokenSequence.token().id()) {
            case LINE_COMMENT: {
                n4 = 2;
                n3 = 0;
                break;
            }
            case BLOCK_COMMENT: {
                n4 = 2;
                n3 = 2;
                break;
            }
            case JAVADOC_COMMENT: {
                n4 = 3;
                n3 = 2;
                break;
            }
            default: {
                throw new IllegalStateException("Internal error");
            }
        }
        if (tokenSequence.offset() + n4 > n) {
            throw new IllegalArgumentException("Cannot rewriteInComment: attempt to rewrite comment prefix");
        }
        if (tokenSequence.offset() + tokenSequence.token().length() - n3 < n + n2) {
            throw new IllegalArgumentException("Cannot rewriteInComment: attempt to rewrite comment suffix");
        }
        this.textualChanges.add(CasualDiff.Diff.delete(n, n + n2));
        this.textualChanges.add(CasualDiff.Diff.insert(n + n2, string));
        this.userInfo.put(n, NbBundle.getMessage(CasualDiff.class, (String)"TXT_RenameInComment"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void commit(CompilationUnitTree compilationUnitTree, List<CasualDiff.Diff> list, SourceRewriter sourceRewriter) throws IOException, BadLocationException {
        CharArrayReader charArrayReader = null;
        try {
            String string = ((Object)((JCTree.JCCompilationUnit)compilationUnitTree).sourcefile.getCharContent(true)).toString();
            char[] cArray = string.toCharArray();
            charArrayReader = new SourceReader(cArray);
            block6: for (CasualDiff.Diff diff : list) {
                switch (diff.type) {
                    case INSERT: {
                        sourceRewriter.copyTo((SourceReader)charArrayReader, diff.getPos());
                        sourceRewriter.writeTo(diff.getText());
                        continue block6;
                    }
                    case DELETE: {
                        sourceRewriter.copyTo((SourceReader)charArrayReader, diff.getPos());
                        sourceRewriter.skipThrough((SourceReader)charArrayReader, diff.getEnd());
                        continue block6;
                    }
                }
                throw new AssertionError((Object)("unknown CasualDiff type: " + (Object)((Object)diff.type)));
            }
            sourceRewriter.copyRest((SourceReader)charArrayReader);
            Object var9_8 = null;
            if (charArrayReader == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (charArrayReader == null) throw throwable;
            charArrayReader.close();
            throw throwable;
        }
        charArrayReader.close();
    }

    private List<ModificationResult.Difference> processCurrentCompilationUnit() throws IOException, BadLocationException {
        Iterable<Tree> iterable;
        final HashSet<TreePath> hashSet = new HashSet<TreePath>();
        final IdentityHashMap<TreePath, Map<Tree, Tree>> identityHashMap = new IdentityHashMap<TreePath, Map<Tree, Tree>>();
        boolean bl = true;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        if (!REWRITE_WHOLE_FILE) {
            new TreePathScanner<Void, Void>(){
                private TreePath currentParent;
                private Map<Tree, TreePath> tree2Path = new IdentityHashMap<Tree, TreePath>();

                private TreePath getParentPath(TreePath treePath, Tree tree) {
                    Tree tree2 = treePath != null ? treePath.getLeaf() : tree;
                    TreePath treePath2 = this.tree2Path.get(tree2);
                    if (treePath2 == null) {
                        treePath2 = treePath != null ? treePath : new TreePath((CompilationUnitTree)tree);
                        this.tree2Path.put(tree2, treePath2);
                    }
                    return treePath2;
                }

                @Override
                public Void scan(Tree tree, Void void_) {
                    boolean bl = false;
                    if (WorkingCopy.this.changes.containsKey(tree)) {
                        if (this.currentParent == null) {
                            bl = true;
                            this.currentParent = this.getParentPath(this.getCurrentPath(), tree);
                            hashSet.add(this.currentParent);
                            if (!identityHashMap.containsKey(this.currentParent)) {
                                identityHashMap.put(this.currentParent, new IdentityHashMap());
                            }
                        }
                        Map map = (Map)identityHashMap.get(this.currentParent);
                        Tree tree2 = (Tree)WorkingCopy.this.changes.remove(tree);
                        map.put(tree, tree2);
                        this.scan(tree2, void_);
                        if (bl) {
                            this.currentParent = null;
                        }
                    } else {
                        super.scan(tree, void_);
                    }
                    return null;
                }
            }.scan((Tree)this.getCompilationUnit(), (Void)null);
        } else {
            iterable = new TreePath(this.getCompilationUnit());
            hashSet.add((TreePath)iterable);
            identityHashMap.put((TreePath)iterable, this.changes);
            bl = false;
        }
        iterable = new ArrayList();
        ImportAnalysis2 importAnalysis2 = new ImportAnalysis2(this.getContext());
        boolean bl2 = false;
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            TreePath treePath = (TreePath)object.next();
            Translator translator = new Translator();
            ArrayList<ClassTree> arrayList = new ArrayList<ClassTree>();
            if (treePath.getParentPath() != null) {
                for (Tree tree : treePath) {
                    if (tree.getKind() == Tree.Kind.COMPILATION_UNIT && !bl2) {
                        Tree tree22 = (CompilationUnitTree)tree;
                        importAnalysis2.setPackage(tree22.getPackageName());
                        importAnalysis2.setImports(tree22.getImports());
                    }
                    if (tree.getKind() != Tree.Kind.CLASS) continue;
                    arrayList.add((ClassTree)tree);
                }
            }
            Collections.reverse(arrayList);
            for (ClassTree classTree : arrayList) {
                importAnalysis2.classEntered(classTree);
            }
            translator.attach(this.getContext(), importAnalysis2, this.getCompilationUnit());
            Tree tree2 = translator.translate(treePath.getLeaf(), (Map)identityHashMap.get(treePath));
            for (Tree tree22 : arrayList) {
                importAnalysis2.classLeft();
            }
            if (tree2.getKind() == Tree.Kind.COMPILATION_UNIT) {
                bl = false;
            }
            iterable.addAll(CasualDiff.diff(this.getContext(), this, treePath, (JCTree)tree2, hashMap));
        }
        if (bl && (object = importAnalysis2.getImports()) != null) {
            iterable.addAll(CasualDiff.diff(this.getContext(), this, this.getCompilationUnit().getImports(), (List<? extends ImportTree>)object, hashMap));
        }
        iterable.addAll(this.textualChanges);
        hashMap.putAll(this.userInfo);
        Collections.sort(iterable, new Comparator<CasualDiff.Diff>(){

            @Override
            public int compare(CasualDiff.Diff diff, CasualDiff.Diff diff2) {
                return diff.getPos() - diff2.getPos();
            }
        });
        object = new Rewriter(this.getFileObject(), this.getPositionConverter(), hashMap);
        WorkingCopy.commit(this.getCompilationUnit(), iterable, (SourceRewriter)object);
        return ((Rewriter)object).diffs;
    }

    private List<ModificationResult.Difference> processExternalCUs() {
        if (this.externalChanges == null) {
            return Collections.emptyList();
        }
        LinkedList<ModificationResult.Difference> linkedList = new LinkedList<ModificationResult.Difference>();
        for (CompilationUnitTree compilationUnitTree : this.externalChanges.values()) {
            Translator translator = new Translator();
            translator.attach(this.getContext(), new ImportAnalysis2(this.getContext()), compilationUnitTree);
            CompilationUnitTree compilationUnitTree2 = (CompilationUnitTree)translator.translate(compilationUnitTree, this.changes);
            VeryPretty veryPretty = new VeryPretty(this.getContext());
            veryPretty.print((JCTree.JCCompilationUnit)compilationUnitTree2);
            linkedList.add(new ModificationResult.CreateChange(compilationUnitTree2.getSourceFile(), veryPretty.toString()));
        }
        return linkedList;
    }

    List<ModificationResult.Difference> getChanges() throws IOException, BadLocationException {
        if (this.afterCommit) {
            throw new IllegalStateException("The commit method can be called only once on a WorkingCopy instance");
        }
        this.afterCommit = true;
        if (this.changes == null) {
            return null;
        }
        LinkedList<ModificationResult.Difference> linkedList = new LinkedList<ModificationResult.Difference>();
        linkedList.addAll(this.processCurrentCompilationUnit());
        linkedList.addAll(this.processExternalCUs());
        return linkedList;
    }

    private void createCompilationUnit(JCTree.JCCompilationUnit jCCompilationUnit) {
        if (this.externalChanges == null) {
            this.externalChanges = new HashMap<JavaFileObject, CompilationUnitTree>();
        }
        this.externalChanges.put(jCCompilationUnit.getSourceFile(), jCCompilationUnit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Rewriter
    implements SourceRewriter {
        private int offset = 0;
        private CloneableEditorSupport ces;
        private PositionConverter converter;
        private List<ModificationResult.Difference> diffs = new LinkedList<ModificationResult.Difference>();
        private Map<Integer, String> userInfo;

        public Rewriter(FileObject fileObject, PositionConverter positionConverter, Map<Integer, String> map) throws IOException {
            this.converter = positionConverter;
            this.userInfo = map;
            if (fileObject != null) {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                CloneableEditorSupport cloneableEditorSupport = this.ces = dataObject != null ? (CloneableEditorSupport)dataObject.getCookie(EditorCookie.class) : null;
            }
            if (this.ces == null) {
                throw new IOException("Could not find CloneableEditorSupport for " + FileUtil.getFileDisplayName((FileObject)fileObject));
            }
        }

        @Override
        public void writeTo(String string) throws IOException, BadLocationException {
            ModificationResult.Difference difference;
            ModificationResult.Difference difference2 = difference = this.diffs.size() > 0 ? this.diffs.get(this.diffs.size() - 1) : null;
            if (difference != null && difference.getKind() == ModificationResult.Difference.Kind.REMOVE && difference.getEndPosition().getOffset() == this.offset) {
                difference.kind = ModificationResult.Difference.Kind.CHANGE;
                difference.newText = string;
            } else {
                int n;
                int n2 = n = this.converter != null ? this.converter.getOriginalPosition(this.offset) : this.offset;
                if (n >= 0) {
                    this.diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.INSERT, this.ces.createPositionRef(n, Position.Bias.Forward), this.ces.createPositionRef(n, Position.Bias.Backward), null, string, this.userInfo.get(this.offset)));
                }
            }
        }

        @Override
        public void skipThrough(SourceReader sourceReader, int n) throws IOException, BadLocationException {
            ModificationResult.Difference difference;
            char[] cArray = sourceReader.getCharsTo(n);
            ModificationResult.Difference difference2 = difference = this.diffs.size() > 0 ? this.diffs.get(this.diffs.size() - 1) : null;
            if (difference != null && difference.getKind() == ModificationResult.Difference.Kind.INSERT && difference.getStartPosition().getOffset() == this.offset) {
                difference.kind = ModificationResult.Difference.Kind.CHANGE;
                difference.oldText = new String(cArray);
            } else {
                int n2;
                int n3 = n2 = this.converter != null ? this.converter.getOriginalPosition(this.offset) : this.offset;
                if (n2 >= 0) {
                    this.diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.REMOVE, this.ces.createPositionRef(n2, Position.Bias.Forward), this.ces.createPositionRef(n2 + cArray.length, Position.Bias.Backward), new String(cArray), null, this.userInfo.get(this.offset)));
                }
            }
            this.offset += cArray.length;
        }

        @Override
        public void copyTo(SourceReader sourceReader, int n) throws IOException {
            char[] cArray = sourceReader.getCharsTo(n);
            this.offset += cArray.length;
        }

        @Override
        public void copyRest(SourceReader sourceReader) throws IOException {
        }

        @Override
        public void close(boolean bl) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Translator
    extends ImmutableTreeTranslator {
        private Map<Tree, Tree> changeMap;

        Translator() {
        }

        Tree translate(Tree tree, Map<Tree, Tree> map) {
            this.changeMap = new HashMap<Tree, Tree>(map);
            return this.translate(tree);
        }

        @Override
        public Tree translate(Tree tree) {
            assert (this.changeMap != null);
            if (tree == null) {
                return null;
            }
            Tree tree2 = this.changeMap.remove(tree);
            Tree tree3 = super.translate(tree2 != null ? tree2 : tree);
            return tree3;
        }
    }
}

