/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.breakpoints;

import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.debugger.BpelDebuggerImpl;
import org.netbeans.modules.bpel.debugger.api.EditorContextBridge;
import org.netbeans.modules.bpel.debugger.api.breakpoints.LineBreakpoint;

public abstract class SBYNBreakpoint {
    private LineBreakpoint myBreakpoint;
    private BpelDebuggerImpl myDebugger;
    private String myUrl;
    private String myXpath;
    private QName myProcessQName;

    protected SBYNBreakpoint(LineBreakpoint lineBreakpoint, BpelDebuggerImpl bpelDebuggerImpl) {
        this.myBreakpoint = lineBreakpoint;
        this.myDebugger = bpelDebuggerImpl;
        this.myUrl = lineBreakpoint.getURL();
        this.myXpath = lineBreakpoint.getXpath();
        this.myProcessQName = EditorContextBridge.getProcessQName((String)this.myUrl);
        if (this.myProcessQName == null) {
            this.myProcessQName = new QName("");
        }
    }

    protected BpelDebuggerImpl getDebugger() {
        return this.myDebugger;
    }

    public String getURL() {
        return this.myUrl;
    }

    public QName getProcessQName() {
        return this.myProcessQName;
    }

    public String getXpath() {
        return this.myXpath;
    }

    public boolean isEnabled() {
        return this.myBreakpoint.isEnabled();
    }

    public boolean isAt(QName qName, String string) {
        return this.getProcessQName().equals(qName) && this.getXpath().equals(string);
    }
}

