/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.bdiclient.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.bpel.debugger.BpelDebuggerImpl;
import org.netbeans.modules.bpel.debugger.BreakPosition;
import org.netbeans.modules.bpel.debugger.api.CorrelationSet;
import org.netbeans.modules.bpel.debugger.api.EvaluationException;
import org.netbeans.modules.bpel.debugger.api.Fault;
import org.netbeans.modules.bpel.debugger.api.InvalidStateException;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.RuntimePartnerLink;
import org.netbeans.modules.bpel.debugger.api.breakpoints.BpelFaultBreakpoint;
import org.netbeans.modules.bpel.debugger.api.pem.ProcessExecutionModel;
import org.netbeans.modules.bpel.debugger.api.variables.Value;
import org.netbeans.modules.bpel.debugger.api.variables.Variable;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.BDIDebugFrame;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.BDIDebugger;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.BpelProcessImpl;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.CorrelationSetImpl;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.FaultImpl;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.ProcessInstancesModelImpl;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.RuntimePartnerLinkImpl;
import org.netbeans.modules.bpel.debugger.eventlog.ActivityCompletedRecord;
import org.netbeans.modules.bpel.debugger.eventlog.ActivityStartedRecord;
import org.netbeans.modules.bpel.debugger.eventlog.ActivityTerminatedRecord;
import org.netbeans.modules.bpel.debugger.eventlog.BranchCompletedRecord;
import org.netbeans.modules.bpel.debugger.eventlog.BranchStartedRecord;
import org.netbeans.modules.bpel.debugger.eventlog.EventLog;
import org.netbeans.modules.bpel.debugger.eventlog.ProcessInstanceCompletedRecord;
import org.netbeans.modules.bpel.debugger.eventlog.ProcessInstanceStartedRecord;
import org.netbeans.modules.bpel.debugger.pem.ProcessExecutionModelImpl;
import org.netbeans.modules.bpel.debugger.variables.SimpleValueImpl;
import org.netbeans.modules.bpel.debugger.variables.SimpleVariableImpl;
import org.netbeans.modules.bpel.debugger.variables.Util;
import org.netbeans.modules.bpel.debugger.variables.WsdlMessageVariableImpl;
import org.netbeans.modules.bpel.debugger.variables.XmlElementValueImpl;
import org.netbeans.modules.bpel.debugger.variables.XmlElementVariableImpl;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.BPELPartnerLink;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.BPELProcessInstanceRef;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.BPELProcessRef;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.BPELVariable;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.DebugFrame;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.DebuggableEngine;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.VirtualBPELEngine;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.XpathExpressionException;
import org.w3c.dom.Element;

public class ProcessInstanceImpl
implements ProcessInstance {
    private final String myId;
    private final BpelProcessImpl myBpelProcess;
    private final ProcessInstancesModelImpl myModel;
    private final BPELProcessInstanceRef myProcessInstanceRef;
    private BreakPosition myBreakPosition;
    private BreakPosition myLastPosition;
    private Object myWaitLock = new Object();
    private Object mySyncLock = new Object();
    private AtomicInteger myState = new AtomicInteger(1);
    private boolean myIsUndeployed;
    private boolean myStepIntoFlag;
    private boolean myStepOverFlag;
    private boolean myStepOutFlag;
    private boolean myPauseFlag;
    private final List<BDIDebugFrame> myFrames = Collections.synchronizedList(new ArrayList());
    private EventLog myEventLog;
    private WeakReference<ProcessExecutionModelImpl> myPemRef;
    private List<Fault> myFaults = new LinkedList<Fault>();

    public ProcessInstanceImpl(ProcessInstancesModelImpl processInstancesModelImpl, BPELProcessInstanceRef bPELProcessInstanceRef) {
        this.myModel = processInstancesModelImpl;
        this.myProcessInstanceRef = bPELProcessInstanceRef;
        this.myBpelProcess = this.myModel.getProcess(this.myProcessInstanceRef.template());
        this.myId = bPELProcessInstanceRef.globalID();
    }

    public String getName() {
        return this.myBpelProcess.getName() + " #" + this.myId;
    }

    public int getState() {
        return this.myState.get();
    }

    public BreakPosition getCurrentPosition() {
        return this.myBreakPosition;
    }

    public void pause() {
        this.myPauseFlag = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.myWaitLock;
        synchronized (object) {
            this.myWaitLock.notifyAll();
        }
    }

    public void stepInto() {
        this.myStepIntoFlag = true;
        this.resume();
    }

    public void stepOver() {
        this.myStepOverFlag = true;
        this.myLastPosition = this.myBreakPosition;
        this.resume();
    }

    public void stepOut() {
        this.myStepOutFlag = true;
        this.myLastPosition = this.myBreakPosition;
        this.resume();
    }

    public void terminate() {
        VirtualBPELEngine virtualBPELEngine;
        BDIDebugger bDIDebugger = this.getDebugger().getBDIDebugger();
        if (bDIDebugger != null && (virtualBPELEngine = bDIDebugger.getVirtualBPELEngine()) != null) {
            virtualBPELEngine.terminatePI(this.myProcessInstanceRef.globalGUID());
        }
    }

    public String getId() {
        return this.myId;
    }

    public BpelProcessImpl getProcess() {
        return this.myBpelProcess;
    }

    public QName getProcessQName() {
        return this.myBpelProcess.getQName();
    }

    public Variable[] getVariables() {
        BDIDebugFrame bDIDebugFrame;
        DebuggableEngine debuggableEngine;
        BreakPosition breakPosition = this.myBreakPosition;
        if (breakPosition != null && (debuggableEngine = (bDIDebugFrame = breakPosition.getFrame()).getDebuggableEngine()) != null) {
            String[] stringArray = debuggableEngine.getVariables();
            Variable[] variableArray = new Variable[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                BPELVariable bPELVariable = debuggableEngine.getVariable(string);
                if (bPELVariable == null) continue;
                variableArray[i] = bPELVariable.isWSDLMessage() ? new WsdlMessageVariableImpl(string, breakPosition, bPELVariable) : (bPELVariable.isSimpleType() ? new SimpleVariableImpl(string, breakPosition, bPELVariable) : new XmlElementVariableImpl(string, breakPosition, bPELVariable));
            }
            return variableArray;
        }
        return new Variable[0];
    }

    public RuntimePartnerLink[] getRuntimePartnerLinks() {
        BDIDebugFrame bDIDebugFrame;
        DebuggableEngine debuggableEngine;
        BreakPosition breakPosition = this.myBreakPosition;
        if (breakPosition != null && (debuggableEngine = (bDIDebugFrame = breakPosition.getFrame()).getDebuggableEngine()) != null) {
            String[] stringArray = debuggableEngine.getPartnerLinks();
            RuntimePartnerLink[] runtimePartnerLinkArray = new RuntimePartnerLink[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                BPELPartnerLink bPELPartnerLink = debuggableEngine.getPartnerLink(stringArray[i]);
                if (bPELPartnerLink == null) continue;
                runtimePartnerLinkArray[i] = new RuntimePartnerLinkImpl(bPELPartnerLink);
            }
            return runtimePartnerLinkArray;
        }
        return new RuntimePartnerLink[0];
    }

    public CorrelationSet[] getCorrelationSets() {
        LinkedList<CorrelationSetImpl> linkedList = new LinkedList<CorrelationSetImpl>();
        BPELProcessRef bPELProcessRef = this.myBpelProcess.getProcessRef();
        for (String string : bPELProcessRef.allCorrelationSetsNames()) {
            String string2 = this.myProcessInstanceRef.getCorrelationSetValue(string);
            if (string2 == null) {
                linkedList.add(new CorrelationSetImpl(string, bPELProcessRef.getCorrelationSetId(string), null, new QName[0], new QName[0], new String[0]));
                continue;
            }
            String[] stringArray = this.myProcessInstanceRef.getCorrelationSetPropertyNames(string);
            String[] stringArray2 = this.myProcessInstanceRef.getCorrelationSetPropertyTypes(string);
            String[] stringArray3 = this.myProcessInstanceRef.getCorrelationSetPropertyValues(string);
            QName[] qNameArray = new QName[stringArray.length];
            QName[] qNameArray2 = new QName[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray4 = stringArray[i].split("\n");
                qNameArray[i] = new QName(stringArray4[0], stringArray4[2], stringArray4[1]);
                stringArray4 = stringArray2[i].split("\n");
                qNameArray2[i] = new QName(stringArray4[0], stringArray4[2], stringArray4[1]);
            }
            linkedList.add(new CorrelationSetImpl(string, bPELProcessRef.getCorrelationSetId(string), string2, qNameArray, qNameArray2, stringArray3));
        }
        return linkedList.toArray(new CorrelationSet[linkedList.size()]);
    }

    public Fault[] getFaults() {
        return this.myFaults.toArray(new Fault[this.myFaults.size()]);
    }

    public Value evaluate(String string) throws InvalidStateException, EvaluationException {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        BreakPosition breakPosition = this.myBreakPosition;
        if (breakPosition != null) {
            BDIDebugFrame bDIDebugFrame = breakPosition.getFrame();
            DebuggableEngine debuggableEngine = bDIDebugFrame.getDebuggableEngine();
            if (debuggableEngine != null) {
                try {
                    String string2 = debuggableEngine.evaluate(string);
                    if (string2 != null) {
                        Element element = Util.parseXmlElement(string2);
                        if (element != null) {
                            return new XmlElementValueImpl(element);
                        }
                        return new SimpleValueImpl(string2);
                    }
                }
                catch (XpathExpressionException xpathExpressionException) {
                    throw new EvaluationException("Can not evaluate the expression", (Throwable)xpathExpressionException);
                }
            }
        } else {
            throw new InvalidStateException("Process instance is not suspended");
        }
        return null;
    }

    public EventLog getEventLog() {
        return this.myEventLog;
    }

    public ProcessExecutionModelImpl getProcessExecutionModel() {
        ProcessExecutionModelImpl processExecutionModelImpl = null;
        if (this.myPemRef != null) {
            processExecutionModelImpl = (ProcessExecutionModelImpl)this.myPemRef.get();
        }
        if (processExecutionModelImpl == null) {
            processExecutionModelImpl = ProcessExecutionModelImpl.build(this);
            this.myPemRef = new WeakReference<ProcessExecutionModelImpl>(processExecutionModelImpl);
        }
        return processExecutionModelImpl;
    }

    protected void setUndeployed(boolean bl) {
        this.myIsUndeployed = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onActivityStarted(BreakPosition breakPosition) {
        if (this.getDebugger().getState() != 2) {
            return;
        }
        if (this.myIsUndeployed) {
            return;
        }
        Object object = this.mySyncLock;
        synchronized (object) {
            String string;
            if (this.myEventLog != null) {
                this.myEventLog.addRecord(new ActivityStartedRecord(breakPosition.getFrame().getId(), breakPosition.getXpath()));
            }
            if ((string = this.getDebugger().getSourcePath().getSourcePath(breakPosition.getProcessQName())) == null) {
                return;
            }
            if (this.myPauseFlag || this.stepIntoSatisfied(breakPosition) || this.stepOverSatisfied(breakPosition) || this.stepOutSatisfied(breakPosition) || this.getDebugger().hasBreakpoint(string, breakPosition.getXpath())) {
                this.myPauseFlag = false;
                this.myStepIntoFlag = false;
                this.myStepOverFlag = false;
                this.myStepOutFlag = false;
                this.getDebugger().clearRunToCursorBreakpoint();
                this.getProcessExecutionModel().setCurrentBranchWithoutResume(breakPosition.getBranchId());
                this.myBreakPosition = breakPosition;
                this.setState(2);
                this.doWait();
                this.myBreakPosition = null;
                this.setState(1);
            } else {
                this.setState(1);
            }
        }
    }

    protected void onActivityCompleted(BreakPosition breakPosition) {
        if (this.myEventLog != null) {
            this.myEventLog.addRecord(new ActivityCompletedRecord(breakPosition.getFrame().getId(), breakPosition.getXpath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFault(BreakPosition breakPosition, String string, BPELVariable bPELVariable) {
        if (this.getDebugger().getState() != 2) {
            return;
        }
        if (this.myIsUndeployed) {
            return;
        }
        Object object = this.mySyncLock;
        synchronized (object) {
            Object object2;
            QName qName;
            if (string == null || string.trim().equals("")) {
                qName = null;
            } else {
                object2 = string.split("\n");
                qName = new QName(object2[0], object2[2], object2[1]);
            }
            if (bPELVariable == null) {
                this.myFaults.add(new FaultImpl(qName, breakPosition.getXpath(), null));
            } else if (bPELVariable.isWSDLMessage()) {
                this.myFaults.add(new FaultImpl(qName, breakPosition.getXpath(), new WsdlMessageVariableImpl("faultData", breakPosition, bPELVariable)));
            } else if (bPELVariable.isSimpleType()) {
                this.myFaults.add(new FaultImpl(qName, breakPosition.getXpath(), new SimpleVariableImpl("faultData", breakPosition, bPELVariable)));
            } else {
                this.myFaults.add(new FaultImpl(qName, breakPosition.getXpath(), new XmlElementVariableImpl("faultData", breakPosition, bPELVariable)));
            }
            object2 = this.getDebugger().getSourcePath().getSourcePath(breakPosition.getProcessQName());
            if (object2 == null) {
                return;
            }
            Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
            boolean bl = false;
            for (Breakpoint breakpoint : breakpointArray) {
                if (!(breakpoint instanceof BpelFaultBreakpoint)) continue;
                BpelFaultBreakpoint bpelFaultBreakpoint = (BpelFaultBreakpoint)breakpoint;
                if (!breakpoint.isEnabled() || !bpelFaultBreakpoint.getProcessQName().equals(breakPosition.getProcessQName())) continue;
                if (bpelFaultBreakpoint.getFaultQName() == null) {
                    bl = true;
                    break;
                }
                if (!bpelFaultBreakpoint.getFaultQName().equals(qName)) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.myStepIntoFlag = false;
                this.getDebugger().clearRunToCursorBreakpoint();
                this.myBreakPosition = breakPosition;
                this.setState(2);
                this.doWait();
                this.myBreakPosition = null;
                this.setState(1);
            }
        }
    }

    protected void onXpathException(DebugFrame debugFrame) {
        if (this.getRootFrame() == debugFrame) {
            this.setState(4);
        }
    }

    protected void onProcessInstanceStarted() {
        this.myEventLog = new EventLog();
        this.myEventLog.addRecord(new ProcessInstanceStartedRecord());
    }

    protected void onProcessInstanceDied() {
        this.setState(3);
        if (this.myEventLog != null) {
            this.myEventLog.addRecord(new ProcessInstanceCompletedRecord());
        }
        this.myModel.processInstanceCompleted(this);
    }

    protected void onTerminate(BreakPosition breakPosition) {
        if (this.myEventLog != null) {
            this.myEventLog.addRecord(new ActivityTerminatedRecord(breakPosition.getFrame().getId(), breakPosition.getXpath()));
        }
    }

    protected void onExit(BDIDebugFrame bDIDebugFrame) {
        if (this.myEventLog != null) {
            this.myEventLog.addRecord(new BranchCompletedRecord(bDIDebugFrame.getId()));
        }
    }

    protected BDIDebugFrame addFrame(String string, String string2) {
        BDIDebugFrame bDIDebugFrame = new BDIDebugFrame(this, string);
        this.myFrames.add(bDIDebugFrame);
        if (this.myEventLog != null) {
            this.myEventLog.addRecord(new BranchStartedRecord(string, string2));
        }
        return bDIDebugFrame;
    }

    private void setState(int n) {
        int n2 = this.myState.getAndSet(n);
        this.myModel.processInstanceStateChanged(this, n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWait() {
        try {
            Object object = this.myWaitLock;
            synchronized (object) {
                this.myWaitLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean stepIntoSatisfied(BreakPosition breakPosition) {
        if (!this.myStepIntoFlag) {
            return false;
        }
        ProcessExecutionModel.Branch branch = this.getProcessExecutionModel().getCurrentBranch();
        return branch != null && breakPosition.getBranchId().equals(branch.getId());
    }

    private boolean stepOverSatisfied(BreakPosition breakPosition) {
        if (!this.myStepOverFlag) {
            return false;
        }
        ProcessExecutionModel.Branch branch = this.getProcessExecutionModel().getCurrentBranch();
        if (branch == null || !breakPosition.getBranchId().equals(branch.getId())) {
            return false;
        }
        String string = this.myLastPosition.getXpath();
        String string2 = breakPosition.getXpath();
        return !string2.startsWith(string) || string2.equals(string);
    }

    private boolean stepOutSatisfied(BreakPosition breakPosition) {
        String string;
        if (!this.myStepOutFlag) {
            return false;
        }
        ProcessExecutionModel.Branch branch = this.getProcessExecutionModel().getCurrentBranch();
        if (branch == null || !breakPosition.getBranchId().equals(branch.getId())) {
            return false;
        }
        String string2 = this.myLastPosition.getXpath();
        String string3 = breakPosition.getXpath();
        return !string3.startsWith(string = string2.substring(0, string2.lastIndexOf("/")));
    }

    private BDIDebugFrame getRootFrame() {
        return this.myFrames.get(0);
    }

    private BpelDebuggerImpl getDebugger() {
        return this.myModel.getDebugger();
    }
}

