/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.bdiclient.impl;

import org.netbeans.modules.bpel.debugger.BpelDebuggerImpl;
import org.netbeans.modules.bpel.debugger.api.DebugException;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.ProcessInstancesModelImpl;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.BPELDebugger;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.BPELProcessInstanceRef;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.BPELProcessRef;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.DebugFrame;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.VirtualBPELEngine;

public class BDIDebugger
implements BPELDebugger {
    private BpelDebuggerImpl myDebugger;
    private VirtualBPELEngine myVirtualBpelEngine;

    public BDIDebugger(BpelDebuggerImpl bpelDebuggerImpl) {
        this.myDebugger = bpelDebuggerImpl;
    }

    public DebugFrame enterFrame(String string, String string2, String string3, String string4, String string5) {
        System.out.println("- enterFrame(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + ")");
        return this.getProcessInstancesModel().frameCreated(string, string2, string3, string4, string5);
    }

    public boolean detach() {
        System.out.println("- detach()");
        this.myDebugger.setException(new DebugException("Target disconnected"));
        return true;
    }

    public void processAdded(BPELProcessRef bPELProcessRef) {
        System.out.println("- processAdded(" + bPELProcessRef + ")");
    }

    public void processRemoved(BPELProcessRef bPELProcessRef) {
        System.out.println("- processRemoved(" + bPELProcessRef + ")");
        this.getProcessInstancesModel().processUndeployed(bPELProcessRef.uri());
    }

    public void processInstanceStarted(BPELProcessInstanceRef bPELProcessInstanceRef) {
        System.out.println("- processInstanceStarted(" + bPELProcessInstanceRef + ")");
        this.getProcessInstancesModel().processInstanceStarted(bPELProcessInstanceRef);
    }

    public void processInstanceDied(BPELProcessInstanceRef bPELProcessInstanceRef) {
        System.out.println("- processInstanceDied(" + bPELProcessInstanceRef + ")");
        this.getProcessInstancesModel().processInstanceDied(bPELProcessInstanceRef);
    }

    public void setVirtualBPELEngine(VirtualBPELEngine virtualBPELEngine) {
        System.out.println("- setVirtualBPELEngine(" + virtualBPELEngine.toString() + ")");
        this.myVirtualBpelEngine = virtualBPELEngine;
        ProcessInstancesModelImpl processInstancesModelImpl = this.getProcessInstancesModel();
        for (String string : virtualBPELEngine.allDeployedBPELs()) {
            BPELProcessRef bPELProcessRef = virtualBPELEngine.getBPELProcess(string);
            processInstancesModelImpl.getProcess(bPELProcessRef);
            for (String string2 : bPELProcessRef.allProcessInstanceIDs()) {
                BPELProcessInstanceRef bPELProcessInstanceRef = bPELProcessRef.getProcessInstance(string2);
                processInstancesModelImpl.processInstanceStarted(bPELProcessInstanceRef);
            }
        }
    }

    public VirtualBPELEngine getVirtualBPELEngine() {
        return this.myVirtualBpelEngine;
    }

    private ProcessInstancesModelImpl getProcessInstancesModel() {
        return this.myDebugger.getProcessInstancesModel();
    }
}

