/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsps.parserapi;

import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Map;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jspparser.ContextUtil;
import org.netbeans.modules.web.jsps.parserapi.Node;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.netbeans.modules.web.jsps.parserapi.TldChangeListener;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface JspParserAPI {
    public static final int ERROR_IGNORE = 1;
    public static final int ERROR_REPORT_ANY = 2;
    public static final int ERROR_REPORT_ACCURATE = 3;
    public static final String TAG_MIME_TYPE = "text/x-tag";

    public JspOpenInfo getJspOpenInfo(FileObject var1, WebModule var2, boolean var3);

    public ParseResult analyzePage(FileObject var1, WebModule var2, int var3);

    public URLClassLoader getModuleClassLoader(WebModule var1);

    public Map<String, String[]> getTaglibMap(WebModule var1) throws IOException;

    public void addTldChangeListener(TldChangeListener var1);

    public void removeTldChangeListener(TldChangeListener var1);

    public static final class ErrorDescriptor {
        protected final FileObject wmRoot;
        protected final FileObject source;
        protected final int line;
        protected final int column;
        protected final String errorMessage;
        protected final String referenceText;

        public ErrorDescriptor(FileObject fileObject, FileObject fileObject2, int n, int n2, String string, String string2) {
            this.wmRoot = fileObject;
            this.source = fileObject2;
            this.line = n;
            this.column = n2;
            this.errorMessage = string;
            this.referenceText = string2;
        }

        public FileObject getSource() {
            return this.source;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getReferenceText() {
            return this.referenceText;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ERROR in ").append(this.getSourcePath()).append(" at [").append(this.getLine()).append(", ").append(this.getColumn()).append("] ").append(this.getErrorMessage()).append("\n").append(this.getReferenceText()).append("\n");
            return stringBuilder.toString();
        }

        private String getSourcePath() {
            if (this.wmRoot == null) {
                return this.getSource().getNameExt();
            }
            return ContextUtil.findRelativeContextPath(this.wmRoot, this.getSource());
        }
    }

    public static final class JspOpenInfo {
        private final boolean isXml;
        private final String encoding;

        public JspOpenInfo(boolean bl, String string) {
            this.isXml = bl;
            this.encoding = string;
        }

        public boolean isXmlSyntax() {
            return this.isXml;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public boolean equals(Object object) {
            if (object instanceof JspOpenInfo) {
                JspOpenInfo jspOpenInfo = (JspOpenInfo)object;
                return this.getEncoding().equals(jspOpenInfo.getEncoding()) && this.isXmlSyntax() == jspOpenInfo.isXmlSyntax();
            }
            return false;
        }

        public int hashCode() {
            return this.encoding.hashCode() + (this.isXml ? 1 : 0);
        }

        public String toString() {
            return super.toString() + " [isXml: " + this.isXml + ", encoding: " + this.encoding + "]";
        }
    }

    public static final class ParseResult {
        protected final PageInfo pageInfo;
        protected final Node.Nodes nodes;
        protected final ErrorDescriptor[] errors;
        protected final boolean parsedOK;

        public ParseResult(PageInfo pageInfo, Node.Nodes nodes) {
            this(pageInfo, nodes, null);
        }

        public ParseResult(ErrorDescriptor[] errorDescriptorArray) {
            this(null, null, errorDescriptorArray);
        }

        public ParseResult(PageInfo pageInfo, Node.Nodes nodes, ErrorDescriptor[] errorDescriptorArray) {
            this.pageInfo = pageInfo;
            this.nodes = nodes;
            this.errors = errorDescriptorArray;
            this.parsedOK = errorDescriptorArray == null || errorDescriptorArray.length == 0;
        }

        public boolean isParsingSuccess() {
            return this.parsedOK;
        }

        public PageInfo getPageInfo() {
            return this.pageInfo;
        }

        public Node.Nodes getNodes() {
            return this.nodes;
        }

        public ErrorDescriptor[] getErrors() {
            if (!this.parsedOK) {
                return this.errors;
            }
            throw new IllegalStateException();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("--------- JspParserAPI.parseResult(), success: ");
            stringBuilder.append(this.isParsingSuccess());
            stringBuilder.append("\n");
            if (this.pageInfo != null) {
                stringBuilder.append(" ---- PAGEINFO\n");
                stringBuilder.append(this.pageInfo.toString());
            }
            if (this.nodes != null) {
                stringBuilder.append("\n ---- NODES\n");
                stringBuilder.append(this.nodes.toString());
                stringBuilder.append("\n");
            }
            if (!this.isParsingSuccess()) {
                stringBuilder.append("\n ---- ERRORS\n");
                for (int i = 0; i < this.errors.length; ++i) {
                    stringBuilder.append(this.errors[i].toString());
                }
            }
            return stringBuilder.toString();
        }
    }
}

