/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.view.svg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class SVGImagePanel
extends JPanel {
    public static final int CROSS_SIZE = 10;
    private final JComponent imagePanel;

    public SVGImagePanel(JComponent jComponent) {
        this.imagePanel = jComponent;
        this.setLayout(new CenteredLayoutManager());
        this.add(jComponent);
        this.setDoubleBuffered(true);
    }

    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        int n = this.imagePanel.getX();
        int n2 = this.imagePanel.getY();
        graphics.setColor(Color.BLACK);
        int n3 = this.imagePanel.getWidth();
        int n4 = this.imagePanel.getHeight();
        SVGImagePanel.drawCross(graphics, n - 1, n2 - 1);
        SVGImagePanel.drawCross(graphics, n - 1, n2 + n4 + 1);
        SVGImagePanel.drawCross(graphics, n + n3 + 1, n2 - 1);
        SVGImagePanel.drawCross(graphics, n + n3 + 1, n2 + n4 + 1);
        Rectangle2D rectangle2D = new Rectangle2D.Float(n, n2, n3, n4);
        Rectangle rectangle = this.getVisibleRect();
        if (rectangle != null) {
            rectangle2D = rectangle.createIntersection(rectangle2D);
        }
        graphics.setClip(rectangle2D);
        this.paintPanel(graphics, n, n2);
    }

    protected abstract void paintPanel(Graphics var1, int var2, int var3);

    private static void drawCross(Graphics graphics, int n, int n2) {
        graphics.drawLine(n - 10, n2, n + 10, n2);
        graphics.drawLine(n, n2 - 10, n, n2 + 10);
    }

    private class CenteredLayoutManager
    implements LayoutManager {
        private CenteredLayoutManager() {
        }

        public void addLayoutComponent(String string, Component component) {
            assert (SVGImagePanel.this.imagePanel.equals(component));
        }

        public Dimension preferredLayoutSize(Container container) {
            return SVGImagePanel.this.imagePanel.getSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return SVGImagePanel.this.imagePanel.getSize();
        }

        public void layoutContainer(Container container) {
            SVGImagePanel.this.imagePanel.setLocation((container.getWidth() - SVGImagePanel.this.imagePanel.getWidth()) / 2, (container.getHeight() - SVGImagePanel.this.imagePanel.getHeight()) / 2);
        }

        public void removeLayoutComponent(Component component) {
            assert (SVGImagePanel.this.imagePanel.equals(component));
        }
    }
}

