/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.export.ComponentGroup;
import org.netbeans.modules.mobility.svgcore.export.SVGRasterizerPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class SVGImageRasterizerPanel
extends SVGRasterizerPanel {
    private final ComponentGroup m_currentTime;
    private JSlider animationSlider;
    private ButtonGroup buttonGroup1;
    private JLabel compressionLabel;
    private JComboBox compressionLevelCombo;
    private JLabel compressionQualityLabel;
    private JSpinner compressionQualitySpinner;
    private JSpinner currentTimeSpinner;
    private JPanel exportPanel;
    private JComboBox formatComboBox;
    private JScrollPane imageHolder;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JCheckBox keepRatio;
    private JPanel optionsPanel;
    private JTextField previewFileText;
    private JTextField previewFormatText;
    private JTextField previewSizeText;
    private JCheckBox progressiveCheckBox;
    private JRadioButton radioExportAll;
    private JRadioButton radioExportCurrent;
    private JComboBox reductionCombo;
    private JLabel reductionLabel;
    private JPanel sizePanel;
    private JSpinner spinnerHeight;
    private JSpinner spinnerWidth;
    private JPanel timeLinePanel;
    private JCheckBox transparentCheckBox;

    public SVGImageRasterizerPanel(SVGDataObject sVGDataObject, String string) throws IOException, BadLocationException {
        super(sVGDataObject, string);
        this.initComponents();
        this.m_currentTime = this.createTimeGroup(this.currentTimeSpinner, this.animationSlider, true);
        this.createCompressionGroup(this.compressionLevelCombo, this.compressionQualitySpinner);
        this.radioExportAll.setEnabled(this.isInProject() && this.m_elementId == null);
        this.radioExportCurrent.setEnabled(this.isInProject());
        this.m_ratio = this.m_dim.getHeight() / this.m_dim.getWidth();
        this.spinnerHeight.setModel(new SpinnerNumberModel((int)this.m_dim.getHeight(), 1, 2048, 1));
        this.spinnerWidth.setModel(new SpinnerNumberModel((int)this.m_dim.getWidth(), 1, 2048, 1));
        this.spinnerWidth.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (SVGImageRasterizerPanel.this.keepRatio.isSelected()) {
                    SVGImageRasterizerPanel.this.spinnerHeight.setValue(new Integer((int)(((Integer)SVGImageRasterizerPanel.this.spinnerWidth.getValue()).doubleValue() * SVGImageRasterizerPanel.this.m_ratio)));
                }
                SVGImageRasterizerPanel.this.updateImage(SVGImageRasterizerPanel.this.spinnerWidth, true);
            }
        });
        this.updateImage(null, true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.sizePanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.spinnerWidth = new JSpinner();
        JLabel jLabel2 = new JLabel();
        this.spinnerHeight = new JSpinner();
        this.keepRatio = new JCheckBox();
        this.optionsPanel = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.formatComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.progressiveCheckBox = new JCheckBox();
        this.compressionLabel = new JLabel();
        this.compressionLevelCombo = new JComboBox<AnimationRasterizer.CompressionLevel>(AnimationRasterizer.CompressionLevel.values());
        this.compressionQualityLabel = new JLabel();
        this.transparentCheckBox = new JCheckBox();
        this.compressionQualitySpinner = new JSpinner();
        this.reductionLabel = new JLabel();
        this.reductionCombo = new JComboBox<AnimationRasterizer.ColorReductionMethod>(AnimationRasterizer.ColorReductionMethod.values());
        this.timeLinePanel = new JPanel();
        this.currentTimeSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 30.0, 1.0));
        JLabel jLabel4 = new JLabel();
        this.animationSlider = new JSlider();
        this.exportPanel = new JPanel();
        this.radioExportCurrent = new JRadioButton();
        this.radioExportAll = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.imageHolder = new JScrollPane();
        this.jPanel4 = new JPanel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        this.previewFormatText = new JTextField();
        this.previewSizeText = new JTextField();
        this.previewFileText = new JTextField();
        this.sizePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_ImageSize")));
        jLabel.setLabelFor(this.spinnerWidth);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationImageWidth"));
        jLabel.setName("");
        jLabel2.setLabelFor(this.spinnerHeight);
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationImageHeight"));
        this.spinnerHeight.setEnabled(false);
        this.keepRatio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.keepRatio, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationKeepRatio"));
        this.keepRatio.setToolTipText("Images for other configurations are transformed using screen ratio.");
        this.keepRatio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.keepRatio.setMargin(new Insets(0, 0, 0, 0));
        this.keepRatio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGImageRasterizerPanel.this.keepRatioActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.sizePanel);
        this.sizePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jLabel).add((Component)jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.spinnerHeight, -2, 56, -2).add((Component)this.spinnerWidth, -2, 56, -2))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.keepRatio))).addContainerGap(91, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel).add((Component)this.spinnerWidth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel2).add((Component)this.spinnerHeight, -2, -1, -2)).addPreferredGap(0).add((Component)this.keepRatio)));
        this.spinnerWidth.getAccessibleContext().setAccessibleName("Image width");
        this.spinnerHeight.getAccessibleContext().setAccessibleName("Image height");
        this.keepRatio.getAccessibleContext().setAccessibleDescription("");
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_ImageOptions")));
        jLabel3.setLabelFor(this.formatComboBox);
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsFormat"));
        this.formatComboBox.setModel(SVGImageRasterizerPanel.createImageTypeComboBoxModel());
        this.formatComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGImageRasterizerPanel.this.formatComboBoxActionPerformed(actionEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.progressiveCheckBox, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsProgressive"));
        this.progressiveCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.progressiveCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.compressionLabel.setLabelFor(this.compressionLevelCombo);
        Mnemonics.setLocalizedText((JLabel)this.compressionLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsQuality"));
        this.compressionQualityLabel.setLabelFor(this.compressionQualitySpinner);
        Mnemonics.setLocalizedText((JLabel)this.compressionQualityLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsRate"));
        Mnemonics.setLocalizedText((AbstractButton)this.transparentCheckBox, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsTransparent"));
        this.transparentCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.transparentCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.transparentCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGImageRasterizerPanel.this.transparencyChanged(actionEvent);
            }
        });
        this.reductionLabel.setLabelFor(this.reductionCombo);
        Mnemonics.setLocalizedText((JLabel)this.reductionLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsColorReduction"));
        this.reductionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGImageRasterizerPanel.this.colorReductionChanged(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.optionsPanel);
        this.optionsPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(245, 245, 245).add((Component)this.jPanel1, -1, 43, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.transparentCheckBox).addContainerGap(102, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.compressionLabel).addContainerGap(76, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(2, false).add(1, (Component)this.reductionCombo, 0, -1, Short.MAX_VALUE).add(1, (Component)this.reductionLabel, -1, -1, Short.MAX_VALUE)).addContainerGap(54, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)jLabel3).addPreferredGap(1).add((Component)this.formatComboBox, 0, 87, Short.MAX_VALUE)).add(1, (Component)this.progressiveCheckBox).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.compressionLevelCombo, -2, 93, -2).addPreferredGap(1).add((Component)this.compressionQualityLabel).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.compressionQualitySpinner, -2, 46, -2))).add(106, 106, 106)))));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)jLabel3).add((Component)this.formatComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.progressiveCheckBox).addPreferredGap(0).add((Component)this.transparentCheckBox).add(14, 14, 14).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.reductionLabel)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.reductionCombo, -2, -1, -2).addPreferredGap(1).add((Component)this.compressionLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(4).add((Component)this.compressionQualitySpinner, -2, 25, -2).add((Component)this.compressionLevelCombo, -2, 25, -2).add((Component)this.compressionQualityLabel)).addContainerGap()));
        this.formatComboBox.getAccessibleContext().setAccessibleName("Image format");
        this.formatComboBox.getAccessibleContext().setAccessibleDescription("Image format");
        this.progressiveCheckBox.getAccessibleContext().setAccessibleDescription("Progressive display");
        this.compressionLevelCombo.getAccessibleContext().setAccessibleName("Compression level");
        this.compressionLevelCombo.getAccessibleContext().setAccessibleDescription("Compression level");
        this.transparentCheckBox.getAccessibleContext().setAccessibleDescription("Transparent background");
        this.compressionQualitySpinner.getAccessibleContext().setAccessibleName("Compression quality");
        this.reductionLabel.getAccessibleContext().setAccessibleName("Color reduction method:");
        this.reductionLabel.getAccessibleContext().setAccessibleDescription("Color reduction method");
        this.reductionCombo.getAccessibleContext().setAccessibleName("Color reduction method");
        this.timeLinePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_AnimationFrameTime")));
        jLabel4.setLabelFor(this.currentTimeSpinner);
        Mnemonics.setLocalizedText((JLabel)jLabel4, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationTime"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.timeLinePanel);
        this.timeLinePanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)jLabel4).addPreferredGap(0).add((Component)this.currentTimeSpinner, -2, 56, -2)).add((Component)this.animationSlider, -1, 181, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)jLabel4).add((Component)this.currentTimeSpinner, -2, -1, -2)).addPreferredGap(0).add((Component)this.animationSlider, -2, -1, -2)));
        this.animationSlider.getAccessibleContext().setAccessibleName("Current time selector");
        this.animationSlider.getAccessibleContext().setAccessibleDescription("Current time selector");
        this.exportPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_ExportLabel")));
        this.buttonGroup1.add(this.radioExportCurrent);
        this.radioExportCurrent.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioExportCurrent, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationOnlyActiveConfiguration"));
        this.radioExportCurrent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioExportCurrent.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.radioExportAll);
        Mnemonics.setLocalizedText((AbstractButton)this.radioExportAll, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationAllConfigurations"));
        this.radioExportAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioExportAll.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout4 = new GroupLayout((Container)this.exportPanel);
        this.exportPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.radioExportCurrent).add((Component)this.radioExportAll)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.radioExportCurrent).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.radioExportAll)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_PreviewTitle")));
        this.imageHolder.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        jLabel5.setLabelFor(this.previewFormatText);
        jLabel5.setText(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_PreviewFormat"));
        jLabel6.setLabelFor(this.previewSizeText);
        jLabel6.setText(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_PreviewSize"));
        jLabel7.setLabelFor(this.previewFileText);
        jLabel7.setText(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_PreviewFile"));
        this.previewFormatText.setEditable(false);
        this.previewFormatText.setText("JPEG");
        this.previewSizeText.setEditable(false);
        this.previewSizeText.setText("200 KBytes");
        this.previewFileText.setEditable(false);
        this.previewFileText.setText("C:\\Program Files\\about.svg");
        GroupLayout groupLayout5 = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)jLabel5).add((Component)jLabel6).add((Component)jLabel7)).addPreferredGap(1).add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.previewSizeText, -2, 82, -2).add((Component)this.previewFileText, -1, 251, Short.MAX_VALUE).add((Component)this.previewFormatText, -2, 64, -2)).addContainerGap()));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)jLabel5).add((Component)this.previewFormatText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)jLabel6).add((Component)this.previewSizeText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)jLabel7).add((Component)this.previewFileText, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.previewFormatText.getAccessibleContext().setAccessibleDescription("File format");
        this.previewSizeText.getAccessibleContext().setAccessibleDescription("File size");
        this.previewFileText.getAccessibleContext().setAccessibleDescription("File location");
        GroupLayout groupLayout6 = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout6.createParallelGroup(1).add(2, (Component)this.imageHolder, -1, 332, Short.MAX_VALUE).add(2, (Component)this.jPanel4, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)this.imageHolder, -1, 349, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2).addContainerGap()));
        GroupLayout groupLayout7 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout7);
        groupLayout7.setHorizontalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout7.createParallelGroup(1, false).add((Component)this.sizePanel, -1, -1, Short.MAX_VALUE).add((Component)this.timeLinePanel, -1, -1, Short.MAX_VALUE).add((Component)this.exportPanel, -1, -1, Short.MAX_VALUE).add((Component)this.optionsPanel, 0, 221, Short.MAX_VALUE)).addContainerGap()));
        groupLayout7.setVerticalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout7.createParallelGroup(2).add(1, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout7.createSequentialGroup().add((Component)this.sizePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.optionsPanel, -2, 233, -2).addPreferredGap(0).add((Component)this.timeLinePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.exportPanel, -2, -1, -2))).addContainerGap()));
    }

    private void colorReductionChanged(ActionEvent actionEvent) {
        this.updateImage((JComponent)actionEvent.getSource(), true);
    }

    private void transparencyChanged(ActionEvent actionEvent) {
        this.updateImage((JComponent)actionEvent.getSource(), true);
    }

    private void formatComboBoxActionPerformed(ActionEvent actionEvent) {
        this.updateImage((JComponent)actionEvent.getSource(), true);
    }

    private void keepRatioActionPerformed(ActionEvent actionEvent) {
        this.spinnerHeight.setEnabled(!this.keepRatio.isSelected());
    }

    public int getImageWidth() {
        return this.m_overrideWidth != -1 ? this.m_overrideWidth : (Integer)this.spinnerWidth.getValue();
    }

    public int getImageHeight() {
        return this.m_overrideHeight != -1 ? this.m_overrideHeight : (Integer)this.spinnerHeight.getValue();
    }

    public boolean isForAllConfigurations() {
        return this.radioExportAll.isSelected();
    }

    public float getCompressionQuality() {
        int n = ((Number)this.compressionQualitySpinner.getValue()).intValue();
        return (float)n / 100.0f;
    }

    public boolean isProgressive() {
        return this.progressiveCheckBox.isSelected();
    }

    public boolean isTransparent() {
        return this.transparentCheckBox.isSelected();
    }

    public AnimationRasterizer.ImageType getImageType() {
        return (AnimationRasterizer.ImageType)((Object)this.formatComboBox.getSelectedItem());
    }

    public AnimationRasterizer.ColorReductionMethod getColorReductionMethod() {
        return (AnimationRasterizer.ColorReductionMethod)this.reductionCombo.getSelectedItem();
    }

    public float getStartTime() {
        return this.m_currentTime.getValue();
    }

    public int getNumberFrames() {
        return 1;
    }

    public boolean isInSingleImage() {
        return true;
    }

    protected void updateImage(JComponent jComponent, boolean bl) {
        final JLabel jLabel = new JLabel("Updating image...");
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        this.imageHolder.setViewportView(jLabel);
        AnimationRasterizer.ImageType imageType = this.getImageType();
        boolean bl2 = imageType.supportsCompression();
        this.compressionQualitySpinner.setEnabled(bl2);
        this.compressionLevelCombo.setEnabled(bl2);
        this.compressionLabel.setEnabled(bl2);
        this.compressionQualityLabel.setEnabled(bl2);
        boolean bl3 = imageType.needsColorReduction();
        this.reductionCombo.setEnabled(bl3);
        this.reductionLabel.setEnabled(bl3);
        if (imageType.supportsTransparency()) {
            this.transparentCheckBox.setEnabled(true);
        } else {
            this.transparentCheckBox.setEnabled(false);
            this.transparentCheckBox.setSelected(false);
        }
        String string = AnimationRasterizer.createFileNameRoot(this.m_dObj, this, null, true);
        final String string2 = AnimationRasterizer.createFileName(string, this, -1, -1);
        final float f = this.m_currentTime.getValue();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    final AnimationRasterizer.PreviewInfo previewInfo = AnimationRasterizer.previewFrame(SVGImageRasterizerPanel.this.getSVGImage(), SVGImageRasterizerPanel.this, -1, f);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            String string = previewInfo.m_imageSize < 1024 ? previewInfo.m_imageSize + " Bytes" : (double)Math.round((double)previewInfo.m_imageSize / 102.4) / 10.0 + " KBytes";
                            SVGImageRasterizerPanel.this.previewSizeText.setText(string);
                            SVGImageRasterizerPanel.this.previewFormatText.setText(previewInfo.m_imageFormat);
                            SVGImageRasterizerPanel.this.previewFileText.setText(string2);
                            jLabel.setText(null);
                            jLabel.setIcon(new ImageIcon(previewInfo.m_image));
                            jLabel.invalidate();
                            SVGImageRasterizerPanel.this.imageHolder.validate();
                            SVGImageRasterizerPanel.this.imageHolder.repaint();
                        }
                    });
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        });
    }
}

