/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.export.ComponentGroup;
import org.netbeans.modules.mobility.svgcore.export.SVGRasterizerPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class SVGAnimationRasterizerPanel
extends SVGRasterizerPanel {
    private SpinnerNumberModel m_previewSpinnerModel;
    private final ComponentGroup m_startTime;
    private final ComponentGroup m_stopTime;
    private Thread m_sizeCalculationThread;
    private volatile boolean m_processingStopped = false;
    private JCheckBox allFramesCheckBox;
    private ButtonGroup buttonGroup1;
    private JLabel compressionLabel;
    private JComboBox compressionLevelCombo;
    private JLabel compressionQualityLabel;
    private JSpinner compressionQualitySpinner;
    private JPanel exportPanel;
    private JComboBox formatComboBox;
    private JSpinner framesPerSecSpinner;
    private JScrollPane imageHolder;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JCheckBox keepRatio;
    private JPanel optionsPanel;
    private JTextField previewAnimationSizeText;
    private JTextField previewCurrentTimeText;
    private JTextField previewEndTimeText;
    private JTextField previewFileText;
    private JTextField previewFormatText;
    private JTextField previewFrameSizeText;
    private JSpinner previewFrameSpinner;
    private JTextField previewMaxFrameText;
    private JCheckBox progressiveCheckBox;
    private JRadioButton radioExportAll;
    private JRadioButton radioExportCurrent;
    private JComboBox reductionCombo;
    private JLabel reductionLabel;
    private JPanel sizePanel;
    private JSpinner spinnerHeight;
    private JSpinner spinnerWidth;
    private JSlider startTimeSlider;
    private JSpinner startTimeSpinner;
    private JSlider stopTimeSlider;
    private JSpinner stopTimeSpinner;
    private JPanel timeLinePanel;
    private JCheckBox transparentCheckBox;
    private double m_backupFramesPerSec;
    private boolean m_backupAllFramesInSingleImage;
    private double m_backupStartTime;
    private double m_backupStopTime;

    public SVGAnimationRasterizerPanel(SVGDataObject sVGDataObject) throws IOException, BadLocationException {
        super(sVGDataObject, null);
        this.initComponents();
        this.createCompressionGroup(this.compressionLevelCombo, this.compressionQualitySpinner);
        this.m_startTime = this.createTimeGroup(this.startTimeSpinner, this.startTimeSlider, true);
        this.m_stopTime = this.createTimeGroup(this.stopTimeSpinner, this.stopTimeSlider, false);
        this.radioExportAll.setEnabled(this.isInProject());
        this.m_ratio = this.m_dim.getHeight() / this.m_dim.getWidth();
        this.spinnerHeight.setModel(new SpinnerNumberModel((int)this.m_dim.getHeight(), 1, 2048, 1));
        this.spinnerWidth.setModel(new SpinnerNumberModel((int)this.m_dim.getWidth(), 1, 2048, 1));
        this.framesPerSecSpinner.setModel(new SpinnerNumberModel(2.0, 0.1, 30.0, 1.0));
        this.m_previewSpinnerModel = new SpinnerNumberModel(1, 1, 10, 1);
        this.previewFrameSpinner.setModel(this.m_previewSpinnerModel);
        this.spinnerWidth.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (SVGAnimationRasterizerPanel.this.keepRatio.isSelected()) {
                    SVGAnimationRasterizerPanel.this.spinnerHeight.setValue(new Integer((int)(((Integer)SVGAnimationRasterizerPanel.this.spinnerWidth.getValue()).doubleValue() * SVGAnimationRasterizerPanel.this.m_ratio)));
                }
                SVGAnimationRasterizerPanel.this.updateImage(SVGAnimationRasterizerPanel.this.spinnerWidth, true);
            }
        });
        this.m_previewSpinnerModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SVGAnimationRasterizerPanel.this.updateImage(SVGAnimationRasterizerPanel.this.previewFrameSpinner, false);
            }
        });
        this.framesPerSecSpinner.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SVGAnimationRasterizerPanel.this.updateImage(SVGAnimationRasterizerPanel.this.framesPerSecSpinner, true);
            }
        });
        this.updateImage(null, true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.sizePanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.spinnerWidth = new JSpinner();
        JLabel jLabel2 = new JLabel();
        this.spinnerHeight = new JSpinner();
        this.keepRatio = new JCheckBox();
        this.optionsPanel = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.formatComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.progressiveCheckBox = new JCheckBox();
        this.compressionLabel = new JLabel();
        this.compressionLevelCombo = new JComboBox<AnimationRasterizer.CompressionLevel>(AnimationRasterizer.CompressionLevel.values());
        this.compressionQualityLabel = new JLabel();
        this.compressionQualitySpinner = new JSpinner();
        this.reductionLabel = new JLabel();
        this.reductionCombo = new JComboBox<AnimationRasterizer.ColorReductionMethod>(AnimationRasterizer.ColorReductionMethod.values());
        this.transparentCheckBox = new JCheckBox();
        this.timeLinePanel = new JPanel();
        this.startTimeSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 30.0, 1.0));
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        this.stopTimeSpinner = new JSpinner();
        this.startTimeSlider = new JSlider();
        this.stopTimeSlider = new JSlider();
        JLabel jLabel6 = new JLabel();
        this.framesPerSecSpinner = new JSpinner();
        this.exportPanel = new JPanel();
        this.radioExportCurrent = new JRadioButton();
        this.radioExportAll = new JRadioButton();
        this.allFramesCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.previewFormatText = new JTextField();
        this.previewFrameSizeText = new JTextField();
        this.previewFileText = new JTextField();
        this.jLabel5 = new JLabel();
        this.previewAnimationSizeText = new JTextField();
        this.imageHolder = new JScrollPane();
        JLabel jLabel7 = new JLabel();
        this.previewFrameSpinner = new JSpinner();
        this.previewMaxFrameText = new JTextField();
        this.jLabel7 = new JLabel();
        this.previewCurrentTimeText = new JTextField();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        this.previewEndTimeText = new JTextField();
        JLabel jLabel10 = new JLabel();
        this.setOpaque(false);
        this.sizePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_ImageSize")));
        jLabel.setLabelFor(this.spinnerWidth);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getBundle(SVGAnimationRasterizerPanel.class).getString("LBL_AnimationImageWidth"));
        jLabel2.setLabelFor(this.spinnerHeight);
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)NbBundle.getBundle(SVGAnimationRasterizerPanel.class).getString("LBL_AnimationImageHeight"));
        this.spinnerHeight.setEnabled(false);
        this.keepRatio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.keepRatio, (String)NbBundle.getBundle(SVGAnimationRasterizerPanel.class).getString("LBL_AnimationKeepRatio"));
        this.keepRatio.setToolTipText("Images for other configurations are transformed using screen ratio.");
        this.keepRatio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.keepRatio.setMargin(new Insets(0, 0, 0, 0));
        this.keepRatio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGAnimationRasterizerPanel.this.keepRatioActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.sizePanel);
        this.sizePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jLabel).add((Component)jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.spinnerHeight, -2, 56, -2).add((Component)this.spinnerWidth, -2, 56, -2))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.keepRatio))).addContainerGap(106, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel).add((Component)this.spinnerWidth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel2).add((Component)this.spinnerHeight, -2, -1, -2)).addPreferredGap(0).add((Component)this.keepRatio).addContainerGap(-1, Short.MAX_VALUE)));
        jLabel.getAccessibleContext().setAccessibleName("");
        jLabel.getAccessibleContext().setAccessibleDescription("");
        jLabel2.getAccessibleContext().setAccessibleName("");
        this.keepRatio.getAccessibleContext().setAccessibleDescription("");
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_ImageOptions")));
        jLabel3.setLabelFor(this.formatComboBox);
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_OptionsFormat"));
        this.formatComboBox.setModel(SVGAnimationRasterizerPanel.createImageTypeComboBoxModel());
        this.formatComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGAnimationRasterizerPanel.this.formatComboBoxActionPerformed(actionEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.progressiveCheckBox, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_OptionsProgressive"));
        this.progressiveCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.progressiveCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.compressionLabel.setLabelFor(this.compressionLevelCombo);
        Mnemonics.setLocalizedText((JLabel)this.compressionLabel, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_OptionsQuality"));
        this.compressionQualityLabel.setLabelFor(this.compressionQualitySpinner);
        Mnemonics.setLocalizedText((JLabel)this.compressionQualityLabel, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_OptionsRate"));
        this.reductionLabel.setLabelFor(this.reductionCombo);
        Mnemonics.setLocalizedText((JLabel)this.reductionLabel, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_OptionsColorReduction"));
        this.reductionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGAnimationRasterizerPanel.this.colorReductionChanged(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.transparentCheckBox, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_OptionsTransparent"));
        this.transparentCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.transparentCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.transparentCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGAnimationRasterizerPanel.this.transparentCheckBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.optionsPanel);
        this.optionsPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(84, 84, 84).add((Component)this.jPanel1, -1, 136, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)jLabel3).addPreferredGap(1).add((Component)this.formatComboBox, -2, 93, -2).addContainerGap()).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.progressiveCheckBox).addContainerGap(128, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.compressionLabel).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.compressionLevelCombo, -2, 94, -2).addPreferredGap(1).add((Component)this.compressionQualityLabel).add(5, 5, 5).add((Component)this.compressionQualitySpinner, -2, 48, -2))).add(40, 40, 40)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.transparentCheckBox).addContainerGap(124, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(2, false).add(1, (Component)this.reductionCombo, 0, -1, Short.MAX_VALUE).add(1, (Component)this.reductionLabel, -1, -1, Short.MAX_VALUE)).addContainerGap(85, Short.MAX_VALUE)))));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)jLabel3).add((Component)this.formatComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.progressiveCheckBox).addPreferredGap(0).add((Component)this.transparentCheckBox).add(14, 14, 14).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.reductionLabel)).addPreferredGap(0).add((Component)this.reductionCombo, -2, -1, -2).addPreferredGap(0, 15, Short.MAX_VALUE).add((Component)this.compressionLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(4).add((Component)this.compressionLevelCombo, -2, 25, -2).add((Component)this.compressionQualityLabel).add((Component)this.compressionQualitySpinner, -2, 25, -2)).addContainerGap()));
        jLabel3.getAccessibleContext().setAccessibleName("");
        this.reductionCombo.getAccessibleContext().setAccessibleName("Color reduction method");
        this.timeLinePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_AnimationFrameTime")));
        jLabel4.setLabelFor(this.startTimeSpinner);
        Mnemonics.setLocalizedText((JLabel)jLabel4, (String)NbBundle.getBundle(SVGAnimationRasterizerPanel.class).getString("LBL_AnimationTime"));
        jLabel5.setLabelFor(this.stopTimeSpinner);
        Mnemonics.setLocalizedText((JLabel)jLabel5, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_AnimationEndTime"));
        jLabel6.setLabelFor(this.framesPerSecSpinner);
        Mnemonics.setLocalizedText((JLabel)jLabel6, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_AnimationFramePerSec"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.timeLinePanel);
        this.timeLinePanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add(12, 12, 12).add((Component)jLabel6).addPreferredGap(0, 52, Short.MAX_VALUE).add((Component)this.framesPerSecSpinner, -2, 46, -2)).add((Component)this.startTimeSlider, -1, 201, Short.MAX_VALUE).add(2, (Component)this.stopTimeSlider, -1, 201, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)jLabel5).addPreferredGap(0, 60, Short.MAX_VALUE).add((Component)this.stopTimeSpinner, -2, 84, -2)).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)jLabel4).addPreferredGap(0, 59, Short.MAX_VALUE).add((Component)this.startTimeSpinner, -2, 83, -2))))).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)jLabel4).add((Component)this.startTimeSpinner, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.startTimeSlider, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)jLabel5).add((Component)this.stopTimeSpinner, -2, -1, -2)).addPreferredGap(0).add((Component)this.stopTimeSlider, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)jLabel6).add((Component)this.framesPerSecSpinner, -2, -1, -2)).add(24, 24, 24)));
        this.startTimeSlider.getAccessibleContext().setAccessibleName("Start time");
        this.startTimeSlider.getAccessibleContext().setAccessibleDescription("Start time");
        this.stopTimeSlider.getAccessibleContext().setAccessibleName("End time");
        this.stopTimeSlider.getAccessibleContext().setAccessibleDescription("End time");
        this.exportPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_ExportLabel")));
        this.buttonGroup1.add(this.radioExportCurrent);
        this.radioExportCurrent.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioExportCurrent, (String)NbBundle.getBundle(SVGAnimationRasterizerPanel.class).getString("LBL_AnimationOnlyActiveConfiguration"));
        this.radioExportCurrent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioExportCurrent.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.radioExportAll);
        Mnemonics.setLocalizedText((AbstractButton)this.radioExportAll, (String)NbBundle.getBundle(SVGAnimationRasterizerPanel.class).getString("LBL_AnimationAllConfigurations"));
        this.radioExportAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioExportAll.setMargin(new Insets(0, 0, 0, 0));
        this.allFramesCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.allFramesCheckBox, (String)NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_AnimationInSingleFile"));
        this.allFramesCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.allFramesCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.allFramesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SVGAnimationRasterizerPanel.this.allFramesInSingleFileChanged(actionEvent);
            }
        });
        GroupLayout groupLayout4 = new GroupLayout((Container)this.exportPanel);
        this.exportPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.radioExportAll).add((Component)this.allFramesCheckBox).add((Component)this.radioExportCurrent)).addContainerGap(46, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.radioExportCurrent).addPreferredGap(0).add((Component)this.radioExportAll).addPreferredGap(0, 13, Short.MAX_VALUE).add((Component)this.allFramesCheckBox)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_PreviewTitle")));
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel3.setLabelFor(this.previewFormatText);
        this.jLabel3.setText(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_PreviewFormat"));
        this.jLabel1.setLabelFor(this.previewFrameSizeText);
        this.jLabel1.setText(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_PreviewSize"));
        this.jLabel4.setLabelFor(this.previewFileText);
        this.jLabel4.setText(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_PreviewFile"));
        this.previewFormatText.setEditable(false);
        this.previewFormatText.setText("JPEG");
        this.previewFormatText.setToolTipText("Image format");
        this.previewFrameSizeText.setEditable(false);
        this.previewFrameSizeText.setHorizontalAlignment(4);
        this.previewFrameSizeText.setText("5.6KBytes");
        this.previewFrameSizeText.setToolTipText("Single frame size");
        this.previewFileText.setEditable(false);
        this.previewFileText.setText("C:\\Program Files\\about.svg");
        this.previewFileText.setToolTipText("File location");
        this.jLabel5.setText("/");
        this.previewAnimationSizeText.setEditable(false);
        this.previewAnimationSizeText.setText("132.5 KBytes");
        this.previewAnimationSizeText.setToolTipText("Whole animation size");
        GroupLayout groupLayout5 = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.jLabel3).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addPreferredGap(0).add((Component)this.jLabel1)).add((Component)this.jLabel4)).add(13, 13, 13).add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.previewFrameSizeText, -2, 79, -2).addPreferredGap(0).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.previewAnimationSizeText, -2, 162, -2)).add((Component)this.previewFileText, -1, 312, Short.MAX_VALUE).add((Component)this.previewFormatText, -2, 55, -2)).addContainerGap()));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.previewFormatText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel5).add((Component)this.previewFrameSizeText, -2, -1, -2).add((Component)this.previewAnimationSizeText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.previewFileText, -2, -1, -2)).addContainerGap()));
        this.previewFormatText.getAccessibleContext().setAccessibleDescription("");
        this.previewFrameSizeText.getAccessibleContext().setAccessibleName("");
        this.previewFrameSizeText.getAccessibleContext().setAccessibleDescription("");
        this.previewFileText.getAccessibleContext().setAccessibleName("");
        this.previewFileText.getAccessibleContext().setAccessibleDescription("");
        this.previewAnimationSizeText.getAccessibleContext().setAccessibleName("");
        this.imageHolder.setBorder(BorderFactory.createEtchedBorder());
        this.imageHolder.setPreferredSize(new Dimension(300, 300));
        jLabel7.setLabelFor(this.previewFrameSpinner);
        jLabel7.setText(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_AnimationPreviewFrame"));
        this.previewMaxFrameText.setEditable(false);
        this.previewMaxFrameText.setText("30");
        this.previewMaxFrameText.setToolTipText("Number of frames");
        this.jLabel7.setText(NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"LBL_AnimationPreviewTime"));
        this.previewCurrentTimeText.setEditable(false);
        this.previewCurrentTimeText.setHorizontalAlignment(4);
        this.previewCurrentTimeText.setText("0");
        this.previewCurrentTimeText.setToolTipText("Current time");
        jLabel8.setText("/");
        jLabel9.setText("/");
        this.previewEndTimeText.setEditable(false);
        this.previewEndTimeText.setText("60");
        this.previewEndTimeText.setToolTipText("Duration");
        jLabel10.setText("[s]");
        GroupLayout groupLayout6 = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout6.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout6.createParallelGroup(2).add(1, (Component)this.imageHolder, -1, 383, Short.MAX_VALUE).add(1, (Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)jLabel7).addPreferredGap(0).add((Component)this.previewFrameSpinner, -2, 49, -2).addPreferredGap(0).add((Component)jLabel9).addPreferredGap(0).add((Component)this.previewMaxFrameText, -2, 35, -2).addPreferredGap(0, 88, Short.MAX_VALUE).add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.previewCurrentTimeText, -2, 56, -2).addPreferredGap(0).add((Component)jLabel8).addPreferredGap(0).add((Component)this.previewEndTimeText, -2, 54, -2).addPreferredGap(0).add((Component)jLabel10))).addContainerGap()));
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout6.createSequentialGroup().add((GroupLayout.Group)groupLayout6.createParallelGroup(3).add((Component)jLabel7).add((Component)this.previewFrameSpinner, -2, -1, -2).add((Component)jLabel9).add((Component)jLabel8).add((Component)jLabel10).add((Component)this.jLabel7).add((Component)this.previewMaxFrameText, -2, -1, -2).add((Component)this.previewCurrentTimeText, -2, -1, -2).add((Component)this.previewEndTimeText, -2, -1, -2)).addPreferredGap(0).add((Component)this.imageHolder, -1, 467, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jPanel4, -2, -1, -2).addContainerGap()));
        this.previewMaxFrameText.getAccessibleContext().setAccessibleName("");
        this.previewCurrentTimeText.getAccessibleContext().setAccessibleName("Current time");
        this.previewEndTimeText.getAccessibleContext().setAccessibleName("End time");
        GroupLayout groupLayout7 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout7);
        groupLayout7.setHorizontalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout7.createParallelGroup(1, false).add((Component)this.timeLinePanel, -1, -1, Short.MAX_VALUE).add((Component)this.optionsPanel, 0, 227, Short.MAX_VALUE).add((Component)this.sizePanel, -1, -1, Short.MAX_VALUE).add((Component)this.exportPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout7.setVerticalGroup((GroupLayout.Group)groupLayout7.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout7.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout7.createParallelGroup(2).add(1, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout7.createSequentialGroup().add((Component)this.sizePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.optionsPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.timeLinePanel, -2, 183, -2).addPreferredGap(0).add((Component)this.exportPanel, -2, -1, -2))).addContainerGap()));
    }

    private void transparentCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.updateImage((JComponent)actionEvent.getSource(), true);
    }

    private void colorReductionChanged(ActionEvent actionEvent) {
        this.updateImage((JComponent)actionEvent.getSource(), true);
    }

    private void allFramesInSingleFileChanged(ActionEvent actionEvent) {
        this.updateImage((JComponent)actionEvent.getSource(), true);
    }

    private void formatComboBoxActionPerformed(ActionEvent actionEvent) {
        this.updateImage((JComponent)actionEvent.getSource(), true);
    }

    private void keepRatioActionPerformed(ActionEvent actionEvent) {
        this.spinnerHeight.setEnabled(!this.keepRatio.isSelected());
    }

    public int getImageWidth() {
        return this.m_overrideWidth != -1 ? this.m_overrideWidth : (Integer)this.spinnerWidth.getValue();
    }

    public int getImageHeight() {
        return this.m_overrideHeight != -1 ? this.m_overrideHeight : (Integer)this.spinnerHeight.getValue();
    }

    public float getStartTime() {
        return ((Double)this.startTimeSpinner.getValue()).floatValue();
    }

    public float getEndTime() {
        return ((Double)this.stopTimeSpinner.getValue()).floatValue();
    }

    public float getFramesPerSecond() {
        return ((Double)this.framesPerSecSpinner.getValue()).floatValue();
    }

    public boolean isForAllConfigurations() {
        return this.radioExportAll.isSelected();
    }

    public float getCompressionQuality() {
        int n = (Integer)this.compressionQualitySpinner.getValue();
        return (float)n / 100.0f;
    }

    public boolean isProgressive() {
        return this.progressiveCheckBox.isSelected();
    }

    public boolean isTransparent() {
        return this.transparentCheckBox.isSelected();
    }

    public boolean isInSingleImage() {
        return this.allFramesCheckBox.isSelected();
    }

    public int getNumberFrames() {
        float f = this.getEndTime() - this.getStartTime();
        return 1 + (f <= 0.0f ? 0 : (int)(f * this.getFramesPerSecond()));
    }

    public AnimationRasterizer.ImageType getImageType() {
        return (AnimationRasterizer.ImageType)((Object)this.formatComboBox.getSelectedItem());
    }

    public AnimationRasterizer.ColorReductionMethod getColorReductionMethod() {
        return (AnimationRasterizer.ColorReductionMethod)this.reductionCombo.getSelectedItem();
    }

    public void stopProcessing() {
        this.m_processingStopped = true;
        if (this.m_sizeCalculationThread != null) {
            this.m_sizeCalculationThread.interrupt();
        }
    }

    protected void updateImage(JComponent jComponent, boolean bl) {
        if (!this.m_updateInProgress && !this.m_processingStopped) {
            this.m_updateInProgress = true;
            final JLabel jLabel = new JLabel("Updating image...");
            jLabel.setHorizontalAlignment(0);
            jLabel.setVerticalAlignment(0);
            jLabel.setMinimumSize(new Dimension(100, 100));
            this.imageHolder.setViewportView(jLabel);
            this.updateTimelineBounds(jComponent);
            AnimationRasterizer.ImageType imageType = this.getImageType();
            boolean bl2 = imageType.supportsCompression();
            this.compressionQualitySpinner.setEnabled(bl2);
            this.compressionLevelCombo.setEnabled(bl2);
            this.compressionLabel.setEnabled(bl2);
            this.compressionQualityLabel.setEnabled(bl2);
            boolean bl3 = imageType.needsColorReduction();
            this.reductionCombo.setEnabled(bl3);
            this.reductionLabel.setEnabled(bl3);
            if (imageType.supportsTransparency()) {
                this.transparentCheckBox.setEnabled(true);
            } else {
                this.transparentCheckBox.setEnabled(false);
                this.transparentCheckBox.setSelected(false);
            }
            float f = this.getStartTime();
            float f2 = this.getEndTime();
            float f3 = this.getFramesPerSecond();
            final float f4 = f2 - f;
            final int n = this.getNumberFrames();
            this.m_previewSpinnerModel.setMaximum(Integer.valueOf(n));
            if (this.m_startTime.findWrapper(jComponent) != null) {
                this.previewFrameSpinner.setValue(new Integer(1));
            } else if (this.m_stopTime.findWrapper(jComponent) != null) {
                this.previewFrameSpinner.setValue(new Integer(n));
            }
            final int n2 = (Integer)this.previewFrameSpinner.getValue() - 1;
            assert (n2 >= 0);
            final float f5 = f + (float)n2 / f3;
            String string = AnimationRasterizer.createFileNameRoot(this.m_dObj, this, null, true);
            final String string2 = AnimationRasterizer.createFileName(string, this, n2, n);
            if (bl) {
                this.previewAnimationSizeText.setText("Calculating animation size ...");
                if (this.m_sizeCalculationThread != null) {
                    this.m_sizeCalculationThread.interrupt();
                }
                final boolean[] blArray = new boolean[]{false};
                this.m_sizeCalculationThread = new Thread(){

                    public void run() {
                        try {
                            AnimationRasterizer.calculateAnimationSize(SVGAnimationRasterizerPanel.this.getSVGImage(), SVGAnimationRasterizerPanel.this, new AnimationRasterizer.ProgressUpdater(){

                                public void updateProgress(String string) {
                                    if (!blArray[0]) {
                                        SVGAnimationRasterizerPanel.this.updatePreviewText(string);
                                    }
                                }
                            });
                            SVGAnimationRasterizerPanel.this.updateSafeValues();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (IIOException iIOException) {
                            blArray[0] = true;
                            if (!SVGAnimationRasterizerPanel.this.m_processingStopped) {
                                String string = NbBundle.getMessage(SVGAnimationRasterizerPanel.class, (String)"MSG_IMG_ENCODING_ERROR");
                                SVGAnimationRasterizerPanel.this.updatePreviewText(string + ".");
                                string = string + ": " + iIOException.getLocalizedMessage();
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                                SVGAnimationRasterizerPanel.this.restoreSafeValues();
                            }
                        }
                        catch (Exception exception) {
                            Exceptions.printStackTrace((Throwable)exception);
                            SVGAnimationRasterizerPanel.this.restoreSafeValues();
                        }
                    }
                };
                this.m_sizeCalculationThread.setDaemon(true);
                this.m_sizeCalculationThread.setPriority(1);
                this.m_sizeCalculationThread.setName("AnimationSizeCalculationThread");
                this.m_sizeCalculationThread.start();
            }
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        final AnimationRasterizer.PreviewInfo previewInfo = AnimationRasterizer.previewFrame(SVGAnimationRasterizerPanel.this.getSVGImage(), SVGAnimationRasterizerPanel.this, n2, f5);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SVGAnimationRasterizerPanel.this.previewFrameSizeText.setText(AnimationRasterizer.getSizeText(previewInfo.m_imageSize));
                                SVGAnimationRasterizerPanel.this.previewFormatText.setText(previewInfo.m_imageFormat);
                                SVGAnimationRasterizerPanel.this.previewFileText.setText(string2);
                                SVGAnimationRasterizerPanel.this.previewMaxFrameText.setText(String.valueOf(n));
                                SVGAnimationRasterizerPanel.this.previewCurrentTimeText.setText(String.valueOf(SVGRasterizerPanel.roundTime(f5)));
                                SVGAnimationRasterizerPanel.this.previewEndTimeText.setText(String.valueOf(SVGRasterizerPanel.roundTime(f4)));
                                jLabel.setText(null);
                                jLabel.setIcon(new ImageIcon(previewInfo.m_image));
                                jLabel.invalidate();
                                SVGAnimationRasterizerPanel.this.imageHolder.validate();
                                SVGAnimationRasterizerPanel.this.imageHolder.repaint();
                            }
                        });
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                    finally {
                        SVGAnimationRasterizerPanel.this.m_updateInProgress = false;
                    }
                }
            });
        }
    }

    private void updatePreviewText(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SVGAnimationRasterizerPanel.this.previewAnimationSizeText.setText(string);
            }
        });
    }

    private void updateTimelineBounds(JComponent jComponent) {
        ComponentGroup.ComponentWrapper componentWrapper = this.m_startTime.findWrapper(jComponent);
        if (componentWrapper != null) {
            float f = componentWrapper.getValue();
            this.stopTimeSlider.setExtent(Math.round(f * 100.0f));
            ((SpinnerNumberModel)this.stopTimeSpinner.getModel()).setMinimum(new Double(f));
        } else {
            componentWrapper = this.m_stopTime.findWrapper(jComponent);
            if (componentWrapper != null) {
                float f = componentWrapper.getValue();
                this.startTimeSlider.setExtent(this.startTimeSlider.getMaximum() - Math.round(f * 100.0f));
                ((SpinnerNumberModel)this.startTimeSpinner.getModel()).setMaximum(new Double(f));
            }
        }
    }

    private void updateSafeValues() {
        this.m_backupStartTime = this.getStartTime();
        this.m_backupStopTime = this.getEndTime();
        this.m_backupFramesPerSec = this.getFramesPerSecond();
        this.m_backupAllFramesInSingleImage = this.isInSingleImage();
    }

    private void restoreSafeValues() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SVGAnimationRasterizerPanel.this.framesPerSecSpinner.setValue(SVGAnimationRasterizerPanel.this.m_backupFramesPerSec);
                SVGAnimationRasterizerPanel.this.allFramesCheckBox.setSelected(SVGAnimationRasterizerPanel.this.m_backupAllFramesInSingleImage);
                SVGAnimationRasterizerPanel.this.startTimeSpinner.setValue(SVGAnimationRasterizerPanel.this.m_backupStartTime);
                SVGAnimationRasterizerPanel.this.stopTimeSpinner.setValue(SVGAnimationRasterizerPanel.this.m_backupStopTime);
            }
        });
    }
}

