/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;

public final class InputControlManager {
    private final SceneManager m_sceneMgr;
    private final MouseController m_mouseCtrl;
    private final KeyboardController m_keyCtrl;

    public InputControlManager(SceneManager sceneManager) {
        this.m_sceneMgr = sceneManager;
        this.m_mouseCtrl = new MouseController();
        this.m_keyCtrl = new KeyboardController();
    }

    void initialize() {
        this.m_sceneMgr.getScreenManager().registerMouseController(this.m_mouseCtrl);
        this.m_sceneMgr.getScreenManager().registerKeyController(this.m_keyCtrl);
    }

    private class KeyboardController
    implements KeyListener {
        private KeyboardController() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            InputControlManager.this.m_sceneMgr.processEvent(keyEvent);
        }

        public void keyPressed(KeyEvent keyEvent) {
            InputControlManager.this.m_sceneMgr.processEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            InputControlManager.this.m_sceneMgr.processEvent(keyEvent);
        }
    }

    class MouseController
    implements MouseListener,
    MouseMotionListener {
        MouseController() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            InputControlManager.this.m_sceneMgr.processEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            InputControlManager.this.m_sceneMgr.processEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            InputControlManager.this.m_sceneMgr.processEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            InputControlManager.this.m_sceneMgr.processEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            InputControlManager.this.m_sceneMgr.processEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            InputControlManager.this.m_sceneMgr.processEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            InputControlManager.this.m_sceneMgr.processEvent(mouseEvent);
        }
    }
}

