/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore;

import java.awt.Container;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.mobility.svgcore.SVGDataLoader;
import org.netbeans.modules.mobility.svgcore.SVGDataNode;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.view.source.SVGSourceMultiViewElement;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGViewMultiViewElement;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewEditorSupport;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.xml.sax.InputSource;

public final class SVGDataObject
extends XmlMultiViewDataObject {
    private static final long serialVersionUID = 123471457562776148L;
    private static final Image SVGFILE_ICON = Utilities.loadImage((String)"org/netbeans/modules/mobility/svgcore/resources/svg.png");
    public static final int XML_VIEW_INDEX = 0;
    public static final int SVG_VIEW_INDEX = 1;
    public static final String PROP_EXT_CHANGE = "external_change";
    public static final String EXT_SVG = "svg";
    public static final String EXT_SVGZ = "svgz";
    private transient SVGFileModel m_model;
    private transient SceneManager m_sceneManager;
    private transient MultiViewElement m_activeElement = null;
    private final XmlMultiViewDataObject.DataCache m_dataCache = new XmlMultiViewDataObject.DataCache(){

        public void loadData(FileObject fileObject, FileLock fileLock) throws IOException {
            if (SVGDataObject.isSVGZ(fileObject.getExt())) {
                fileObject = new FileObjectGZIPDelegator(fileObject);
            }
            super.loadData(fileObject, fileLock);
        }
    };

    public SVGDataObject(FileObject fileObject, SVGDataLoader sVGDataLoader) throws DataObjectExistsException, IOException {
        super(fileObject, (MultiFileLoader)sVGDataLoader);
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkXMLSupport = new CheckXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)checkXMLSupport);
        ValidateXMLSupport validateXMLSupport = new ValidateXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)validateXMLSupport);
        XmlMultiViewEditorSupport xmlMultiViewEditorSupport = this.getEditorSupport();
        xmlMultiViewEditorSupport.setSuppressXmlView(true);
        this.setLastOpenView(1);
        xmlMultiViewEditorSupport.getMultiViewDescriptions();
        this.getCookieSet().assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject fileObject, String string) throws IOException {
                SVGDataObject.this.getEditorSupport().saveAs(fileObject, string);
            }
        }});
        SceneManager.log(Level.INFO, "SVGDataObject created for " + fileObject.getPath());
    }

    public XmlMultiViewDataObject.DataCache getDataCache() {
        return this.m_dataCache;
    }

    public void fireContentChanged() {
        this.firePropertyChange(PROP_EXT_CHANGE, null, null);
    }

    public TopComponent getMTVC() {
        this.getCookieSet();
        return this.getEditorSupport().getMVTC();
    }

    public MultiViewElement getActiveElement() {
        return this.m_activeElement;
    }

    public void setMultiViewElement(MultiViewElement multiViewElement) {
        this.m_activeElement = multiViewElement;
    }

    public synchronized SVGFileModel getModel() {
        if (this.m_model == null) {
            this.m_model = new SVGFileModel(this.getEditorSupport());
            SceneManager.log(Level.INFO, "Model created for " + this.getPrimaryFile().getPath());
        }
        return this.m_model;
    }

    public synchronized SceneManager getSceneManager() {
        if (this.m_sceneManager == null) {
            this.m_sceneManager = new SceneManager();
            SceneManager.log(Level.INFO, "SceneManager created for " + this.getPrimaryFile().getPath());
            this.m_sceneManager.initialize(this);
        }
        return this.m_sceneManager;
    }

    public static boolean isSVGZ(String string) {
        return EXT_SVGZ.equals(string.toLowerCase());
    }

    private synchronized void release() {
        if (this.m_model != null) {
            this.m_model.detachDocument();
        }
        this.m_model = null;
        this.m_sceneManager = null;
        SceneManager.log(Level.INFO, "SVGDataObject released for " + this.getPrimaryFile().getPath());
    }

    protected synchronized XmlMultiViewEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            this.editorSupport = new SVGEditorSupport();
            this.editorSupport.getMultiViewDescriptions();
        }
        return this.editorSupport;
    }

    protected DesignMultiViewDesc[] getMultiViewDesc() {
        return new DesignMultiViewDesc[]{new XMLTextView(this), new VisualView(this)};
    }

    protected Node createNodeDelegate() {
        return new SVGDataNode(this);
    }

    protected String getPrefixMark() {
        return null;
    }

    public static boolean isSVGFile(File file) {
        String string = file.getName().toLowerCase();
        return string.endsWith(".svg") || string.endsWith(".svgz");
    }

    public static SVGDataObject getActiveDataObject(Container container) {
        while (container != null) {
            SVGDataObject sVGDataObject;
            if (container instanceof CloneableTopComponent && (sVGDataObject = (SVGDataObject)((Object)((CloneableTopComponent)container).getLookup().lookup(SVGDataObject.class))) != null) {
                return sVGDataObject;
            }
            container = container.getParent();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FileObjectGZIPDelegator
    extends FileObject {
        private final FileObject m_delegate;

        public FileObjectGZIPDelegator(FileObject fileObject) {
            this.m_delegate = fileObject;
        }

        public String getName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getExt() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void rename(FileLock fileLock, String string, String string2) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileObject getParent() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isFolder() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Date lastModified() {
            return this.m_delegate.lastModified();
        }

        public boolean isRoot() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isData() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isValid() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void delete(FileLock fileLock) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object getAttribute(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setAttribute(String string, Object object) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Enumeration<String> getAttributes() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void addFileChangeListener(FileChangeListener fileChangeListener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InputStream getInputStream() throws FileNotFoundException {
            try {
                InputStream inputStream = this.m_delegate.getInputStream();
                return new GZIPInputStream(inputStream);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
        }

        public OutputStream getOutputStream(FileLock fileLock) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileLock lock() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setImportant(boolean bl) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileObject[] getChildren() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileObject getFileObject(String string, String string2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileObject createFolder(String string) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FileObject createData(String string, String string2) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isReadOnly() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class XMLTextView
    extends DesignMultiViewDesc {
        private static final long serialVersionUID = 7526471457562776147L;

        XMLTextView(SVGDataObject sVGDataObject) {
            super((XmlMultiViewDataObject)sVGDataObject, NbBundle.getMessage(SVGDataObject.class, (String)"LBL_MULVIEW_TITLE_SOURCE"));
        }

        public MultiViewElement createElement() {
            return new SVGSourceMultiViewElement((SVGDataObject)this.getDataObject());
        }

        public Image getIcon() {
            return ((SVGDataObject)this.getDataObject()).getXmlViewIcon();
        }

        public String preferredID() {
            return "multiview_xml";
        }

        public int getPersistenceType() {
            return 1;
        }
    }

    private static final class VisualView
    extends DesignMultiViewDesc {
        private static final long serialVersionUID = 7526471457562776148L;
        private static final HelpCtx DEFAULT_HELP = new HelpCtx(HelpCtx.class.getName() + ".DEFAULT_HELP");

        VisualView(SVGDataObject sVGDataObject) {
            super((XmlMultiViewDataObject)sVGDataObject, NbBundle.getMessage(SVGDataObject.class, (String)"LBL_MULVIEW_TITLE_VIEW"));
        }

        public MultiViewElement createElement() {
            SVGDataObject sVGDataObject = (SVGDataObject)this.getDataObject();
            return new SVGViewMultiViewElement(sVGDataObject);
        }

        public Image getIcon() {
            return SVGFILE_ICON;
        }

        public String preferredID() {
            return "multiview_svgview";
        }

        public HelpCtx getHelpCtx() {
            return DEFAULT_HELP;
        }

        public int getPersistenceType() {
            return 1;
        }
    }

    private final class SVGEditorSupport
    extends XmlMultiViewEditorSupport {
        private static final long serialVersionUID = 123471457562776148L;

        public SVGEditorSupport() {
            super((XmlMultiViewDataObject)SVGDataObject.this);
        }

        protected void notifyClosed() {
            super.notifyClosed();
            SVGDataObject.this.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
            FileObject fileObject = SVGDataObject.this.getPrimaryFile();
            if (SVGDataObject.isSVGZ(fileObject.getExt())) {
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
                try {
                    editorKit.write(new OutputStreamWriter((OutputStream)gZIPOutputStream, SVGDataObject.this.getEncodingHelper().getEncoding()), (Document)styledDocument, 0, styledDocument.getLength());
                }
                finally {
                    gZIPOutputStream.close();
                }
            } else {
                editorKit.write(new OutputStreamWriter(outputStream, SVGDataObject.this.getEncodingHelper().getEncoding()), (Document)styledDocument, 0, styledDocument.getLength());
            }
        }
    }
}

