/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditorSupport;
import java.util.LinkedHashMap;
import org.netbeans.modules.compapp.casaeditor.graph.CasaFactory;
import org.netbeans.modules.compapp.casaeditor.nodes.LookAndFeelNode;
import org.netbeans.modules.compapp.casaeditor.properties.StringEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class LookAndFeelEditor
extends PropertyEditorSupport {
    private static final String EMPTY = "";
    private String mPropertyName;
    private boolean mIsChangesApplied;
    private LinkedHashMap<String, Color> originalColors;
    private LinkedHashMap<String, Font> originalFonts;

    public LookAndFeelEditor(String string) {
        this.mPropertyName = string;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getAsText() {
        return NbBundle.getMessage(this.getClass(), (String)"LBL_EditLookAndFeel");
    }

    public void setAsText(String string) {
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = this.getPaintableString();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, rectangle.x, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
    }

    protected String getPaintableString() {
        String string = this.getAsText();
        return string == null ? NbBundle.getMessage(StringEditor.class, (String)"LBL_Null") : this.getAsText();
    }

    public Component getCustomEditor() {
        this.mIsChangesApplied = false;
        this.initialUIState();
        PropertySheet propertySheet = new PropertySheet();
        propertySheet.setNodes(new Node[]{new LookAndFeelNode()});
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertySheet, this.mPropertyName, true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION)) {
                    LookAndFeelEditor.this.mIsChangesApplied = true;
                }
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setPreferredSize(new Dimension(500, 700));
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (LookAndFeelEditor.this.mIsChangesApplied) {
                    LookAndFeelEditor.this.applyUIChanges();
                } else {
                    LookAndFeelEditor.this.revertUIChanges();
                }
            }
        });
        return dialog;
    }

    private void initialUIState() {
        this.originalColors = new LinkedHashMap();
        this.originalFonts = new LinkedHashMap();
        this.originalColors.putAll(CasaFactory.getCasaCustomizer().getColorsMapReference());
        this.originalFonts.putAll(CasaFactory.getCasaCustomizer().getFontsMapReference());
    }

    private void revertUIChanges() {
        CasaFactory.getCasaCustomizer().getColorsMapReference().putAll(this.originalColors);
        CasaFactory.getCasaCustomizer().getFontsMapReference().putAll(this.originalFonts);
        CasaFactory.getCasaCustomizerRegistor().propagateChange();
    }

    private void applyUIChanges() {
        CasaFactory.getCasaCustomizer().savePreferences();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        None,
        Declared,
        Other;

    }
}

