/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.nodes.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.netbeans.modules.compapp.casaeditor.CasaDataNode;
import org.netbeans.modules.compapp.casaeditor.CasaDataObject;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPort;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNode;
import org.netbeans.modules.compapp.casaeditor.nodes.ServiceUnitNode;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.LoadWsdlPortPanel;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadWSDLPortsAction
extends NodeAction {
    private static final String JBI_SOURCE_DIR = "jbiasa";
    private static final String JBI_SU_JAR_DIR = "jbiServiceUnits";

    protected boolean enable(Node[] nodeArray) {
        return true;
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(LoadWSDLPortsAction.class, (String)"LBL_LoadWSDLPortsAction_Name");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] nodeArray) {
        if (nodeArray.length > 0) {
            CasaNode casaNode = null;
            CasaWrapperModel casaWrapperModel = null;
            if (nodeArray[0] instanceof ServiceUnitNode) {
                casaNode = (ServiceUnitNode)nodeArray[0];
                casaWrapperModel = casaNode.getModel();
            } else if (nodeArray[0] instanceof CasaNode) {
                casaNode = (CasaNode)nodeArray[0];
                casaWrapperModel = casaNode.getModel();
            } else if (nodeArray[0] instanceof CasaDataNode) {
                casaWrapperModel = ((CasaDataObject)((CasaDataNode)nodeArray[0]).getDataObject()).getEditorSupport().getModel();
            }
            if (casaWrapperModel != null) {
                final CasaNode casaNode2 = casaNode;
                final CasaWrapperModel casaWrapperModel2 = casaWrapperModel;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LoadWSDLPortsAction.this.showDialog(casaNode2, casaWrapperModel2);
                    }
                });
            }
        }
    }

    private void visitAllWsdlFiles(File file, List<File> list) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.visitAllWsdlFiles(new File(file, stringArray[i]), list);
            }
        } else if (file.getName().toLowerCase().endsWith(".wsdl")) {
            list.add(file);
        }
    }

    private String getWsdlFilename(File file, String string) {
        String string2 = "";
        try {
            string2 = file.getCanonicalPath();
            if (string != null && string.length() > 0) {
                string2 = string2.substring(string2.indexOf(JBI_SU_JAR_DIR) + JBI_SU_JAR_DIR.length() + 1 + string.length() + 1);
            } else if (string2.indexOf(JBI_SOURCE_DIR) > 0) {
                string2 = string2.substring(string2.indexOf(JBI_SOURCE_DIR) + JBI_SOURCE_DIR.length() + 1);
            }
            if (string2.length() > 0) {
                return " (" + string2.replace('\\', '/') + ")";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    private void showDialog(CasaNode casaNode, CasaWrapperModel casaWrapperModel) {
        Object object;
        Object object2;
        NotifyDescriptor.Message message;
        Object object3;
        Object object4;
        String string = "";
        ModelSource modelSource = casaWrapperModel.getModelSource();
        Lookup lookup = modelSource.getLookup();
        CatalogModel catalogModel = (CatalogModel)lookup.lookup(CatalogModel.class);
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        File file = FileUtil.toFile((FileObject)fileObject).getParentFile().getParentFile();
        String string2 = File.separator + JBI_SOURCE_DIR + File.separator;
        if (casaNode != null && casaNode instanceof ServiceUnitNode) {
            object4 = (CasaServiceEngineServiceUnit)casaNode.getData();
            string = object4.getUnitName();
            string2 = File.separator + JBI_SU_JAR_DIR + File.separator + string;
        }
        object4 = new File(file.getAbsolutePath() + string2);
        ArrayList<File> arrayList2 = new ArrayList<File>();
        ArrayList<Port> arrayList3 = new ArrayList<Port>();
        HashMap<Port, File> hashMap = new HashMap<Port, File>();
        this.visitAllWsdlFiles((File)object4, arrayList2);
        for (File arrayList4 : arrayList2) {
            try {
                object3 = catalogModel.getModelSource(arrayList4.toURI(), modelSource);
                message = WSDLModelFactory.getDefault().getModel((ModelSource)object3);
                Collection loadWsdlPortPanel = message.getDefinitions().getServices();
                for (Object object5 : loadWsdlPortPanel) {
                    object2 = object5.getPorts();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Port port = (Port)object.next();
                        arrayList3.add(port);
                        hashMap.put(port, arrayList4);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        List<CasaPort> list = casaWrapperModel.getCasaPorts();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object3 = (CasaPort)iterator.next();
            message = casaWrapperModel.getLinkedWSDLPort((CasaPort)object3);
            if (!arrayList3.contains(message)) continue;
            arrayList3.remove(message);
        }
        final ArrayList<Port> arrayList = arrayList3;
        object3 = hashMap;
        if (arrayList.size() > 0) {
            Port port;
            Object object5;
            message = new String[arrayList3.size()];
            for (int i = 0; i < arrayList3.size(); ++i) {
                port = (Port)arrayList3.get(i);
                object5 = ((Service)port.getParent()).getName();
                object2 = (File)object3.get(port);
                object = this.getWsdlFilename((File)object2, string);
                message[i] = "Service=" + (String)object5 + ", Port=" + port.getName() + (String)object;
            }
            final LoadWsdlPortPanel loadWsdlPortPanel = new LoadWsdlPortPanel(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LBL_AvailableWSDLPortsFor", (Object)string), (String[])message);
            port = new DialogDescriptor((Object)loadWsdlPortPanel, NbBundle.getMessage(LoadWsdlPortPanel.class, (String)"LBL_WsdlPort_Selection_Panel"), true, new ActionListener((Map)object3, casaWrapperModel){
                final /* synthetic */ Map val$fmap;
                final /* synthetic */ CasaWrapperModel val$model;
                {
                    this.val$fmap = map;
                    this.val$model = casaWrapperModel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION)) {
                        for (int n : loadWsdlPortPanel.getSelectedIndices()) {
                            Port port = (Port)arrayList.get(n);
                            File file = (File)this.val$fmap.get(port);
                            this.val$model.addCasaPortFromWsdlPort(port, file);
                        }
                    }
                }
            });
            object5 = DialogDisplayer.getDefault().createDialog((DialogDescriptor)port);
            ((Component)object5).setPreferredSize(new Dimension(400, 400));
            ((Dialog)object5).setVisible(true);
        } else {
            message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(LoadWSDLPortsAction.class, (String)"MSG_NoPortFound"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }
}

