/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.nodes.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.CasaValidationController;
import org.netbeans.modules.xml.validation.ValidateAction;
import org.netbeans.modules.xml.validation.ui.ValidationOutputWindow;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class CasaValidateAction
extends ValidateAction {
    private CasaWrapperModel model;

    public CasaValidateAction(CasaWrapperModel casaWrapperModel) {
        super((Model)casaWrapperModel);
        this.model = casaWrapperModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RunAction runAction = new RunAction();
                runAction.run();
                List<Validator.ResultItem> list = runAction.getValidationResults();
                CasaValidationController casaValidationController = CasaValidateAction.this.model.getValidationController();
                if (casaValidationController != null) {
                    casaValidationController.notifyCompleteValidationResults(list);
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RunAction
    implements Runnable {
        private List<Validator.ResultItem> validationResults;

        @Override
        public void run() {
            assert (!SwingUtilities.isEventDispatchThread());
            this.validationResults = CasaValidateAction.this.model.validate();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InputOutput inputOutput = IOProvider.getDefault().getIO(NbBundle.getMessage(ValidateAction.class, (String)"TITLE_XML_check_window"), false);
                    inputOutput.select();
                    OutputWriter outputWriter = inputOutput.getOut();
                    try {
                        outputWriter.reset();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    outputWriter.println(NbBundle.getMessage(ValidateAction.class, (String)"MSG_XML_valid_start"));
                    ValidationOutputWindow validationOutputWindow = new ValidationOutputWindow();
                    validationOutputWindow.displayValidationInformation(RunAction.this.validationResults);
                    outputWriter.print(NbBundle.getMessage(ValidateAction.class, (String)"MSG_XML_valid_end"));
                }
            });
        }

        public List<Validator.ResultItem> getValidationResults() {
            return this.validationResults;
        }
    }
}

