/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.nodes.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.SwingUtilities;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConsumes;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpointRef;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPort;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaProvides;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNode;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.EndpointSelectionPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class AddConnectionAction
extends NodeAction {
    protected void performAction(Node[] nodeArray) {
        if (nodeArray.length < 1) {
            return;
        }
        if (nodeArray[0] instanceof CasaNode) {
            CasaNode casaNode = (CasaNode)nodeArray[0];
            final CasaEndpointRef casaEndpointRef = (CasaEndpointRef)casaNode.getData();
            final CasaWrapperModel casaWrapperModel = casaNode.getModel();
            if (casaWrapperModel == null || casaEndpointRef == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AddConnectionAction.this.showDialog(casaWrapperModel, casaEndpointRef);
                }
            });
        }
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    public String getName() {
        return NbBundle.getMessage(AddConnectionAction.class, (String)"LBL_AddConnectionAction_Name");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private void showDialog(final CasaWrapperModel casaWrapperModel, final CasaEndpointRef casaEndpointRef) {
        Object object;
        ArrayList<CasaEndpointRef> arrayList = new ArrayList<CasaEndpointRef>();
        for (CasaPort casaComponent2 : casaWrapperModel.getCasaPorts()) {
            CasaProvides casaProvides;
            object = casaComponent2.getConsumes();
            if (casaWrapperModel.canConnect((CasaEndpointRef)object, casaEndpointRef)) {
                arrayList.add((CasaEndpointRef)object);
            }
            if (!casaWrapperModel.canConnect(casaProvides = casaComponent2.getProvides(), casaEndpointRef)) continue;
            arrayList.add(casaProvides);
        }
        for (CasaServiceEngineServiceUnit casaServiceEngineServiceUnit : casaWrapperModel.getServiceEngineServiceUnits()) {
            for (CasaEndpointRef casaEndpointRef2 : casaServiceEngineServiceUnit.getEndpoints()) {
                if (!casaWrapperModel.canConnect(casaEndpointRef2, casaEndpointRef)) continue;
                arrayList.add(casaEndpointRef2);
            }
        }
        Collections.sort(arrayList, new Comparator<CasaEndpointRef>(){

            @Override
            public int compare(CasaEndpointRef casaEndpointRef, CasaEndpointRef casaEndpointRef2) {
                String string = casaEndpointRef.getEndpointName();
                String string2 = casaEndpointRef2.getEndpointName();
                return string.compareTo(string2);
            }
        });
        final EndpointSelectionPanel endpointSelectionPanel = new EndpointSelectionPanel(arrayList);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)endpointSelectionPanel, NbBundle.getMessage(EndpointSelectionPanel.class, (String)"LBL_Endpoint_Selection_Panel"), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CasaEndpointRef casaEndpointRef2;
                if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION) && (casaEndpointRef2 = endpointSelectionPanel.getSelectedItem()) != null) {
                    if (casaEndpointRef2 instanceof CasaConsumes) {
                        casaWrapperModel.addConnection((CasaConsumes)casaEndpointRef2, (CasaProvides)casaEndpointRef);
                    } else {
                        casaWrapperModel.addConnection((CasaConsumes)casaEndpointRef, (CasaProvides)casaEndpointRef2);
                    }
                }
            }
        });
        object = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        ((Component)object).setPreferredSize(new Dimension(400, 400));
        ((Dialog)object).setVisible(true);
    }
}

