/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph.layout;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.animator.AnimatorEvent;
import org.netbeans.api.visual.animator.AnimatorListener;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaRegionWidget;
import org.netbeans.modules.compapp.casaeditor.graph.RegionUtilities;

public abstract class CustomizablePersistLayout
implements Layout {
    private int mYSpacing;
    private boolean mIsAnimating;
    private boolean mIsAdjustingForOverlapOnly;

    public void justify(Widget widget) {
    }

    public boolean requiresJustification(Widget widget) {
        return false;
    }

    public void setYSpacing(int n) {
        this.mYSpacing = n;
    }

    public void setIsAdjustingForOverlapOnly(boolean bl) {
        this.mIsAdjustingForOverlapOnly = bl;
    }

    public void setIsAnimating(boolean bl) {
        this.mIsAnimating = bl;
    }

    protected int getYSpacing() {
        return this.mYSpacing;
    }

    protected boolean isAdjustingForOverlapOnly() {
        return this.mIsAdjustingForOverlapOnly;
    }

    protected boolean isAnimating() {
        return this.mIsAnimating;
    }

    protected void moveWidget(CasaNodeWidget casaNodeWidget, Point point, boolean bl) {
        point = this.adjustLocation(casaNodeWidget, point.x, point.y, bl);
        ((CasaModelGraphScene)casaNodeWidget.getScene()).persistLocation(casaNodeWidget, point);
        if (this.isAnimating()) {
            this.animateTo(casaNodeWidget, point);
        } else {
            casaNodeWidget.setPreferredLocation(point);
        }
    }

    private Point adjustLocation(Widget widget, int n, int n2, boolean bl) {
        CasaRegionWidget casaRegionWidget = (CasaRegionWidget)widget.getParentWidget();
        if (n2 < casaRegionWidget.getTitleYOffset()) {
            n2 = casaRegionWidget.getTitleYOffset();
        }
        Dimension dimension = widget.getBounds().getSize();
        if (bl) {
            n = casaRegionWidget.getBounds().width - dimension.width;
            Point point = widget.getLocation();
            if (this.isAnimating() && point.x != n) {
                widget.setPreferredLocation(new Point(n, point.y));
            }
        }
        return new Point(n, n2);
    }

    private void animateTo(final Widget widget, Point point) {
        final CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)widget.getScene();
        Object object = casaModelGraphScene.findObject(widget);
        if (casaModelGraphScene.getSelectedObjects().size() == 1 && casaModelGraphScene.getSelectedObjects().contains(object)) {
            AnimatorListener animatorListener = new AnimatorListener(){

                public void animatorFinished(AnimatorEvent animatorEvent) {
                    casaModelGraphScene.getSceneAnimator().getPreferredLocationAnimator().removeAnimatorListener((AnimatorListener)this);
                    RegionUtilities.stretchScene(casaModelGraphScene);
                    Rectangle rectangle = widget.convertLocalToScene(new Rectangle(widget.getLocation(), widget.getBounds().getSize()));
                    casaModelGraphScene.getView().scrollRectToVisible(rectangle);
                }

                public void animatorStarted(AnimatorEvent animatorEvent) {
                }

                public void animatorReset(AnimatorEvent animatorEvent) {
                }

                public void animatorPreTick(AnimatorEvent animatorEvent) {
                }

                public void animatorPostTick(AnimatorEvent animatorEvent) {
                }
            };
            casaModelGraphScene.getSceneAnimator().getPreferredLocationAnimator().addAnimatorListener(animatorListener);
        }
        casaModelGraphScene.getSceneAnimator().animatePreferredLocation(widget, point);
    }
}

