/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CenteredFlowLayout {
    private static int X_BUFFER_LEFT = 10;
    private static int X_BUFFER_RIGHT = 10;
    private static int X_BUFFER = X_BUFFER_LEFT + X_BUFFER_RIGHT;
    private List<LayoutRow> mRows = new ArrayList<LayoutRow>();
    private int mWidth;
    private int mCurrentRowIndex = 0;
    private int mEdgeSpacing;
    private int mVerticalSpacing;

    public CenteredFlowLayout(int n, int n2, int n3) {
        this.mWidth = n;
        this.mEdgeSpacing = n2;
        this.mVerticalSpacing = n3;
    }

    public void add(CasaNodeWidget casaNodeWidget) {
        LayoutRow layoutRow = null;
        if (this.mRows.size() < this.mCurrentRowIndex + 1) {
            layoutRow = new LayoutRow(this.mWidth, this.mEdgeSpacing, this.mVerticalSpacing);
            this.mRows.add(layoutRow);
        } else {
            layoutRow = this.mRows.get(this.mCurrentRowIndex);
        }
        CasaNodeWidget casaNodeWidget2 = layoutRow.add(casaNodeWidget);
        if (casaNodeWidget2 != null) {
            ++this.mCurrentRowIndex;
            this.add(casaNodeWidget2);
        }
    }

    public void positionWidgets(int n, Map<CasaNodeWidget, Rectangle> map, boolean bl) {
        for (LayoutRow layoutRow : this.mRows) {
            if (bl) {
                layoutRow.positionWidgets_preserve(map);
                continue;
            }
            n = layoutRow.positionWidgets_recalculate(n, map);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LayoutRow {
        private static final int NO_COLLISION = -1;
        private List<CasaNodeWidget> mElements = new ArrayList<CasaNodeWidget>();
        private int mUsedWidth;
        private int mAllowedWidth;
        private int mEdgeSpacing;
        private int mVerticalSpacing;
        private Comparator<CasaNodeWidget> mComparator = new XOrderComparator();

        public LayoutRow(int n, int n2, int n3) {
            this.mAllowedWidth = n;
            this.mEdgeSpacing = n2;
            this.mVerticalSpacing = n3;
            this.mUsedWidth = n2 * 2;
        }

        public boolean canAdd(Widget widget) {
            return this.mElements.size() == 0 || this.mUsedWidth + widget.getBounds().width + X_BUFFER < this.mAllowedWidth;
        }

        public void positionWidgets_preserve(Map<CasaNodeWidget, Rectangle> map) {
            Collections.sort(this.mElements, this.mComparator);
            for (CasaNodeWidget casaNodeWidget : this.mElements) {
                map.put(casaNodeWidget, new Rectangle(casaNodeWidget.getLocation(), casaNodeWidget.getBounds().getSize()));
            }
            int n = this.getRowCollisionYOffset(map);
            if (n != -1) {
                this.calculateNewPositions(n, map);
            }
        }

        public int positionWidgets_recalculate(int n, Map<CasaNodeWidget, Rectangle> map) {
            Collections.sort(this.mElements, this.mComparator);
            return this.calculateNewPositions(n, map);
        }

        private int calculateNewPositions(int n, Map<CasaNodeWidget, Rectangle> map) {
            int n2 = (int)((float)(this.mAllowedWidth - this.mUsedWidth) / (float)(this.mElements.size() * 2));
            int n3 = this.mEdgeSpacing;
            int n4 = n;
            for (CasaNodeWidget casaNodeWidget : this.mElements) {
                Rectangle rectangle = new Rectangle(new Point(n3 += n2 + X_BUFFER_LEFT, n), casaNodeWidget.getBounds().getSize());
                n3 += casaNodeWidget.getBounds().width + X_BUFFER_RIGHT + n2;
                map.put(casaNodeWidget, rectangle);
                n4 = Math.max(n4, n + casaNodeWidget.getBounds().height);
            }
            return n4 += this.mVerticalSpacing;
        }

        private int getRowCollisionYOffset(Map<CasaNodeWidget, Rectangle> map) {
            boolean bl = false;
            int n = -1;
            int n2 = 0;
            for (CasaNodeWidget casaNodeWidget : this.mElements) {
                Rectangle rectangle = new Rectangle(casaNodeWidget.getLocation(), casaNodeWidget.getBounds().getSize());
                for (CasaNodeWidget casaNodeWidget2 : map.keySet()) {
                    if (casaNodeWidget == casaNodeWidget2 || this.mElements.contains((Object)casaNodeWidget2) && this.mElements.indexOf((Object)casaNodeWidget2) > n2) continue;
                    Rectangle rectangle2 = map.get((Object)casaNodeWidget2);
                    if (rectangle.intersects(rectangle2)) {
                        bl = true;
                    }
                    if (!bl) continue;
                    if (this.mElements.contains((Object)casaNodeWidget2)) {
                        n = Math.max(n, casaNodeWidget2.getLocation().y);
                        continue;
                    }
                    n = Math.max(n, rectangle2.getLocation().y + rectangle2.height + this.mVerticalSpacing);
                }
                ++n2;
            }
            return n;
        }

        public CasaNodeWidget add(CasaNodeWidget casaNodeWidget) {
            if (!this.canAdd(casaNodeWidget)) {
                return casaNodeWidget;
            }
            this.forceAdd(casaNodeWidget);
            return null;
        }

        private void forceAdd(CasaNodeWidget casaNodeWidget) {
            this.mUsedWidth += casaNodeWidget.getBounds().width + X_BUFFER;
            this.mElements.add(casaNodeWidget);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class XOrderComparator
        implements Comparator<CasaNodeWidget> {
            private XOrderComparator() {
            }

            @Override
            public int compare(CasaNodeWidget casaNodeWidget, CasaNodeWidget casaNodeWidget2) {
                return casaNodeWidget.getLocation().x - casaNodeWidget2.getLocation().x;
            }
        }
    }
}

