/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph.actions;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.api.CasaPaletteItemID;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetBinding;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPort;
import org.netbeans.modules.compapp.casaeditor.palette.CasaCommonAcceptProvider;
import org.netbeans.modules.compapp.casaeditor.palette.CasaPalette;
import org.openide.ErrorManager;

public class AcceptProviderBindingNode
extends CasaCommonAcceptProvider {
    public AcceptProviderBindingNode(CasaNodeWidgetBinding casaNodeWidgetBinding) {
        super((CasaModelGraphScene)casaNodeWidgetBinding.getScene());
    }

    public ConnectorState isAcceptable(Widget widget, Point point, Transferable transferable) {
        ConnectorState connectorState = ConnectorState.REJECT;
        try {
            CasaPaletteItemID casaPaletteItemID;
            if (transferable.isDataFlavorSupported(CasaPalette.CasaPaletteDataFlavor) && (casaPaletteItemID = (CasaPaletteItemID)transferable.getTransferData(CasaPalette.CasaPaletteDataFlavor)) != null) {
                String string = casaPaletteItemID.getCategory();
                if (string.equals(CasaPalette.CATEGORY_ID_END_POINTS)) {
                    if (this.canAddEndpoint(widget, casaPaletteItemID)) {
                        connectorState = ConnectorState.ACCEPT;
                    }
                } else {
                    connectorState = ConnectorState.REJECT;
                }
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return connectorState;
    }

    public void accept(Widget widget, Point point, Transferable transferable) {
        try {
            String string;
            CasaPaletteItemID casaPaletteItemID;
            if (transferable.isDataFlavorSupported(CasaPalette.CasaPaletteDataFlavor) && (casaPaletteItemID = (CasaPaletteItemID)transferable.getTransferData(CasaPalette.CasaPaletteDataFlavor)) != null && (string = casaPaletteItemID.getCategory()).equals(CasaPalette.CATEGORY_ID_END_POINTS)) {
                this.addEndpoint(widget, casaPaletteItemID);
            }
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
        }
    }

    private boolean canAddEndpoint(Widget widget, CasaPaletteItemID casaPaletteItemID) {
        CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)widget.getScene();
        CasaPort casaPort = (CasaPort)casaModelGraphScene.findObject(widget);
        if (casaPaletteItemID.equals(CasaPalette.ITEM_ID_CONSUME)) {
            return casaPort.getConsumes() == null;
        }
        if (casaPaletteItemID.equals(CasaPalette.ITEM_ID_PROVIDE)) {
            return casaPort.getProvides() == null;
        }
        return false;
    }

    private void addEndpoint(Widget widget, CasaPaletteItemID casaPaletteItemID) {
        CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)widget.getScene();
        CasaPort casaPort = (CasaPort)casaModelGraphScene.findObject(widget);
    }
}

