/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaRegionWidget;
import org.netbeans.modules.compapp.casaeditor.graph.FixedDirectionalAnchor;
import org.netbeans.modules.compapp.casaeditor.graph.SerialLayoutWithJustifications;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaRegion;
import org.openide.util.Utilities;

public class RegionUtilities {
    public static final int MIN_REGION_WIDTH = 50;
    public static final int RESIZER_WIDTH = 4;
    public static final int RESIZER_HALF_WIDTH = 2;
    public static final int DEFAULT_HEIGHT = 500;
    public static final Color RESIZER_COLOR = new Color(80, 80, 80, 60);
    public static final int HORIZONTAL_RIGHT_WIDGET_GAP = 10;
    public static final int HORIZONTAL_LEFT_WIDGET_GAP = 30;
    public static final int VERTICAL_EXPANSION_GAP = 60;
    public static final Image IMAGE_DELETE_16_ICON = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/palette/resources/delete16.png");
    public static final Image IMAGE_EDIT_16_ICON = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/palette/resources/edit16.png");
    public static final Image IMAGE_HIDE_16_ICON = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/palette/resources/hide16.png");
    public static final Image IMAGE_WS_POLICY_16_ICON = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/palette/resources/WSpolicy16.png");
    public static final Image IMAGE_ERROR_BADGE_ICON = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/palette/resources/badge_error.png");
    public static final Image IMAGE_WARNING_BADGE_ICON = Utilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/palette/resources/badge_warning.png");

    public static CasaRegionWidget getRegionWidget(CasaModelGraphScene casaModelGraphScene, CasaRegion.Name name) {
        CasaRegion casaRegion = casaModelGraphScene.getModel().getCasaRegion(name);
        if (casaRegion != null) {
            return (CasaRegionWidget)casaModelGraphScene.findWidget(casaRegion);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stretchScene(CasaModelGraphScene casaModelGraphScene) {
        boolean bl = casaModelGraphScene.isAdjusting();
        try {
            casaModelGraphScene.setIsAdjusting(true);
            RegionUtilities.doStretchSceneHeight(casaModelGraphScene);
            RegionUtilities.doStretchSceneWidth(casaModelGraphScene);
            casaModelGraphScene.revalidate();
            casaModelGraphScene.validate();
            casaModelGraphScene.getView().repaint();
            Object var3_2 = null;
            casaModelGraphScene.setIsAdjusting(bl);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            casaModelGraphScene.setIsAdjusting(bl);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stretchSceneHeightOnly(CasaModelGraphScene casaModelGraphScene) {
        boolean bl = casaModelGraphScene.isAdjusting();
        try {
            casaModelGraphScene.setIsAdjusting(true);
            RegionUtilities.doStretchSceneHeight(casaModelGraphScene);
            casaModelGraphScene.revalidate();
            casaModelGraphScene.validate();
            casaModelGraphScene.getView().repaint();
            Object var3_2 = null;
            casaModelGraphScene.setIsAdjusting(bl);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            casaModelGraphScene.setIsAdjusting(bl);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stretchSceneWidthOnly(CasaModelGraphScene casaModelGraphScene) {
        boolean bl = casaModelGraphScene.isAdjusting();
        try {
            casaModelGraphScene.setIsAdjusting(true);
            RegionUtilities.doStretchSceneWidth(casaModelGraphScene);
            casaModelGraphScene.revalidate();
            casaModelGraphScene.validate();
            casaModelGraphScene.getView().repaint();
            Object var3_2 = null;
            casaModelGraphScene.setIsAdjusting(bl);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            casaModelGraphScene.setIsAdjusting(bl);
            throw throwable;
        }
    }

    private static void doStretchSceneHeight(CasaModelGraphScene casaModelGraphScene) {
        if (casaModelGraphScene.getBounds() != null && casaModelGraphScene.getView() != null) {
            JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, casaModelGraphScene.getView());
            if (jScrollPane == null) {
                return;
            }
            Rectangle rectangle = jScrollPane.getViewportBorderBounds();
            Widget widget = casaModelGraphScene.getLeftResizer();
            Widget widget2 = casaModelGraphScene.getMiddleResizer();
            CasaRegionWidget casaRegionWidget = RegionUtilities.getRegionWidget(casaModelGraphScene, CasaRegion.Name.WSDL_ENDPOINTS);
            CasaRegionWidget casaRegionWidget2 = RegionUtilities.getRegionWidget(casaModelGraphScene, CasaRegion.Name.JBI_MODULES);
            CasaRegionWidget casaRegionWidget3 = RegionUtilities.getRegionWidget(casaModelGraphScene, CasaRegion.Name.EXTERNAL_MODULES);
            if (casaRegionWidget == null || casaRegionWidget2 == null || casaRegionWidget3 == null) {
                return;
            }
            int n = RegionUtilities.findMaximumWidgetYSpan(casaRegionWidget, casaRegionWidget2, casaRegionWidget3);
            n = Math.max(n, rectangle.height);
            RegionUtilities.adjustHeights(n, new Widget[]{widget, casaRegionWidget, widget2, casaRegionWidget2, casaRegionWidget3});
        }
    }

    private static void doStretchSceneWidth(CasaModelGraphScene casaModelGraphScene) {
        if (casaModelGraphScene.getBounds() != null && casaModelGraphScene.getView() != null) {
            JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, casaModelGraphScene.getView());
            if (jScrollPane == null) {
                return;
            }
            Rectangle rectangle = jScrollPane.getViewportBorderBounds();
            CasaRegionWidget casaRegionWidget = RegionUtilities.getRegionWidget(casaModelGraphScene, CasaRegion.Name.WSDL_ENDPOINTS);
            CasaRegionWidget casaRegionWidget2 = RegionUtilities.getRegionWidget(casaModelGraphScene, CasaRegion.Name.JBI_MODULES);
            CasaRegionWidget casaRegionWidget3 = RegionUtilities.getRegionWidget(casaModelGraphScene, CasaRegion.Name.EXTERNAL_MODULES);
            if (casaRegionWidget == null || casaRegionWidget2 == null || casaRegionWidget3 == null) {
                return;
            }
            int n = RegionUtilities.findMaximumWidgetXSpan(10, casaRegionWidget3);
            int n2 = casaRegionWidget.getPreferredBounds().width;
            int n3 = casaRegionWidget2.getPreferredBounds().width;
            n = Math.max(n, rectangle.width - (n2 + n3));
            int n4 = RegionUtilities.adjustWidth(n, casaRegionWidget3);
            casaRegionWidget3.setPreferredLocation(new Point(n2 + n3, 0));
            casaModelGraphScene.getLeftResizer().setPreferredLocation(new Point(casaRegionWidget2.getPreferredLocation().x - 2, 0));
            casaModelGraphScene.getMiddleResizer().setPreferredLocation(new Point(casaRegionWidget3.getPreferredLocation().x - 2, 0));
        }
    }

    private static int adjustWidth(int n, CasaRegionWidget casaRegionWidget) {
        if (n < 20) {
            n = 20;
        }
        Rectangle rectangle = casaRegionWidget.getPreferredBounds();
        casaRegionWidget.setPreferredBounds(new Rectangle(n, rectangle.height));
        return n;
    }

    private static void adjustHeights(int n, Widget ... widgetArray) {
        for (Widget widget : widgetArray) {
            Rectangle rectangle = widget.getPreferredBounds();
            widget.setPreferredBounds(new Rectangle(rectangle.width, n));
        }
    }

    private static int findMaximumWidgetYSpan(CasaRegionWidget ... casaRegionWidgetArray) {
        int n = 0;
        for (CasaRegionWidget casaRegionWidget : casaRegionWidgetArray) {
            for (Widget widget : casaRegionWidget.getChildren()) {
                if (!(widget instanceof CasaNodeWidget) || widget.getPreferredLocation() == null || widget.getBounds() == null) continue;
                n = Math.max(n, widget.getPreferredLocation().y + widget.getBounds().height + 60);
            }
        }
        return n;
    }

    private static int findMaximumWidgetXSpan(int n, CasaRegionWidget casaRegionWidget) {
        int n2 = 0;
        for (Widget widget : casaRegionWidget.getChildren()) {
            if (!(widget instanceof CasaNodeWidget) || widget.getPreferredLocation() == null || widget.getBounds() == null) continue;
            n2 = Math.max(n2, widget.getPreferredLocation().x + widget.getBounds().width + n);
        }
        return n2;
    }

    public static MoveStrategy createPinsRestrictedMoveStrategy() {
        return new PinsRestrictedMoveStrategy();
    }

    public static Anchor createFixedDirectionalAnchor(Widget widget, Directions directions, int n) {
        return widget != null && directions != null ? new FixedDirectionalAnchor(widget, directions, n) : null;
    }

    public static Layout createHorizontalFlowLayoutWithJustifications() {
        return RegionUtilities.createHorizontalFlowLayoutWithJustifications(null, 0);
    }

    public static Layout createHorizontalFlowLayoutWithJustifications(LayoutFactory.SerialAlignment serialAlignment, int n) {
        return new SerialLayoutWithJustifications(false, serialAlignment != null ? serialAlignment : LayoutFactory.SerialAlignment.JUSTIFY, n);
    }

    public static LayerWidget getRegionForScenePoint(CasaModelGraphScene casaModelGraphScene, Point point) {
        CasaRegionWidget casaRegionWidget = null;
        casaRegionWidget = casaModelGraphScene.getBindingRegion();
        if (casaRegionWidget.getBounds().contains(casaRegionWidget.convertSceneToLocal(point))) {
            return casaRegionWidget;
        }
        casaRegionWidget = casaModelGraphScene.getEngineRegion();
        if (casaRegionWidget.getBounds().contains(casaRegionWidget.convertSceneToLocal(point))) {
            return casaRegionWidget;
        }
        casaRegionWidget = casaModelGraphScene.getExternalRegion();
        if (casaRegionWidget.getBounds().contains(casaRegionWidget.convertSceneToLocal(point))) {
            return casaRegionWidget;
        }
        return null;
    }

    private static class PinsRestrictedMoveStrategy
    implements MoveStrategy {
        public Point locationSuggested(Widget widget, Point point, Point point2) {
            return point2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Directions {
        LEFT,
        TOP,
        RIGHT,
        BOTTOM;

    }
}

