/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaRegionWidget;
import org.netbeans.modules.compapp.casaeditor.graph.RegionUtilities;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaRegion;

public class RegionResizeHandler
implements MoveStrategy,
MoveProvider {
    private CasaModelGraphScene mScene;
    private Widget mLeftResizer;
    private Widget mMiddleResizer;
    private CasaRegionWidget mBindingRegion;
    private CasaRegionWidget mEngineRegion;
    private CasaRegionWidget mExternalRegion;
    private int mOriginalXPosition;
    private Map<CasaNodeWidget, Point> mOriginalChildWidgetLocationMap;

    public RegionResizeHandler(CasaModelGraphScene casaModelGraphScene, Widget widget, Widget widget2) {
        this.mScene = casaModelGraphScene;
        this.mLeftResizer = widget;
        this.mMiddleResizer = widget2;
    }

    public Point locationSuggested(Widget widget, Point point, Point point2) {
        if (widget == this.mLeftResizer) {
            this.checkBoundary(point2, null, this.mBindingRegion);
        } else if (widget == this.mMiddleResizer) {
            this.checkBoundary(point2, this.mLeftResizer, this.mEngineRegion);
        }
        point2.y = point.y;
        return point2;
    }

    private void checkBoundary(Point point, Widget widget, CasaRegionWidget casaRegionWidget) {
        int n = 50;
        int n2 = 0;
        if (widget != null) {
            n2 = widget.getLocation().x + 4 + 30;
            n += n2;
        }
        for (Widget widget2 : casaRegionWidget.getChildren()) {
            if (!(widget2 instanceof CasaNodeWidget)) continue;
            if (n2 > 0) {
                n = Math.max(n, n2 + widget2.getBounds().width);
                continue;
            }
            n = Math.max(n, widget2.getBounds().width);
        }
        if (point.x < n) {
            point.x = n;
        }
    }

    public void movementStarted(Widget widget) {
        this.mBindingRegion = RegionUtilities.getRegionWidget(this.mScene, CasaRegion.Name.WSDL_ENDPOINTS);
        this.mEngineRegion = RegionUtilities.getRegionWidget(this.mScene, CasaRegion.Name.JBI_MODULES);
        this.mExternalRegion = RegionUtilities.getRegionWidget(this.mScene, CasaRegion.Name.EXTERNAL_MODULES);
        this.mOriginalChildWidgetLocationMap = null;
    }

    public void movementFinished(Widget widget) {
        this.mOriginalChildWidgetLocationMap = null;
    }

    private void moveRegions(Widget widget, int n) {
        if (widget == this.mLeftResizer) {
            this.shiftRegionWidth(this.mBindingRegion, n);
            this.shiftX((Widget)this.mEngineRegion, n);
            this.shiftX(this.mMiddleResizer, n);
            this.shiftX((Widget)this.mExternalRegion, n);
            this.rightAlignRegion(this.mBindingRegion);
            RegionUtilities.stretchSceneWidthOnly(this.mScene);
        } else if (widget == this.mMiddleResizer) {
            this.shiftRegionWidth(this.mEngineRegion, n);
            this.shiftX((Widget)this.mExternalRegion, n);
            RegionUtilities.stretchSceneWidthOnly(this.mScene);
        }
    }

    private void shiftRegionWidth(CasaRegionWidget casaRegionWidget, int n) {
        Rectangle rectangle = casaRegionWidget.getBounds();
        casaRegionWidget.setPreferredBounds(new Rectangle(0, 0, rectangle.width + n, rectangle.height));
        casaRegionWidget.persistWidth();
    }

    private void shiftX(Widget widget, int n) {
        widget.setPreferredLocation(new Point(widget.getLocation().x + n, widget.getLocation().y));
    }

    private void rightAlignRegion(CasaRegionWidget casaRegionWidget) {
        Point point = casaRegionWidget.convertSceneToLocal(new Point(casaRegionWidget.getPreferredBounds().width, 0));
        for (Widget widget : casaRegionWidget.getChildren()) {
            if (!(widget instanceof CasaNodeWidget)) continue;
            CasaNodeWidget casaNodeWidget = (CasaNodeWidget)widget;
            Point point2 = new Point(point.x - widget.getBounds().width, widget.getLocation().y);
            widget.setPreferredLocation(point2);
            ((CasaModelGraphScene)casaNodeWidget.getScene()).persistLocation(casaNodeWidget, point2);
            widget.resolveBounds(widget.getPreferredLocation(), widget.getBounds());
        }
    }

    public Point getOriginalLocation(Widget widget) {
        this.mOriginalXPosition = widget.getPreferredLocation().x;
        return widget.getPreferredLocation();
    }

    public void setNewLocation(Widget widget, Point point) {
        int n = widget.getPreferredLocation().x;
        widget.setPreferredLocation(point);
        if (widget == this.mLeftResizer) {
            this.moveChildNodesLeft(widget, this.mBindingRegion);
        } else if (widget == this.mMiddleResizer) {
            this.moveChildNodesLeft(widget, this.mEngineRegion);
        }
        this.moveRegions(widget, widget.getPreferredLocation().x - n);
    }

    private void moveChildNodesLeft(Widget widget, CasaRegionWidget casaRegionWidget) {
        if (this.mOriginalChildWidgetLocationMap == null) {
            this.mOriginalChildWidgetLocationMap = new HashMap<CasaNodeWidget, Point>();
            for (Object object : casaRegionWidget.getChildren()) {
                if (!(object instanceof CasaNodeWidget)) continue;
                this.mOriginalChildWidgetLocationMap.put((CasaNodeWidget)((Object)object), object.getLocation());
            }
        }
        Rectangle rectangle = new Rectangle(casaRegionWidget.convertSceneToLocal(widget.getPreferredLocation()), widget.getBounds().getSize());
        for (CasaNodeWidget casaNodeWidget : this.mOriginalChildWidgetLocationMap.keySet()) {
            Rectangle rectangle2 = new Rectangle(casaNodeWidget.getLocation(), casaNodeWidget.getBounds().getSize());
            rectangle2.width += 10;
            Point point = this.mOriginalChildWidgetLocationMap.get((Object)casaNodeWidget);
            Point point2 = new Point(rectangle.x - casaNodeWidget.getBounds().width, casaNodeWidget.getLocation().y);
            point2.x -= 10;
            int n = point2.x = point2.x < 30 ? 30 : point2.x;
            if (rectangle2.intersects(rectangle)) {
                casaNodeWidget.setPreferredLocation(point2);
                ((CasaModelGraphScene)casaNodeWidget.getScene()).persistLocation(casaNodeWidget, point2);
                continue;
            }
            if (point.x + rectangle2.width <= rectangle.x) continue;
            casaNodeWidget.setPreferredLocation(point2);
            ((CasaModelGraphScene)casaNodeWidget.getScene()).persistLocation(casaNodeWidget, point2);
        }
    }
}

