/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaFactory;
import org.netbeans.modules.compapp.casaeditor.graph.DependenciesRegistry;
import org.netbeans.modules.compapp.casaeditor.graph.LineBreakingLabelWidget;
import org.netbeans.modules.compapp.casaeditor.graph.awt.InnerGlowBorderDrawer;
import org.openide.util.NbBundle;

public class CasaRegionWidget
extends LayerWidget {
    public static final int MINIMUM_WIDTH = 20;
    private static final int BORDER_WIDTH = 1;
    private static final Color TITLE_COLOR = new Color(168, 168, 168);
    private static final Font TITLE_FONT = new Font("Dialog", 1, 18);
    private static final int TITLE_Y_POS = 20;
    private static final Color BANNER_COLOR = Color.GRAY;
    private static final Font BANNER_FONT = new Font("SansSerif", 1, 14);
    private static final String LABEL_TRUNCATED = NbBundle.getMessage(CasaRegionWidget.class, (String)"LBL_Truncated");
    private static int mTruncatedStringWidth = -1;
    private Dimension mRegionPreferredSize = new Dimension();
    private boolean mIsHighlighted;
    private Widget mBorderWidget;
    private LabelWidget mTitleWidget;
    private String mTitleText;
    private int mFullTitleStringWidth = -1;
    private LineBreakingLabelWidget mBannerWidget;
    private DependenciesRegistry mDependenciesRegistry = new DependenciesRegistry((Widget)this);

    private CasaRegionWidget(Scene scene, Color color, String string, Color color2, Font font) {
        super(scene);
        this.setBackground(color);
        this.setOpaque(true);
        this.mBorderWidget = new Widget(scene);
        this.mBorderWidget.setOpaque(true);
        this.mBorderWidget.setBackground((Paint)Color.LIGHT_GRAY);
        this.addChild(this.mBorderWidget);
        this.mTitleText = string;
        this.mTitleWidget = new LabelWidget(scene, string);
        this.mTitleWidget.setForeground(color2);
        this.mTitleWidget.setFont(font);
        this.mTitleWidget.setPreferredLocation(new Point(20, 20));
        this.addChild((Widget)this.mTitleWidget);
    }

    protected void notifyAdded() {
        this.mDependenciesRegistry.registerDependency(new Widget.Dependency(){

            public void revalidateDependency() {
                Serializable serializable;
                Scene scene = CasaRegionWidget.this.getScene();
                if (scene.getGraphics() == null) {
                    return;
                }
                CasaRegionWidget.this.updateBorder();
                if (mTruncatedStringWidth < 0) {
                    serializable = scene.getGraphics().getFontMetrics(CasaRegionWidget.this.mTitleWidget.getFont());
                    mTruncatedStringWidth = (int)((FontMetrics)serializable).getStringBounds(LABEL_TRUNCATED, scene.getGraphics()).getWidth();
                }
                if (CasaRegionWidget.this.mFullTitleStringWidth < 0) {
                    serializable = scene.getGraphics().getFontMetrics(CasaRegionWidget.this.mTitleWidget.getFont());
                    CasaRegionWidget.this.mFullTitleStringWidth = (int)((FontMetrics)serializable).getStringBounds(CasaRegionWidget.this.mTitleText, scene.getGraphics()).getWidth();
                }
                serializable = CasaRegionWidget.this.getPreferredBounds().getSize();
                if (!CasaRegionWidget.this.mRegionPreferredSize.equals(serializable)) {
                    CasaRegionWidget.this.mRegionPreferredSize = (Dimension)serializable;
                    if (((CasaRegionWidget)CasaRegionWidget.this).mRegionPreferredSize.width < CasaRegionWidget.this.mFullTitleStringWidth) {
                        CasaRegionWidget.this.updateTitleLabel(CasaRegionWidget.this.mTitleWidget, LABEL_TRUNCATED, mTruncatedStringWidth, 20);
                    } else {
                        CasaRegionWidget.this.updateTitleLabel(CasaRegionWidget.this.mTitleWidget, CasaRegionWidget.this.mTitleText, CasaRegionWidget.this.mFullTitleStringWidth, 20);
                    }
                    if (CasaRegionWidget.this.mBannerWidget != null) {
                        CasaRegionWidget.this.updateBannerLabel();
                    }
                }
            }
        });
    }

    protected void notifyRemoved() {
        this.mDependenciesRegistry.removeAllDependencies();
    }

    private void updateBannerLabel() {
        int n = this.getPreferredBounds().height - this.getTitleYOffset();
        this.mBannerWidget.setPreferredBounds(new Rectangle(0, 0, this.getPreferredBounds().width, n));
        this.mBannerWidget.setPreferredLocation(new Point(0, n / 2));
    }

    private void updateTitleLabel(LabelWidget labelWidget, String string, int n, int n2) {
        if (!labelWidget.getLabel().equals(string)) {
            labelWidget.setLabel(string);
        }
        labelWidget.setPreferredLocation(new Point((this.mRegionPreferredSize.width - n) / 2, n2));
    }

    private void updateBorder() {
        if (this.getPreferredBounds() != null) {
            this.mBorderWidget.setPreferredBounds(new Rectangle(1, this.getPreferredBounds().height));
            this.mBorderWidget.setPreferredLocation(new Point(this.getPreferredBounds().width - 1, 0));
        }
    }

    public boolean hasBanner() {
        return this.mBannerWidget != null;
    }

    public void setBanner(String string) {
        if (string == null) {
            this.removeChild(this.mBannerWidget);
            this.mBannerWidget = null;
            this.getScene().validate();
        } else {
            this.mBannerWidget = new LineBreakingLabelWidget(this.getScene());
            this.mBannerWidget.setText(string, (Color)this.getBackground(), BANNER_FONT);
            this.addChild(this.mBannerWidget);
            this.getScene().validate();
            this.updateBannerLabel();
            this.mBannerWidget.animateVisible(BANNER_COLOR);
        }
        this.getScene().repaint();
    }

    public int getTitleYOffset() {
        return this.mTitleWidget.getPreferredLocation().y + this.mTitleWidget.getBounds().height;
    }

    public void persistWidth() {
        CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)this.getScene();
        casaModelGraphScene.persistWidth(this);
    }

    public void setCOLOR_REGION_TITLE(Color color) {
        this.mTitleWidget.setForeground(color);
    }

    public void setFONT_REGION_TITLE(Font font) {
        this.mTitleWidget.setFont(font);
    }

    public void setHighlighted(boolean bl) {
        if (this.mIsHighlighted != bl) {
            this.mIsHighlighted = bl;
            this.repaint();
        }
    }

    public static CasaRegionWidget createBindingRegion(Scene scene) {
        return new CasaRegionWidget(scene, CasaFactory.getCasaCustomizer().getCOLOR_REGION_BINDING(), NbBundle.getMessage(CasaRegionWidget.class, (String)"LBL_BindingRegion"), CasaFactory.getCasaCustomizer().getCOLOR_BC_REGION_TITLE(), CasaFactory.getCasaCustomizer().getFONT_BC_REGION_TITLE());
    }

    public static CasaRegionWidget createEngineRegion(Scene scene) {
        return new CasaRegionWidget(scene, CasaFactory.getCasaCustomizer().getCOLOR_REGION_ENGINE(), NbBundle.getMessage(CasaRegionWidget.class, (String)"LBL_EngineRegion"), CasaFactory.getCasaCustomizer().getCOLOR_SU_REGION_TITLE(), CasaFactory.getCasaCustomizer().getFONT_SU_REGION_TITLE());
    }

    public static CasaRegionWidget createExternalRegion(Scene scene) {
        return new CasaRegionWidget(scene, CasaFactory.getCasaCustomizer().getCOLOR_REGION_EXTERNAL(), NbBundle.getMessage(CasaRegionWidget.class, (String)"LBL_ExternalRegion"), CasaFactory.getCasaCustomizer().getCOLOR_EXT_SU_REGION_TITLE(), CasaFactory.getCasaCustomizer().getFONT_EXT_SU_REGION_TITLE());
    }

    protected void paintWidget() {
        super.paintWidget();
        if (this.mIsHighlighted && this.getScene().getView() != null) {
            Rectangle rectangle = this.getScene().getView().getVisibleRect();
            rectangle = rectangle.intersection(new Rectangle(this.getLocation(), this.getBounds().getSize()));
            rectangle.x -= this.getLocation().x;
            rectangle.y -= this.getLocation().y;
            InnerGlowBorderDrawer.paintInnerGlowBorder(this.getGraphics(), rectangle, CasaFactory.getCasaCustomizer().getCOLOR_SELECTION(), 0.3f, 15);
        }
    }
}

