/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.model.StateModel;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaConnectionWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaEngineTitleWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaFactory;
import org.netbeans.modules.compapp.casaeditor.graph.CasaMinimizable;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeAnchor;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidgetEngine;
import org.netbeans.modules.compapp.casaeditor.graph.CasaProcessTitleWidget;
import org.netbeans.modules.compapp.casaeditor.graph.awt.BorderedRectangularPainter;
import org.netbeans.modules.compapp.casaeditor.graph.awt.BorderedRectangularProvider;
import org.netbeans.modules.compapp.casaeditor.graph.awt.InnerGlowBorderDrawer;
import org.netbeans.modules.compapp.casaeditor.graph.awt.Painter;
import org.netbeans.modules.compapp.casaeditor.graph.awt.PainterWidget;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;

public class CasaNodeWidgetEngine
extends CasaNodeWidget
implements StateModel.Listener,
CasaMinimizable {
    public static final int ARROW_PIN_WIDTH = 25;
    public static final int MARGIN_SE_ROUNDED_RECTANGLE = 19;
    private static final int PIN_VERTICAL_GAP = 5;
    private static final int TRAILING_VERTICAL_GAP = 4;
    private CasaEngineTitleWidget mTitleWidget;
    private StateModel mStateModel = new StateModel(2);
    private Anchor mNodeAnchor = new CasaNodeAnchor(this);
    private boolean mIsHighlighted;
    private static final boolean DEBUG = false;

    public CasaNodeWidgetEngine(Scene scene) {
        super(scene);
        this.setOpaque(false);
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.mStateModel = new StateModel();
        this.mStateModel.addListener((StateModel.Listener)this);
        this.mTitleWidget = new CasaEngineTitleWidget(scene, this.mStateModel);
        final BorderedRectangularProvider borderedRectangularProvider = new BorderedRectangularProvider(){

            public Color getBorderColor() {
                if (CasaNodeWidgetEngine.this.getState().isSelected() || CasaNodeWidgetEngine.this.getState().isFocused()) {
                    return CasaFactory.getCasaCustomizer().getCOLOR_SELECTION();
                }
                return CasaFactory.getCasaCustomizer().getCOLOR_SU_INTERNAL_BORDER();
            }

            public Color getBackgroundColor() {
                return CasaFactory.getCasaCustomizer().getCOLOR_SU_INTERNAL_BACKGROUND();
            }

            public Rectangle getHeaderRect() {
                Rectangle rectangle = CasaNodeWidgetEngine.this.mTitleWidget.getBounds();
                if (rectangle != null) {
                    Rectangle rectangle2 = this.getClipRect();
                    rectangle2.height = rectangle.height;
                    return rectangle2;
                }
                return null;
            }

            public Color getHeaderColor() {
                return CasaFactory.getCasaCustomizer().getCOLOR_BC_TITLE_BACKGROUND();
            }

            public Rectangle getClipRect() {
                Rectangle rectangle = CasaNodeWidgetEngine.this.mContainerWidget.getClientArea();
                Rectangle rectangle2 = new Rectangle();
                rectangle2.x = rectangle.x + 19;
                rectangle2.y = rectangle.y;
                rectangle2.width = rectangle.width - 19 - 19;
                rectangle2.height = rectangle.height;
                return rectangle2;
            }

            public boolean isRounded() {
                return true;
            }
        };
        Painter painter = new Painter(){

            public void paint(Graphics2D graphics2D) {
                Rectangle rectangle = borderedRectangularProvider.getHeaderRect();
                if (rectangle != null) {
                    if (CasaNodeWidgetEngine.this.getState().isSelected() || CasaNodeWidgetEngine.this.getState().isFocused()) {
                        graphics2D.setColor(CasaFactory.getCasaCustomizer().getCOLOR_SELECTION());
                    } else {
                        graphics2D.setColor(CasaFactory.getCasaCustomizer().getCOLOR_SU_INTERNAL_BORDER());
                    }
                    graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                }
                if (CasaNodeWidgetEngine.this.isHighlighted()) {
                    InnerGlowBorderDrawer.paintInnerGlowBorder(CasaNodeWidgetEngine.this.getGraphics(), borderedRectangularProvider.getClipRect(), CasaFactory.getCasaCustomizer().getCOLOR_SELECTION(), 0.6f, 10);
                }
            }
        };
        this.mContainerWidget = new PainterWidget(scene, new BorderedRectangularPainter(borderedRectangularProvider, painter));
        this.mContainerWidget.setOpaque(false);
        this.mContainerWidget.addChild((Widget)this.mTitleWidget);
        this.mContainerWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)5));
        this.addChild(this.mContainerWidget);
    }

    protected int getErrorBadgeDeltaX() {
        return this.getBounds().width - 15;
    }

    protected void notifyAdded() {
        super.notifyAdded();
        this.notifyStateChanged(ObjectState.createNormal(), ObjectState.createNormal());
    }

    public Rectangle getEntireBounds() {
        Dimension dimension = this.getBounds().getSize();
        return new Rectangle(this.getLocation(), new Dimension(dimension.width, dimension.height + 4));
    }

    public void setNodeProperties(String string, String string2) {
        boolean bl;
        boolean bl2 = string != null && string.length() >= 0;
        boolean bl3 = bl = string2 != null && string2.length() > 0;
        if (bl && bl2) {
            this.mTitleWidget.setLabel("(" + string2 + ") " + string);
        } else if (bl) {
            this.mTitleWidget.setLabel("(" + string2 + ")");
        } else if (bl2) {
            this.mTitleWidget.setLabel(string);
        }
        this.readjustBounds();
    }

    public void stateChanged() {
        this.setMinimized(this.mStateModel.getBooleanState());
    }

    public void updatePinImage() {
        for (Widget widget : this.mContainerWidget.getChildren()) {
            if (!(widget instanceof CasaPinWidget)) continue;
            ((CasaPinWidget)widget).updatePinImage();
        }
    }

    public void setMinimized(boolean bl) {
        ObjectScene objectScene = (ObjectScene)this.getScene();
        for (Widget widget : this.mContainerWidget.getChildren()) {
            if (widget instanceof CasaMinimizable) {
                ((CasaMinimizable)widget).setMinimized(bl);
            }
            if (!(widget instanceof CasaPinWidget)) continue;
            CasaPinWidget casaPinWidget = (CasaPinWidget)widget;
            for (CasaComponent casaComponent : casaPinWidget.getConnections()) {
                CasaConnectionWidget casaConnectionWidget = (CasaConnectionWidget)objectScene.findWidget((Object)casaComponent);
                if (!(casaConnectionWidget instanceof CasaMinimizable)) continue;
                casaConnectionWidget.setMinimized(bl);
            }
        }
        this.mContainerWidget.setPreferredBounds(bl ? this.mTitleWidget.getPreferredBounds() : null);
        this.getScene().validate();
    }

    public boolean isMinimized() {
        return this.mStateModel.getBooleanState();
    }

    protected Color getBackgroundColor() {
        return CasaFactory.getCasaCustomizer().getCOLOR_REGION_ENGINE();
    }

    protected Color getPinHolderBorderColor() {
        return CasaFactory.getCasaCustomizer().getCOLOR_SU_INTERNAL_BORDER();
    }

    protected Color getPinHolderTitleColor() {
        return CasaFactory.getCasaCustomizer().getCOLOR_SU_INTERNAL_TITLE();
    }

    protected Color getPinHolderBackgroundColor() {
        return CasaFactory.getCasaCustomizer().getCOLOR_SU_INTERNAL_BACKGROUND();
    }

    public void setTitleFont(Font font) {
        this.mTitleWidget.setTitleFont(font);
        this.readjustBounds();
    }

    public void setTitleColor(Color color) {
        this.mTitleWidget.setTitleColor(color);
    }

    public void initializeGlassLayer(LayerWidget layerWidget) {
    }

    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        super.notifyStateChanged(objectState, objectState2);
        if (objectState.isSelected() != objectState2.isSelected() || objectState.isFocused() != objectState2.isFocused()) {
            this.repaint();
        }
    }

    public void attachPinWidget(CasaPinWidget casaPinWidget) {
        this.mContainerWidget.addChild((Widget)casaPinWidget);
        this.setPinFont(this.getPinFont());
        this.setPinColor(this.getPinColor());
        this.mContainerWidget.setPreferredBounds(null);
    }

    public void attachProcessWidget(CasaProcessTitleWidget casaProcessTitleWidget) {
        this.mContainerWidget.addChild((Widget)casaProcessTitleWidget);
        this.mContainerWidget.setPreferredBounds(null);
    }

    public void doneAddingWidget() {
        if (this.mContainerWidget.getChildren().size() > 1) {
            Widget widget = new Widget(this.getScene());
            widget.setPreferredBounds(new Rectangle(2, 5));
            this.mContainerWidget.addChild(widget);
        }
    }

    public Anchor createAnchorPin(Anchor anchor) {
        return AnchorFactory.createProxyAnchor((StateModel)this.mStateModel, (Anchor[])new Anchor[]{anchor, this.mNodeAnchor});
    }

    public Anchor getPinAnchor(Widget widget) {
        Anchor anchor = super.getPinAnchor(widget);
        if (anchor == null) {
            anchor = this.mNodeAnchor;
        }
        return anchor;
    }

    public boolean getConfigurationStatus() {
        return this.mTitleWidget.getConfigurationStatus();
    }

    public void setConfigurationStatus(boolean bl) {
        this.mTitleWidget.setConfigurationStatus(bl);
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.mTitleWidget.setEditable(bl);
    }

    public Font getPinFont() {
        return null;
    }

    public Color getPinColor() {
        return null;
    }

    public void setPinFont(Font font) {
        for (Widget widget : this.mContainerWidget.getChildren()) {
            if (!(widget instanceof CasaPinWidgetEngine)) continue;
            ((CasaPinWidgetEngine)widget).setLabelFont(font);
        }
    }

    public void setPinColor(Color color) {
        for (Widget widget : this.mContainerWidget.getChildren()) {
            if (!(widget instanceof CasaPinWidgetEngine)) continue;
            ((CasaPinWidgetEngine)widget).setLabelColor(color);
        }
    }

    public void setHighlighted(boolean bl) {
        if (this.mIsHighlighted != bl) {
            this.mIsHighlighted = bl;
            this.repaint();
        }
    }

    public boolean isHighlighted() {
        return this.mIsHighlighted;
    }
}

