/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasaNodeAnchor
extends Anchor {
    private static final int PIN_GAP = 8;
    private boolean requiresRecalculation = true;
    private HashMap<Anchor.Entry, Anchor.Result> results = new HashMap();

    public CasaNodeAnchor(Widget widget) {
        super(widget);
        assert (widget != null);
    }

    protected void notifyEntryAdded(Anchor.Entry entry) {
        this.requiresRecalculation = true;
    }

    protected void notifyEntryRemoved(Anchor.Entry entry) {
        this.results.remove(entry);
        this.requiresRecalculation = true;
    }

    private void recalculate() {
        int n;
        Anchor.Entry entry;
        int n2;
        int n3;
        int n4;
        Cloneable cloneable;
        Anchor.Entry[] entryArray2;
        if (!this.requiresRecalculation) {
            return;
        }
        Widget widget = this.getRelatedWidget();
        Point point = this.getRelatedSceneLocation();
        HashMap<Anchor.Entry, Float> hashMap = new HashMap<Anchor.Entry, Float>();
        HashMap<Anchor.Entry, Float> hashMap2 = new HashMap<Anchor.Entry, Float>();
        for (Anchor.Entry[] entryArray2 : this.getEntries()) {
            cloneable = this.getOppositeSceneLocation((Anchor.Entry)entryArray2);
            n4 = cloneable.y - point.y;
            n3 = cloneable.x - point.x;
            if (n4 > 0) {
                hashMap2.put((Anchor.Entry)entryArray2, Float.valueOf((float)n3 / (float)n4));
                continue;
            }
            if (n4 < 0) {
                hashMap.put((Anchor.Entry)entryArray2, Float.valueOf((float)(-n3) / (float)n4));
                continue;
            }
            hashMap.put((Anchor.Entry)entryArray2, Float.valueOf(n3 < 0 ? Float.MAX_VALUE : Float.MIN_VALUE));
        }
        Anchor.Entry[] entryArray3 = this.toArray(hashMap);
        entryArray2 = this.toArray(hashMap2);
        cloneable = widget.convertLocalToScene(widget.getBounds());
        n4 = ((Rectangle)cloneable).y;
        n3 = entryArray3.length;
        for (n2 = 0; n2 < n3; ++n2) {
            entry = entryArray3[n2];
            n = ((Rectangle)cloneable).x + (n2 + 1) * ((Rectangle)cloneable).width / (n3 + 1);
            this.results.put(entry, new Anchor.Result((Anchor)this, new Point(n, n4 - 8), Anchor.Direction.TOP));
        }
        n4 = ((Rectangle)cloneable).y + ((Rectangle)cloneable).height;
        n3 = entryArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            entry = entryArray2[n2];
            n = ((Rectangle)cloneable).x + (n2 + 1) * ((Rectangle)cloneable).width / (n3 + 1);
            this.results.put(entry, new Anchor.Result((Anchor)this, new Point(n, n4 + 8), Anchor.Direction.BOTTOM));
        }
    }

    private Anchor.Entry[] toArray(final HashMap<Anchor.Entry, Float> hashMap) {
        Set<Anchor.Entry> set = hashMap.keySet();
        Anchor.Entry[] entryArray = set.toArray(new Anchor.Entry[set.size()]);
        Arrays.sort(entryArray, new Comparator<Anchor.Entry>(){

            @Override
            public int compare(Anchor.Entry entry, Anchor.Entry entry2) {
                float f = ((Float)hashMap.get(entry)).floatValue() - ((Float)hashMap.get(entry2)).floatValue();
                if (f > 0.0f) {
                    return 1;
                }
                if (f < 0.0f) {
                    return -1;
                }
                return 0;
            }
        });
        return entryArray;
    }

    public Anchor.Result compute(Anchor.Entry entry) {
        this.recalculate();
        return this.results.get(entry);
    }
}

