/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.design;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.router.ConnectionWidgetCollisionsCollector;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaFactory;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetEngine;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaProcessTitleWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaRegionWidget;
import org.netbeans.modules.compapp.casaeditor.graph.RegionUtilities;
import org.netbeans.modules.compapp.casaeditor.graph.WaitMessageHandler;
import org.netbeans.modules.compapp.casaeditor.graph.layout.CasaCollisionCollector;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConnection;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConsumes;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpoint;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpointRef;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPort;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaProvides;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaRegion;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.projects.jbi.api.JbiBuildTask;
import org.netbeans.modules.compapp.projects.jbi.api.JbiDefaultComponentInfo;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasaModelGraphUtilities {
    private static final DisablingAction DISABLER = new DisablingAction();
    private static final String NULL_PROCESS_NAME = "<NULL_PROCESS_NAME>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void renderModel(CasaWrapperModel casaWrapperModel, CasaModelGraphScene casaModelGraphScene) {
        CasaModelGraphUtilities.setSceneEnabled(casaModelGraphScene, false);
        casaModelGraphScene.setIsAdjusting(true);
        try {
            try {
                CasaModelGraphUtilities.safeRenderModel(casaWrapperModel, casaModelGraphScene);
            }
            catch (Throwable throwable) {
                casaModelGraphScene.autoLayout(false);
                ErrorManager.getDefault().notify(throwable);
                Object var4_3 = null;
                casaModelGraphScene.setIsAdjusting(false);
                casaModelGraphScene.finalizeModelPositions();
                CasaModelGraphUtilities.setSceneEnabled(casaModelGraphScene, casaModelGraphScene.canEdit());
                return;
            }
            Object var4_2 = null;
            casaModelGraphScene.setIsAdjusting(false);
            casaModelGraphScene.finalizeModelPositions();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            casaModelGraphScene.setIsAdjusting(false);
            casaModelGraphScene.finalizeModelPositions();
            CasaModelGraphUtilities.setSceneEnabled(casaModelGraphScene, casaModelGraphScene.canEdit());
            throw throwable;
        }
        CasaModelGraphUtilities.setSceneEnabled(casaModelGraphScene, casaModelGraphScene.canEdit());
    }

    private static void safeRenderModel(CasaWrapperModel casaWrapperModel, CasaModelGraphScene casaModelGraphScene) {
        if (casaWrapperModel == null || casaModelGraphScene == null) {
            return;
        }
        for (CasaComponent casaComponent : new ArrayList(casaModelGraphScene.getEdges())) {
            casaModelGraphScene.removeEdge(casaComponent);
        }
        for (CasaComponent casaComponent : new ArrayList(casaModelGraphScene.getNodes())) {
            casaModelGraphScene.removeNode(casaComponent);
        }
        for (CasaComponent casaComponent : new ArrayList(casaModelGraphScene.getRegions())) {
            casaModelGraphScene.removeRegion(casaComponent);
        }
        casaModelGraphScene.setModelPositionsFinalized(true);
        CasaModelGraphUtilities.createRegions(casaWrapperModel, casaModelGraphScene);
        for (CasaPort casaPort : casaWrapperModel.getCasaPorts()) {
            CasaModelGraphUtilities.createNode(casaPort, casaWrapperModel, casaModelGraphScene, casaPort.getX(), casaPort.getY());
        }
        for (CasaServiceEngineServiceUnit casaServiceEngineServiceUnit : casaWrapperModel.getServiceEngineServiceUnits()) {
            CasaModelGraphUtilities.createNode(casaServiceEngineServiceUnit, casaWrapperModel, casaModelGraphScene, casaServiceEngineServiceUnit.getX(), casaServiceEngineServiceUnit.getY());
        }
        casaModelGraphScene.validate();
        CasaModelGraphUtilities.renderLayout(casaModelGraphScene);
        for (CasaConnection casaConnection : casaWrapperModel.getCasaConnectionList(false)) {
            CasaConsumes casaConsumes = (CasaConsumes)casaWrapperModel.getCasaEndpointRef(casaConnection, true);
            CasaProvides casaProvides = (CasaProvides)casaWrapperModel.getCasaEndpointRef(casaConnection, false);
            if (casaConsumes == null || casaProvides == null) continue;
            CasaModelGraphUtilities.createEdge(casaConnection, casaConsumes, casaProvides, casaModelGraphScene, false);
        }
        casaModelGraphScene.setOrthogonalRouter(RouterFactory.createOrthogonalSearchRouter((ConnectionWidgetCollisionsCollector)new CasaCollisionCollector(casaModelGraphScene.getBindingRegion(), casaModelGraphScene.getEngineRegion(), casaModelGraphScene.getExternalRegion(), casaModelGraphScene.getConnectionLayer())));
        casaModelGraphScene.updateEdgeRouting(null);
        casaModelGraphScene.validate();
    }

    private static void renderLayout(CasaModelGraphScene casaModelGraphScene) {
        int n = 0;
        int n2 = 0;
        for (CasaComponent casaComponent : casaModelGraphScene.getNodes()) {
            Widget widget = casaModelGraphScene.findWidget(casaComponent);
            if (!(widget instanceof CasaNodeWidget)) continue;
            ++n;
            Point point = widget.getPreferredLocation();
            boolean bl = point == null || point.x < 0 || point.y < 0;
            if (!bl) continue;
            ++n2;
        }
        if (n2 > 0) {
            if (n2 == n) {
                casaModelGraphScene.autoLayout(false);
            } else {
                casaModelGraphScene.progressiveLayout(false);
                RegionUtilities.stretchScene(casaModelGraphScene);
            }
        }
    }

    public static void createRegions(CasaWrapperModel casaWrapperModel, CasaModelGraphScene casaModelGraphScene) {
        CasaRegion casaRegion = casaWrapperModel.getCasaRegion(CasaRegion.Name.WSDL_ENDPOINTS);
        CasaRegion casaRegion2 = casaWrapperModel.getCasaRegion(CasaRegion.Name.JBI_MODULES);
        CasaRegion casaRegion3 = casaWrapperModel.getCasaRegion(CasaRegion.Name.EXTERNAL_MODULES);
        CasaRegionWidget casaRegionWidget = (CasaRegionWidget)casaModelGraphScene.addRegion(casaRegion);
        CasaRegionWidget casaRegionWidget2 = (CasaRegionWidget)casaModelGraphScene.addRegion(casaRegion2);
        CasaRegionWidget casaRegionWidget3 = (CasaRegionWidget)casaModelGraphScene.addRegion(casaRegion3);
        casaRegionWidget2.bringToFront();
        casaRegionWidget.setPreferredLocation(new Point(0, 0));
        int n = casaRegion.getWidth();
        if (n <= 0) {
            n = 200;
        }
        casaRegionWidget.setPreferredBounds(new Rectangle(n, 500));
        casaRegionWidget2.setPreferredLocation(new Point(n, 0));
        int n2 = casaRegion2.getWidth();
        if (n2 <= 0) {
            n2 = 500;
        }
        casaRegionWidget2.setPreferredBounds(new Rectangle(n2, 500));
        casaRegionWidget3.setPreferredLocation(new Point(n + n2, 0));
        int n3 = casaRegion3.getWidth();
        if (n3 <= 0) {
            n3 = 200;
        }
        casaRegionWidget3.setPreferredBounds(new Rectangle(n3, 500));
        casaModelGraphScene.getLeftResizer().setPreferredLocation(new Point(casaRegionWidget2.getPreferredLocation().x - 2, 0));
        casaModelGraphScene.getMiddleResizer().setPreferredLocation(new Point(casaRegionWidget3.getPreferredLocation().x - 2, 0));
        RegionUtilities.stretchScene(casaModelGraphScene);
    }

    public static Widget createNode(CasaPort casaPort, CasaWrapperModel casaWrapperModel, CasaModelGraphScene casaModelGraphScene, int n, int n2) {
        CasaProvides casaProvides;
        CasaNodeWidget casaNodeWidget = (CasaNodeWidget)casaModelGraphScene.addNode(casaPort);
        CasaConsumes casaConsumes = casaPort.getConsumes();
        if (casaConsumes != null) {
            CasaModelGraphUtilities.createPin(casaPort, casaConsumes, null, casaModelGraphScene, false);
        }
        if ((casaProvides = casaPort.getProvides()) != null) {
            CasaModelGraphUtilities.createPin(casaPort, casaProvides, null, casaModelGraphScene, false);
        }
        casaModelGraphScene.validate();
        if (n > 0 && n2 > 0) {
            casaNodeWidget.setPreferredLocation(new Point(n, n2));
        } else {
            casaModelGraphScene.setModelPositionsFinalized(false);
        }
        return casaNodeWidget;
    }

    public static Widget createNode(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit, CasaWrapperModel casaWrapperModel, CasaModelGraphScene casaModelGraphScene, int n, int n2) {
        CasaNodeWidgetEngine casaNodeWidgetEngine = (CasaNodeWidgetEngine)casaModelGraphScene.addNode(casaServiceEngineServiceUnit);
        boolean bl = CasaFactory.getCasaCustomizer().getBOOLEAN_CLASSIC_SESU_LAYOUT_STYLE();
        if (bl) {
            HashMap<String, List<CasaEndpointRef>> hashMap = new HashMap<String, List<CasaEndpointRef>>();
            CasaModelGraphUtilities.buildProcess2EndpointMap(hashMap, casaServiceEngineServiceUnit.getProvides());
            CasaModelGraphUtilities.buildProcess2EndpointMap(hashMap, casaServiceEngineServiceUnit.getConsumes());
            for (String string : hashMap.keySet()) {
                List list;
                if (!string.equals(NULL_PROCESS_NAME)) {
                    list = (List)hashMap.get(string);
                    CasaEndpoint casaEndpoint = (CasaEndpoint)((CasaEndpointRef)list.get(0)).getEndpoint().get();
                    CasaModelGraphUtilities.createProcess(casaServiceEngineServiceUnit, casaEndpoint, casaModelGraphScene, false);
                }
                list = (List)hashMap.get(string);
                for (CasaEndpointRef casaEndpointRef : list) {
                    CasaModelGraphUtilities.createPin(casaServiceEngineServiceUnit, casaEndpointRef, casaEndpointRef.getDisplayName(), casaModelGraphScene, false);
                }
            }
        } else {
            for (CasaProvides casaEndpointRef : casaServiceEngineServiceUnit.getProvides()) {
                CasaModelGraphUtilities.createPin(casaServiceEngineServiceUnit, casaEndpointRef, casaEndpointRef.getDisplayName(), casaModelGraphScene, false);
            }
            for (CasaConsumes casaConsumes : casaServiceEngineServiceUnit.getConsumes()) {
                CasaModelGraphUtilities.createPin(casaServiceEngineServiceUnit, casaConsumes, casaConsumes.getDisplayName(), casaModelGraphScene, false);
            }
        }
        casaNodeWidgetEngine.doneAddingWidget();
        casaModelGraphScene.validate();
        if (n > 0 && n2 > 0) {
            casaNodeWidgetEngine.setPreferredLocation(new Point(n, n2));
        } else {
            casaModelGraphScene.setModelPositionsFinalized(false);
        }
        return casaNodeWidgetEngine;
    }

    private static void buildProcess2EndpointMap(Map<String, List<CasaEndpointRef>> map, List<? extends CasaEndpointRef> list) {
        for (CasaEndpointRef casaEndpointRef : list) {
            List<CasaEndpointRef> list2;
            String string = casaEndpointRef.getProcessName();
            if (string == null) {
                string = NULL_PROCESS_NAME;
            }
            if ((list2 = map.get(string)) == null) {
                list2 = new ArrayList<CasaEndpointRef>();
                map.put(string, list2);
            }
            list2.add(casaEndpointRef);
        }
    }

    public static boolean updateNodeProperties(CasaWrapperModel casaWrapperModel, CasaPort casaPort, CasaNodeWidget casaNodeWidget) {
        String string = CasaModelGraphUtilities.getShortNameInUpperCase(casaPort.getEndpointName());
        String string2 = casaWrapperModel.getBindingComponentName(casaPort);
        if (string2 == null || string2.length() == 0) {
            ErrorManager.getDefault().notify((Throwable)new UnsupportedOperationException(NbBundle.getMessage(CasaModelGraphUtilities.class, (String)"Error_No_Binding_Component_name_for_endpoint") + string));
            return false;
        }
        String string3 = casaWrapperModel.getBindingType(casaPort);
        if (string3 == null) {
            ErrorManager.getDefault().notify((Throwable)new UnsupportedOperationException(NbBundle.getMessage(CasaModelGraphUtilities.class, (String)"Error_Invalid_Binding_Component") + string2));
            return false;
        }
        string3 = string3.toUpperCase();
        casaNodeWidget.setNodeProperties(string, string3);
        return true;
    }

    public static void updateNodeProperties(CasaWrapperModel casaWrapperModel, CasaServiceEngineServiceUnit casaServiceEngineServiceUnit, CasaNodeWidget casaNodeWidget) {
        String string = casaServiceEngineServiceUnit.getUnitName();
        String string2 = casaServiceEngineServiceUnit.getComponentName();
        if ((string2 = JbiDefaultComponentInfo.getDisplayName((String)string2).toUpperCase()).endsWith("SERVICEENGINE")) {
            string2 = string2.substring(0, string2.length() - 13);
        }
        casaNodeWidget.setNodeProperties(string, string2);
    }

    private static String getShortNameInUpperCase(String string) {
        int n = string.lastIndexOf(46) + 1;
        if (n > 0 && n < string.length()) {
            return string.substring(n).toUpperCase();
        }
        return string;
    }

    public static CasaPinWidget createPin(CasaComponent casaComponent, CasaComponent casaComponent2, String string, CasaModelGraphScene casaModelGraphScene, boolean bl) {
        CasaPinWidget casaPinWidget = (CasaPinWidget)casaModelGraphScene.addPin(casaComponent, casaComponent2);
        casaPinWidget.setProperties(string);
        casaPinWidget.setToolTipText(CasaModelGraphUtilities.getToolTipName(casaComponent, casaComponent2, casaModelGraphScene.getModel()));
        if (bl) {
            casaModelGraphScene.validate();
        }
        return casaPinWidget;
    }

    public static CasaProcessTitleWidget createProcess(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit, CasaEndpoint casaEndpoint, CasaModelGraphScene casaModelGraphScene, boolean bl) {
        CasaProcessTitleWidget casaProcessTitleWidget = (CasaProcessTitleWidget)casaModelGraphScene.addProcess(casaServiceEngineServiceUnit, casaEndpoint);
        if (bl) {
            casaModelGraphScene.validate();
        }
        return casaProcessTitleWidget;
    }

    public static ConnectionWidget createEdge(CasaConnection casaConnection, CasaConsumes casaConsumes, CasaProvides casaProvides, CasaModelGraphScene casaModelGraphScene, boolean bl) {
        ConnectionWidget connectionWidget = (ConnectionWidget)casaModelGraphScene.addEdge(casaConnection);
        casaModelGraphScene.setEdgeSource(casaConnection, casaConsumes);
        casaModelGraphScene.setEdgeTarget(casaConnection, casaProvides);
        if (bl) {
            casaModelGraphScene.updateEdgeRouting(connectionWidget);
            casaModelGraphScene.validate();
        }
        return connectionWidget;
    }

    public static CasaNodeWidget findNodeWidget(CasaPinWidget casaPinWidget) {
        CasaNodeWidget casaNodeWidget = null;
        for (Widget widget = casaPinWidget.getParentWidget(); widget != null; widget = widget.getParentWidget()) {
            if (!(widget instanceof CasaNodeWidget)) continue;
            casaNodeWidget = (CasaNodeWidget)widget;
            break;
        }
        return casaNodeWidget;
    }

    public static String getToolTipName(CasaComponent casaComponent, CasaComponent casaComponent2, CasaWrapperModel casaWrapperModel) {
        String string = "";
        if (casaComponent2 instanceof CasaEndpointRef) {
            CasaEndpointRef casaEndpointRef = (CasaEndpointRef)casaComponent2;
            string = casaEndpointRef.getServiceQName().toString();
            if (string != null && string.trim().length() > 0) {
                string = string + ".";
            }
            string = string + casaEndpointRef.getEndpointName();
        }
        return string;
    }

    public static void ensureVisibity(Widget widget) {
        widget.getScene().getView().scrollRectToVisible(widget.convertLocalToScene(widget.getBounds()));
    }

    public static void updateModelPosition(CasaModelGraphScene casaModelGraphScene, CasaComponent casaComponent, Point point) {
        CasaPort casaPort;
        if (casaComponent instanceof CasaServiceEngineServiceUnit) {
            CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = (CasaServiceEngineServiceUnit)casaComponent;
            if (casaServiceEngineServiceUnit.getX() != point.x || casaServiceEngineServiceUnit.getY() != point.y) {
                casaModelGraphScene.getModel().setLocation(casaServiceEngineServiceUnit, point.x, point.y);
            }
        } else if (casaComponent instanceof CasaPort && ((casaPort = (CasaPort)casaComponent).getX() != point.x || casaPort.getY() != point.y)) {
            casaModelGraphScene.getModel().setLocation(casaPort, point.x, point.y);
        }
    }

    public static void updateWidth(CasaModelGraphScene casaModelGraphScene, CasaRegionWidget casaRegionWidget) {
        CasaRegion casaRegion = (CasaRegion)casaModelGraphScene.findObject((Widget)casaRegionWidget);
        Rectangle rectangle = casaRegionWidget.getPreferredBounds();
        if (rectangle == null) {
            rectangle = casaRegionWidget.getBounds();
        }
        if (casaRegion.getWidth() != rectangle.width) {
            casaModelGraphScene.getModel().setCasaRegionWidth(casaRegion, rectangle.width);
        }
    }

    public static void setSceneEnabled(CasaModelGraphScene casaModelGraphScene, JbiBuildTask jbiBuildTask) {
        WidgetAction.Chain chain = casaModelGraphScene.getPriorActions();
        WaitMessageHandler.addToScene(casaModelGraphScene, jbiBuildTask);
        if (!chain.getActions().contains((Object)DISABLER)) {
            chain.addAction(0, (WidgetAction)DISABLER);
        }
    }

    public static void setSceneEnabled(CasaModelGraphScene casaModelGraphScene, boolean bl) {
        WidgetAction.Chain chain = casaModelGraphScene.getPriorActions();
        if (bl) {
            chain.removeAction((WidgetAction)DISABLER);
            WaitMessageHandler.removeFromScene(casaModelGraphScene);
        } else {
            WaitMessageHandler.addToScene(casaModelGraphScene, null);
            if (!chain.getActions().contains((Object)DISABLER)) {
                chain.addAction(0, (WidgetAction)DISABLER);
            }
        }
    }

    private static class DisablingAction
    extends WidgetAction.LockedAdapter {
        private DisablingAction() {
        }

        protected boolean isLocked() {
            return true;
        }

        public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State mouseEntered(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State mouseExited(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State mouseMoved(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State keyTyped(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State keyReleased(Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State dragEnter(Widget widget, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State dragOver(Widget widget, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State dropActionChanged(Widget widget, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State dragExit(Widget widget, WidgetAction.WidgetDropTargetEvent widgetDropTargetEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }

        public WidgetAction.State drop(Widget widget, WidgetAction.WidgetDropTargetDropEvent widgetDropTargetDropEvent) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
    }
}

