/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.tree.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.mapper.tree.models.VariableTreeInfoProvider;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTcContext;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTreeExtensionModel;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTreeModel;
import org.netbeans.modules.bpel.mapper.tree.spi.RestartableIterator;
import org.netbeans.modules.bpel.mapper.tree.spi.TreeItemInfoProvider;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.support.Roles;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartnerLinkTreeExtModel
implements MapperTreeExtensionModel<Object>,
TreeItemInfoProvider {
    private BpelEntity mContextEntity;
    private boolean mShowEndpointRef;

    public PartnerLinkTreeExtModel(BpelEntity bpelEntity, boolean bl) {
        this.mContextEntity = bpelEntity;
        this.mShowEndpointRef = bl;
    }

    @Override
    public List getChildren(RestartableIterator<Object> restartableIterator) {
        Object e = restartableIterator.next();
        if (e == MapperTreeModel.TREE_ROOT) {
            Process process = this.mContextEntity.getBpelModel().getProcess();
            PartnerLinkContainer partnerLinkContainer = process.getPartnerLinkContainer();
            if (partnerLinkContainer != null) {
                return Collections.singletonList(partnerLinkContainer);
            }
            return null;
        }
        if (e instanceof PartnerLinkContainer) {
            PartnerLinkContainer partnerLinkContainer = (PartnerLinkContainer)e;
            if (partnerLinkContainer != null) {
                return this.filterPartnerLink((Roles)(!this.mShowEndpointRef ? Roles.PARTNER_ROLE : null), partnerLinkContainer);
            }
        } else if (this.mShowEndpointRef && e instanceof PartnerLink) {
            PartnerLink partnerLink = (PartnerLink)e;
            ArrayList<Roles> arrayList = new ArrayList<Roles>();
            if (partnerLink.getMyRole() != null) {
                arrayList.add(Roles.MY_ROLE);
            }
            if (partnerLink.getPartnerRole() != null) {
                arrayList.add(Roles.PARTNER_ROLE);
            }
            return arrayList;
        }
        return null;
    }

    private List<PartnerLink> filterPartnerLink(Roles roles, PartnerLinkContainer partnerLinkContainer) {
        ArrayList<PartnerLink> arrayList;
        block5: {
            int n;
            PartnerLink[] partnerLinkArray;
            block4: {
                if (partnerLinkContainer == null) {
                    return Collections.emptyList();
                }
                partnerLinkArray = partnerLinkContainer.getPartnerLinks();
                if (roles == null) {
                    return Arrays.asList(partnerLinkArray);
                }
                arrayList = new ArrayList<PartnerLink>();
                n = partnerLinkArray.length;
                if (!Roles.MY_ROLE.equals((Object)roles)) break block4;
                for (int i = 0; i < n; ++i) {
                    PartnerLink partnerLink = partnerLinkArray[i];
                    if (partnerLink == null || partnerLink.getMyRole() == null) continue;
                    arrayList.add(partnerLink);
                }
                break block5;
            }
            if (!Roles.PARTNER_ROLE.equals((Object)roles)) break block5;
            for (int i = 0; i < n; ++i) {
                PartnerLink partnerLink = partnerLinkArray[i];
                if (partnerLink == null || partnerLink.getPartnerRole() == null) continue;
                arrayList.add(partnerLink);
            }
        }
        return arrayList;
    }

    @Override
    public Boolean isLeaf(Object object) {
        return null;
    }

    @Override
    public Boolean isConnectable(Object object) {
        if (this.mShowEndpointRef) {
            return object instanceof Roles;
        }
        return object instanceof PartnerLink;
    }

    @Override
    public TreeItemInfoProvider getTreeItemInfoProvider() {
        return this;
    }

    @Override
    public String getDisplayName(Object object) {
        if (object instanceof PartnerLinkContainer) {
            return NbBundle.getMessage(VariableTreeInfoProvider.class, (String)"PARTNER_LINK_CONTAINER");
        }
        return null;
    }

    @Override
    public Icon getIcon(Object object) {
        if (object instanceof PartnerLinkContainer) {
            return NodeType.VARIABLE_CONTAINER.getIcon();
        }
        return null;
    }

    @Override
    public List<Action> getMenuActions(MapperTcContext mapperTcContext, boolean bl, TreePath treePath, RestartableIterator<Object> restartableIterator) {
        return null;
    }

    @Override
    public String getToolTipText(Object object) {
        if (object instanceof Roles) {
            return ((Roles)object).toString();
        }
        return null;
    }
}

