/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.tree.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.cast.AbstractTypeCast;
import org.netbeans.modules.bpel.mapper.cast.CastManager;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.predicates.editor.PathConverter;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.actions.MapperAction;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTcContext;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTreeModel;
import org.netbeans.modules.bpel.mapper.tree.spi.RestartableIterator;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.xml.xpath.ext.XPathSchemaContext;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteCastAction
extends MapperAction<RestartableIterator<Object>> {
    private static final long serialVersionUID = 1L;
    private boolean mInLeftTree;
    private TreePath mTreePath;

    public DeleteCastAction(MapperTcContext mapperTcContext, boolean bl, TreePath treePath, RestartableIterator<Object> restartableIterator) {
        super(mapperTcContext, restartableIterator);
        this.mTreePath = treePath;
        this.mInLeftTree = bl;
        this.postInit();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(MapperAction.class, (String)"DELETE_CAST");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        RestartableIterator restartableIterator = (RestartableIterator)this.getActionSubject();
        restartableIterator.restart();
        Object e = restartableIterator.next();
        assert (e instanceof AbstractTypeCast);
        AbstractTypeCast abstractTypeCast = (AbstractTypeCast)e;
        XPathSchemaContext xPathSchemaContext = abstractTypeCast.getSchemaContext();
        if (xPathSchemaContext == null) {
            xPathSchemaContext = PathConverter.constructContext(restartableIterator);
        }
        MapperModel mapperModel = this.mMapperTcContext.getMapper().getModel();
        assert (mapperModel instanceof BpelMapperModel);
        BpelMapperModel bpelMapperModel = (BpelMapperModel)mapperModel;
        MapperSwingTreeModel mapperSwingTreeModel = null;
        mapperSwingTreeModel = this.mInLeftTree ? bpelMapperModel.getLeftTreeModel() : bpelMapperModel.getRightTreeModel();
        MapperTreeModel mapperTreeModel = mapperSwingTreeModel.getSourceModel();
        CastManager castManager = CastManager.getCastManager(mapperTreeModel);
        if (castManager != null) {
            castManager.deleteTypeCast(abstractTypeCast);
        }
        if (this.mInLeftTree) {
            List<TreePath> list = bpelMapperModel.getDependentGraphs(abstractTypeCast);
            for (TreePath treePath : list) {
                bpelMapperModel.removeIngoingLinks(treePath, this.mTreePath);
            }
            bpelMapperModel.fireGraphsChanged(list);
        } else {
            bpelMapperModel.removeNestedGraphs(this.mTreePath);
        }
        mapperSwingTreeModel.remove(this.mTreePath);
    }
}

