/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.tree.actions;

import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.predicates.SpecialStepManager;
import org.netbeans.modules.bpel.mapper.predicates.editor.PathConverter;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.actions.MapperAction;
import org.netbeans.modules.bpel.mapper.tree.models.VariableTreeModel;
import org.netbeans.modules.bpel.mapper.tree.search.TreeFinderProcessor;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTcContext;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTreeModel;
import org.netbeans.modules.bpel.mapper.tree.spi.RestartableIterator;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.support.BpelXPathModelFactory;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.StepNodeTest;
import org.netbeans.modules.xml.xpath.ext.StepNodeTestType;
import org.netbeans.modules.xml.xpath.ext.StepNodeTypeTest;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathSchemaContext;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddSpecialStepAction
extends MapperAction<RestartableIterator<Object>> {
    private static final long serialVersionUID = 1L;
    private StepNodeTestType mStepType;
    private boolean mInLeftTree;
    private TreePath mTreePath;

    public AddSpecialStepAction(StepNodeTestType stepNodeTestType, MapperTcContext mapperTcContext, boolean bl, TreePath treePath, RestartableIterator<Object> restartableIterator) {
        super(mapperTcContext, restartableIterator);
        this.mStepType = stepNodeTestType;
        this.mTreePath = treePath;
        this.mInLeftTree = bl;
        this.postInit();
    }

    @Override
    public String getDisplayName() {
        switch (this.mStepType) {
            case NODETYPE_COMMENT: {
                return NbBundle.getMessage(MapperAction.class, (String)"ADD_STEP_COMMENT");
            }
            case NODETYPE_NODE: {
                return NbBundle.getMessage(MapperAction.class, (String)"ADD_STEP_NODE");
            }
            case NODETYPE_PI: {
                return NbBundle.getMessage(MapperAction.class, (String)"ADD_STEP_PI");
            }
            case NODETYPE_TEXT: {
                return NbBundle.getMessage(MapperAction.class, (String)"ADD_STEP_TEXT");
            }
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        RestartableIterator restartableIterator = (RestartableIterator)this.getActionSubject();
        XPathSchemaContext xPathSchemaContext = PathConverter.constructContext(restartableIterator);
        if (xPathSchemaContext == null) {
            return;
        }
        StepNodeTypeTest stepNodeTypeTest = new StepNodeTypeTest(this.mStepType, null);
        BpelEntity bpelEntity = this.getDesignContext().getSelectedEntity();
        XPathModel xPathModel = BpelXPathModelFactory.create((BpelEntity)bpelEntity);
        xPathModel.setSchemaContext(xPathSchemaContext);
        LocationStep locationStep = xPathModel.getFactory().newLocationStep(null, (StepNodeTest)stepNodeTypeTest, null);
        xPathModel.setRootExpression((XPathExpression)locationStep);
        MapperModel mapperModel = this.mMapperTcContext.getMapper().getModel();
        assert (mapperModel instanceof BpelMapperModel);
        BpelMapperModel bpelMapperModel = (BpelMapperModel)mapperModel;
        MapperSwingTreeModel mapperSwingTreeModel = null;
        mapperSwingTreeModel = this.mInLeftTree ? bpelMapperModel.getLeftTreeModel() : bpelMapperModel.getRightTreeModel();
        MapperTreeModel mapperTreeModel = mapperSwingTreeModel.getSourceModel();
        VariableTreeModel variableTreeModel = MapperTreeModel.Utils.findExtensionModel(mapperTreeModel, VariableTreeModel.class);
        if (variableTreeModel != null && (object = variableTreeModel.getSStepManager()) != null) {
            ((SpecialStepManager)object).addStep(restartableIterator, locationStep);
        }
        mapperSwingTreeModel.insertChild(this.mTreePath, 0, locationStep);
        object = new TreeFinderProcessor(mapperSwingTreeModel);
        TreePath treePath = ((TreeFinderProcessor)object).findChildByDataObj(this.mTreePath, locationStep);
        if (this.mInLeftTree) {
            LeftTree leftTree = this.mMapperTcContext.getMapper().getLeftTree();
            leftTree.setSelectionPath(treePath);
        } else {
            Mapper mapper = this.mMapperTcContext.getMapper();
            mapper.setSelected(treePath);
        }
    }
}

