/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.tree.actions;

import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.cast.CastManager;
import org.netbeans.modules.bpel.mapper.cast.SubtypeChooser;
import org.netbeans.modules.bpel.mapper.cast.SyntheticTypeCast;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.actions.MapperAction;
import org.netbeans.modules.bpel.mapper.tree.search.TreeFinderProcessor;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTcContext;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTreeModel;
import org.netbeans.modules.bpel.mapper.tree.spi.RestartableIterator;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCastAction
extends MapperAction<RestartableIterator<Object>> {
    private static final long serialVersionUID = 1L;
    private boolean mInLeftTree;
    private TreePath mTreePath;
    private GlobalType mGType;

    public AddCastAction(GlobalType globalType, MapperTcContext mapperTcContext, boolean bl, TreePath treePath, RestartableIterator<Object> restartableIterator) {
        super(mapperTcContext, restartableIterator);
        this.mTreePath = treePath;
        this.mInLeftTree = bl;
        this.mGType = globalType;
        this.postInit();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(MapperAction.class, (String)"ADD_CAST");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        MapperModel mapperModel = this.mMapperTcContext.getMapper().getModel();
        assert (mapperModel instanceof BpelMapperModel);
        BpelMapperModel bpelMapperModel = (BpelMapperModel)mapperModel;
        MapperSwingTreeModel mapperSwingTreeModel = null;
        mapperSwingTreeModel = this.mInLeftTree ? bpelMapperModel.getLeftTreeModel() : bpelMapperModel.getRightTreeModel();
        MapperTreeModel mapperTreeModel = mapperSwingTreeModel.getSourceModel();
        CastManager castManager = CastManager.getCastManager(mapperTreeModel);
        if (castManager == null) {
            return;
        }
        BpelDesignContext bpelDesignContext = this.mMapperTcContext.getDesignContextController().getContext();
        assert (bpelDesignContext != null);
        SubtypeChooser subtypeChooser = new SubtypeChooser(this.mGType, bpelDesignContext.getBpelModel());
        if (!SubtypeChooser.showDlg(subtypeChooser)) {
            return;
        }
        GlobalType globalType = subtypeChooser.getSelectedValue();
        RestartableIterator restartableIterator = (RestartableIterator)this.getActionSubject();
        SyntheticTypeCast syntheticTypeCast = new SyntheticTypeCast(restartableIterator, globalType);
        castManager.addTypeCast(restartableIterator, syntheticTypeCast);
        TreePath treePath = this.mTreePath.getParentPath();
        int n = mapperSwingTreeModel.getIndexOfChild(treePath.getLastPathComponent(), this.mTreePath.getLastPathComponent());
        mapperSwingTreeModel.insertChild(treePath, n + 1, syntheticTypeCast);
        TreeFinderProcessor treeFinderProcessor = new TreeFinderProcessor(mapperSwingTreeModel);
        TreePath treePath2 = treeFinderProcessor.findChildByDataObj(treePath, syntheticTypeCast);
        if (this.mInLeftTree) {
            LeftTree leftTree = this.mMapperTcContext.getMapper().getLeftTree();
            leftTree.setSelectionPath(treePath2);
        } else {
            Mapper mapper = this.mMapperTcContext.getMapper();
            mapper.setSelected(treePath2);
        }
    }
}

