/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextController;
import org.netbeans.modules.bpel.mapper.predicates.editor.PathConverter;
import org.netbeans.modules.bpel.mapper.tree.MapperTreeNode;
import org.netbeans.modules.bpel.mapper.tree.TreePathComparator;
import org.netbeans.modules.bpel.mapper.tree.spi.ExtTreeModel;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTcContext;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTreeModel;
import org.netbeans.modules.bpel.mapper.tree.spi.RestartableIterator;
import org.netbeans.modules.bpel.mapper.tree.spi.TreeItemInfoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperSwingTreeModel
implements ExtTreeModel<MapperTreeNode>,
MapperTcContext.Provider {
    protected EventListenerList listenerList = new EventListenerList();
    private MapperTreeModel mSourceModel;
    private MapperTcContext mMapperTcContext;
    private MapperTreeNode mRootNode;

    public MapperSwingTreeModel(MapperTcContext mapperTcContext, MapperTreeModel mapperTreeModel) {
        this.mMapperTcContext = mapperTcContext;
        this.mSourceModel = mapperTreeModel;
    }

    @Override
    public MapperTcContext getMapperTcContext() {
        return this.mMapperTcContext;
    }

    @Override
    public Object getRoot() {
        if (this.mRootNode == null) {
            Object TreeItem = this.mSourceModel.getRoot();
            this.mRootNode = new MapperTreeNode(null, TreeItem);
        }
        return this.mRootNode;
    }

    @Override
    public Object getChild(Object object, int n) {
        assert (object instanceof MapperTreeNode);
        MapperTreeNode mapperTreeNode = (MapperTreeNode)object;
        List<MapperTreeNode> list = this.getChildren(mapperTreeNode);
        return list.get(n);
    }

    @Override
    public int getChildCount(Object object) {
        assert (object instanceof MapperTreeNode);
        MapperTreeNode mapperTreeNode = (MapperTreeNode)object;
        List<MapperTreeNode> list = this.getChildren(mapperTreeNode);
        return list.size();
    }

    @Override
    public boolean isLeaf(Object object) {
        assert (object instanceof MapperTreeNode);
        MapperTreeNode mapperTreeNode = (MapperTreeNode)object;
        Object DataObject = mapperTreeNode.getDataObject();
        Boolean bl = mapperTreeNode.isLeaf();
        if (bl == null) {
            bl = this.mSourceModel.isLeaf(DataObject);
        }
        if (bl == null) {
            List<MapperTreeNode> list = this.getChildren(mapperTreeNode);
            bl = list.isEmpty();
        }
        mapperTreeNode.setIsLeaf(bl);
        return bl;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        assert (object instanceof MapperTreeNode);
        MapperTreeNode mapperTreeNode = (MapperTreeNode)object;
        List<MapperTreeNode> list = this.getChildren(mapperTreeNode);
        return list.indexOf(object2);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    public void insertChild(TreePath treePath, int n, Object object) {
        Object object2 = treePath.getLastPathComponent();
        assert (object2 instanceof MapperTreeNode);
        List<MapperTreeNode> list = this.getChildren((MapperTreeNode)object2);
        MapperTreeNode<Object> mapperTreeNode = new MapperTreeNode<Object>((MapperTreeNode)object2, object);
        list.add(n, mapperTreeNode);
        this.fireTreeNodesInserted(this, treePath, n, mapperTreeNode);
    }

    public void remove(TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        Object object = treePath2.getLastPathComponent();
        assert (object instanceof MapperTreeNode);
        Object object2 = treePath.getLastPathComponent();
        int n = this.getIndexOfChild(object, object2);
        ((MapperTreeNode)object).removeChild(object2);
        this.fireTreeNodesRemoved(this, treePath2, n, object2);
    }

    public MapperTreeModel getSourceModel() {
        return this.mSourceModel;
    }

    public String getDisplayName(Object object) {
        TreeItemInfoProvider treeItemInfoProvider;
        assert (object instanceof MapperTreeNode);
        MapperTreeNode mapperTreeNode = (MapperTreeNode)object;
        String string = mapperTreeNode.getDisplayName();
        if (string == null && this.mSourceModel != null && (treeItemInfoProvider = this.mSourceModel.getTreeItemInfoProvider()) != null) {
            Object DataObject = mapperTreeNode.getDataObject();
            string = treeItemInfoProvider.getDisplayName(DataObject);
            mapperTreeNode.setDisplayName(string);
        }
        return string;
    }

    public String getToolTipText(Object object) {
        TreeItemInfoProvider treeItemInfoProvider;
        assert (object instanceof MapperTreeNode);
        MapperTreeNode mapperTreeNode = (MapperTreeNode)object;
        String string = null;
        if (this.mSourceModel != null && (treeItemInfoProvider = this.mSourceModel.getTreeItemInfoProvider()) != null) {
            Object DataObject = mapperTreeNode.getDataObject();
            string = treeItemInfoProvider.getToolTipText(DataObject);
        }
        return string;
    }

    public Icon getIcon(Object object) {
        TreeItemInfoProvider treeItemInfoProvider;
        assert (object instanceof MapperTreeNode);
        MapperTreeNode mapperTreeNode = (MapperTreeNode)object;
        Icon icon = mapperTreeNode.getIcon();
        if (icon == null && this.mSourceModel != null && (treeItemInfoProvider = this.mSourceModel.getTreeItemInfoProvider()) != null) {
            Object DataObject = mapperTreeNode.getDataObject();
            icon = treeItemInfoProvider.getIcon(DataObject);
            mapperTreeNode.setIcon(icon);
        }
        return icon;
    }

    public boolean isConnectable(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        assert (object instanceof MapperTreeNode);
        MapperTreeNode mapperTreeNode = (MapperTreeNode)object;
        Object DataObject = mapperTreeNode.getDataObject();
        return this.mSourceModel.isConnectable(DataObject) == Boolean.TRUE;
    }

    public JPopupMenu getPopupMenu(Object object) {
        TreeModel treeModel;
        boolean bl;
        List<Action> list;
        assert (object instanceof MapperTreeNode);
        MapperTreeNode mapperTreeNode = (MapperTreeNode)object;
        TreePath treePath = mapperTreeNode.getTreePath();
        RestartableIterator<Object> restartableIterator = this.getDataObjectsPathIterator(mapperTreeNode);
        TreeItemInfoProvider treeItemInfoProvider = this.mSourceModel.getTreeItemInfoProvider();
        if (treeItemInfoProvider != null && (list = treeItemInfoProvider.getMenuActions(this.mMapperTcContext, bl = (treeModel = this.mMapperTcContext.getMapper().getModel().getLeftTreeModel()) == this, treePath, restartableIterator)) != null && !list.isEmpty()) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (Action action : list) {
                JMenuItem jMenuItem = new JMenuItem(action);
                jPopupMenu.add(jMenuItem);
            }
            return jPopupMenu;
        }
        return null;
    }

    @Override
    public List<MapperTreeNode> getChildren(MapperTreeNode mapperTreeNode) {
        List<MapperTreeNode> list = mapperTreeNode.getChildren();
        if (list == null) {
            list = new ArrayList<MapperTreeNode>();
            RestartableIterator<Object> restartableIterator = this.getDataObjectsPathIterator(mapperTreeNode);
            List list2 = this.mSourceModel.getChildren(restartableIterator);
            if (list2 != null) {
                DesignContextController designContextController = this.mMapperTcContext.getDesignContextController();
                for (Object TreeItem : list2) {
                    if (designContextController != null) {
                        designContextController.processDataObject(TreeItem);
                    }
                    MapperTreeNode mapperTreeNode2 = new MapperTreeNode(mapperTreeNode, TreeItem);
                    list.add(mapperTreeNode2);
                }
            }
        }
        mapperTreeNode.setChildren(list);
        return list;
    }

    public void fireTreeChanged(Object object, TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                TreePath treePath2 = treePath.getParentPath();
                Object object2 = treePath.getLastPathComponent();
                assert (object2 instanceof MapperTreeNode);
                ((MapperTreeNode)object2).discardCachedData();
                int n = this.getIndexOfChild(treePath2.getLastPathComponent(), object2);
                treeModelEvent = new TreeModelEvent(object, treePath2, new int[]{n}, new Object[]{object2});
            }
            ((TreeModelListener)objectArray[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, TreePath treePath, int n, Object object2) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, treePath, new int[]{n}, new Object[]{object2});
            }
            ((TreeModelListener)objectArray[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, TreePath treePath, int n, Object object2) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, treePath, new int[]{n}, new Object[]{object2});
            }
            ((TreeModelListener)objectArray[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    private RestartableIterator<Object> getDataObjectsPathIterator(final MapperTreeNode mapperTreeNode) {
        return new RestartableIterator(){
            private MapperTreeNode mNextNode;
            {
                this.mNextNode = mapperTreeNode;
            }

            public boolean hasNext() {
                return this.mNextNode != null;
            }

            public Object next() {
                assert (this.mNextNode != null);
                Object DataObject = this.mNextNode.getDataObject();
                this.mNextNode = this.mNextNode.getParent();
                return DataObject;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void restart() {
                this.mNextNode = mapperTreeNode;
            }

            public String toString() {
                return PathConverter.toString(this);
            }
        };
    }

    public List<TreePath> sortByLocation(Collection<TreePath> collection) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(collection.size());
        arrayList.addAll(collection);
        Collections.sort(arrayList, new TreePathComparator(this));
        return arrayList;
    }

    public static List<Object> convertTreePath(TreePath treePath) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : treePath.getPath()) {
            if (!(object instanceof MapperTreeNode)) continue;
            MapperTreeNode mapperTreeNode = (MapperTreeNode)object;
            Object DataObject = mapperTreeNode.getDataObject();
            arrayList.add(DataObject);
        }
        return arrayList;
    }

    public static Object getDataObject(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (object instanceof MapperTreeNode) {
            Object DataObject = ((MapperTreeNode)object).getDataObject();
            return DataObject;
        }
        return null;
    }

    public static boolean containsDataObject(TreePath treePath, Object object) {
        while (treePath != null) {
            Object DataObject;
            Object object2 = treePath.getLastPathComponent();
            if (object2 instanceof MapperTreeNode && (DataObject = ((MapperTreeNode)object2).getDataObject()).equals(object)) {
                return true;
            }
            treePath = treePath.getParentPath();
        }
        return false;
    }
}

