/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.palette;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.model.ItemHandler;
import org.netbeans.modules.bpel.mapper.palette.Palette;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.model.GraphSubset;
import org.netbeans.modules.soa.mappercore.utils.GraphLayout;

final class Item
extends JMenuItem
implements DragGestureListener,
Transferable {
    private Palette myPalette;
    private ItemHandler myHandler;
    private DataFlavor myDataFlavor;

    Item(Palette palette, ItemHandler itemHandler) {
        super(itemHandler.getDisplayName(), itemHandler.getIcon());
        this.myPalette = palette;
        this.myHandler = itemHandler;
        try {
            this.myDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 3, this);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Mapper mapper = Item.this.myPalette.getMapper();
                TreePath treePath = mapper.getSelectedPath();
                BpelMapperModel bpelMapperModel = (BpelMapperModel)mapper.getModel();
                GraphSubset graphSubset = bpelMapperModel.add(treePath, Item.this.myHandler, GraphLayout.getNextFreeX((Graph)bpelMapperModel.getGraph(treePath)), 0);
                if (graphSubset != null && graphSubset.getVertexCount() > 0) {
                    mapper.getSelectionModel().setSelected(treePath, (GraphItem)graphSubset.getVertex(0));
                }
            }
        });
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.myDataFlavor};
    }

    public Object getTransferData(DataFlavor dataFlavor) {
        if (this.isDataFlavorSupported(dataFlavor)) {
            return new Object[]{this.myHandler, this.myPalette};
        }
        return null;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor == this.myDataFlavor;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (this.isEnabled() && this.isVisible()) {
            DragSource.getDefaultDragSource().startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, this, null);
        }
    }
}

