/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.multiview;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.bpel.core.BPELDataEditorSupport;
import org.netbeans.modules.bpel.core.BPELDataObject;
import org.netbeans.modules.bpel.mapper.model.BpelMapperFactory;
import org.netbeans.modules.bpel.mapper.multiview.ActivatedNodesMediator;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.multiview.CookieProxyLookup;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextChangeListener;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextController;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextUtil;
import org.netbeans.modules.bpel.mapper.multiview.MessagePanel;
import org.netbeans.modules.bpel.mapper.multiview.ShowMapperCookie;
import org.netbeans.modules.bpel.mapper.palette.Palette;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTcContext;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public abstract class MapperMultiviewElement
extends TopComponent
implements MultiViewElement,
Serializable,
MapperTcContext,
ExplorerManager.Provider {
    public static final String MAPPER_PANEL_ID = "mapperPanelId";
    private transient JPanel myMapperPanel;
    private transient Mapper myMapper;
    private transient JEditorPane myErrorPanel;
    private transient CardLayout myCardLayout;
    private transient JComponent myToolBarPanel;
    private transient MultiViewElementCallback myMultiViewObserver;
    private BPELDataObject myDataObject;
    private DesignContextChangeListener myContextChangeListener;
    private DesignContextController myContextController;
    private Boolean groupVisible;
    private ActivatedNodesMediator myNodesMediator;
    private CookieProxyLookup myCookieProxyLookup;
    private ExplorerManager myExplorerManager;

    public MapperMultiviewElement() {
    }

    public MapperMultiviewElement(BPELDataObject bPELDataObject) {
        this.myDataObject = bPELDataObject;
        this.initialize();
        this.initializeUI();
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        if (this.myToolBarPanel == null) {
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.setFocusable(false);
            jToolBar.addSeparator();
            int n = 0;
            for (Component component : jToolBar.getComponents()) {
                if (!(component instanceof JButton) && !(component instanceof JToggleButton)) continue;
                n = Math.max(component.getPreferredSize().height, n);
            }
            for (Component component : jToolBar.getComponents()) {
                if (component instanceof JButton || component instanceof JToggleButton) {
                    Dimension dimension = component.getMaximumSize();
                    dimension.height = n;
                    component.setMaximumSize(dimension);
                    component.setMinimumSize(component.getPreferredSize());
                    component.setFocusable(false);
                    continue;
                }
                if (component instanceof JTextComponent || component instanceof JComboBox) {
                    component.setMaximumSize(component.getPreferredSize());
                    component.setMinimumSize(component.getPreferredSize());
                    continue;
                }
                component.setMinimumSize(component.getPreferredSize());
                component.setFocusable(false);
            }
            this.myToolBarPanel = jToolBar;
        }
        return this.myToolBarPanel;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.myMultiViewObserver = multiViewElementCallback;
    }

    public DesignContextController getDesignContextController() {
        return this.myContextController;
    }

    public TopComponent getTopComponent() {
        return this;
    }

    public CloseOperationState canCloseElement() {
        boolean bl = this.isLastView();
        if (!bl) {
            return CloseOperationState.STATE_OK;
        }
        BPELDataEditorSupport bPELDataEditorSupport = this.myDataObject.getEditorSupport();
        boolean bl2 = bPELDataEditorSupport.isModified();
        if (!bl2) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"Data Object Modified", null, null);
    }

    public void componentActivated() {
        Component component;
        super.componentActivated();
        boolean bl = true;
        if (this.myMapper != null && !this.isFocusInside((Component)this.myMapper) && (component = this.getFocusableDescendant((Component)this.myMapper)) != null) {
            component.requestFocusInWindow();
            bl = false;
        }
        if (bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        }
        this.activateContextNode();
        ExplorerUtils.activateActions((ExplorerManager)this.myExplorerManager, (boolean)true);
    }

    private boolean isFocusInside(Component component) {
        Component component2;
        for (Component component3 = component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); component3 != null; component3 = component3.getParent()) {
            if (component3 != component) continue;
            return true;
        }
        return false;
    }

    private Component getFocusableDescendant(Component component) {
        if (component instanceof JTree) {
            return component;
        }
        Component component2 = null;
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = container.getComponentCount() - 1; i >= 0 && (component2 = this.getFocusableDescendant(container.getComponent(i))) == null; --i) {
            }
        }
        return component2;
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentShowing() {
        super.componentShowing();
        this.myContextController.showMapper();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        ExplorerUtils.activateActions((ExplorerManager)this.myExplorerManager, (boolean)false);
    }

    public void componentHidden() {
        super.componentHidden();
        this.myContextController.hideMapper();
    }

    public void componentClosed() {
        super.componentClosed();
        this.cleanup();
    }

    private void cleanup() {
        try {
            this.myExplorerManager.setSelectedNodes(new Node[0]);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.removePropertyChangeListener("activatedNodes", this.myNodesMediator);
        this.removePropertyChangeListener("activatedNodes", this.myCookieProxyLookup);
        this.myNodesMediator = null;
        this.myCookieProxyLookup = null;
        this.myContextController.cleanup();
        this.myContextController = null;
        this.myContextChangeListener = null;
        this.myMapper = null;
        this.removeAll();
    }

    public UndoRedo getUndoRedo() {
        return this.myDataObject.getEditorSupport().getUndoManager();
    }

    public void showMapperTcGroup(boolean bl) {
    }

    public static String getTitleBase() {
        return NbBundle.getMessage(MapperMultiviewElement.class, (String)"TITLE_MAPPER_WINDOW");
    }

    public ExplorerManager getExplorerManager() {
        return this.myExplorerManager;
    }

    private boolean isLastView() {
        boolean bl = true;
        Enumeration enumeration = ((CloneableTopComponent)this.myMultiViewObserver.getTopComponent()).getReference().getComponents();
        if (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                bl = false;
            }
        }
        return bl;
    }

    protected abstract DesignContextController createDesignContextController();

    protected void initialize() {
        ShowMapperCookie showMapperCookie = new ShowMapperCookie(){

            public void show(MapperModel mapperModel) {
                MapperMultiviewElement.this.setMapperModel(mapperModel);
            }

            public void show(String string) {
                MapperMultiviewElement.this.setMessage(string);
            }
        };
        this.myExplorerManager = new ExplorerManager();
        Node node = this.myDataObject.getNodeDelegate();
        this.myNodesMediator = new ActivatedNodesMediator(node);
        this.myNodesMediator.setExplorerManager(this);
        this.myCookieProxyLookup = new CookieProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{showMapperCookie, this.myDataObject}), this.myDataObject.getLookup(), Lookups.singleton((Object)this), this.myNodesMediator.getLookup(), node.getLookup()}, node);
        this.associateLookup((Lookup)this.myCookieProxyLookup);
        this.addPropertyChangeListener("activatedNodes", this.myNodesMediator);
        this.addPropertyChangeListener("activatedNodes", this.myCookieProxyLookup);
        this.myContextController = this.createDesignContextController();
    }

    protected void initializeUI() {
        this.activateContextNode();
        this.myMapperPanel = new JPanel();
        this.myMapperPanel.setLayout(new BorderLayout());
        this.myMapper = BpelMapperFactory.createMapper(null);
        this.myMapperPanel.add((Component)this.myMapper, "Center");
        this.myMapperPanel.add((Component)new Palette(this.myMapper).createMenuBar(), "North");
        this.myErrorPanel = new MessagePanel(this.myMapper);
        this.myErrorPanel.setText("<b>It is Error Panel !!!</b>");
        this.myCardLayout = new CardLayout();
        this.setLayout(this.myCardLayout);
        this.add(this.myMapperPanel, MAPPER_PANEL_ID);
        this.add(this.myErrorPanel, "messagePanelId");
    }

    private void activateContextNode() {
        BpelDesignContext bpelDesignContext = this.myContextController != null ? this.myContextController.getContext() : null;
        Node node = null;
        if (DesignContextUtil.isValidContext(bpelDesignContext)) {
            node = bpelDesignContext == null ? null : bpelDesignContext.getActivatedNode();
        }
        Node[] nodeArray = this.getActivatedNodes();
        Node node2 = null;
        if (nodeArray != null && nodeArray.length > 0 && DesignContextUtil.isValidNode(nodeArray[0])) {
            node2 = nodeArray[0];
        }
        if (node2 == null || !node2.equals((Object)node)) {
            if (node != null) {
                this.setActivatedNodes(new Node[]{node});
            } else {
                this.setActivatedNodes(new Node[0]);
            }
        }
    }

    public void setMapper(Mapper mapper) {
    }

    private void setMapperInAwt(Mapper mapper) {
        assert (EventQueue.isDispatchThread());
        if (mapper != null) {
            this.myCardLayout.show((Container)((Object)this), MAPPER_PANEL_ID);
        }
        this.revalidate();
        this.repaint();
    }

    private void showMapper() {
        assert (EventQueue.isDispatchThread());
        if (this.myMapper == null) {
            return;
        }
        this.myCardLayout.show((Container)((Object)this), MAPPER_PANEL_ID);
        this.revalidate();
        this.repaint();
    }

    public Mapper getMapper() {
        return this.myMapper;
    }

    private void setMessage(final String string) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MapperMultiviewElement.this.setMessageInAwt(string);
                }
            });
        } else {
            this.setMessageInAwt(string);
        }
    }

    private void setMessageInAwt(String string) {
        assert (EventQueue.isDispatchThread());
        if (string != null) {
            this.myErrorPanel.setText(string);
        } else {
            this.myErrorPanel.setText(NbBundle.getMessage(MapperMultiviewElement.class, (String)"LBL_CantShowMapper"));
        }
        this.myCardLayout.show((Container)((Object)this), "messagePanelId");
    }

    public void setMapperModel(final MapperModel mapperModel) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MapperMultiviewElement.this.setMapperModelInAwt(mapperModel);
                }
            });
        } else {
            this.setMapperModelInAwt(mapperModel);
        }
    }

    private void setMapperModelInAwt(MapperModel mapperModel) {
        assert (EventQueue.isDispatchThread());
        if (this.myMapper != null) {
            this.myMapper.setModel(mapperModel);
            this.showMapper();
        }
    }

    protected abstract Mapper createMapper(MapperModel var1);

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.myDataObject);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.myDataObject = (BPELDataObject)objectInput.readObject();
        this.initialize();
        this.initializeUI();
    }
}

