/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.multiview;

import java.lang.ref.WeakReference;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.support.VisibilityScope;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class BpelDesignContextImpl
implements BpelDesignContext {
    private WeakReference<Node> mActivatedNode;
    private Lookup mLookup;
    private WeakReference<BpelEntity> mSelectedEntityRef;
    private WeakReference<BpelEntity> mGraphEntityRef;
    private WeakReference<BpelEntity> mContextEntityRef;
    private String mMessage;
    private VisibilityScope mVisibilityScope;
    private StringBuffer validationErrMsgBuffer = new StringBuffer();

    public BpelDesignContextImpl(BpelEntity bpelEntity, BpelEntity bpelEntity2, BpelEntity bpelEntity3, Node node, Lookup lookup) {
        this.mActivatedNode = new WeakReference<Node>(node);
        this.mLookup = lookup;
        this.mContextEntityRef = new WeakReference<BpelEntity>(bpelEntity);
        this.mGraphEntityRef = new WeakReference<BpelEntity>(bpelEntity2);
        this.mSelectedEntityRef = new WeakReference<BpelEntity>(bpelEntity3);
    }

    public BpelDesignContextImpl(String string) {
        this(null, null, null, null, null);
        this.mMessage = string;
    }

    public BpelEntity getContextEntity() {
        return (BpelEntity)this.mContextEntityRef.get();
    }

    public BpelEntity getGraphEntity() {
        BpelEntity bpelEntity = (BpelEntity)this.mGraphEntityRef.get();
        if (bpelEntity != null && bpelEntity.isInDocumentModel()) {
            return bpelEntity;
        }
        return this.getContextEntity();
    }

    public BpelEntity getSelectedEntity() {
        BpelEntity bpelEntity = (BpelEntity)this.mSelectedEntityRef.get();
        if (bpelEntity != null && bpelEntity.isInDocumentModel()) {
            return bpelEntity;
        }
        return this.getGraphEntity();
    }

    public Node getActivatedNode() {
        return (Node)this.mActivatedNode.get();
    }

    public Lookup getLookup() {
        return this.mLookup;
    }

    public BpelModel getBpelModel() {
        BpelEntity bpelEntity;
        if (this.mContextEntityRef != null && (bpelEntity = (BpelEntity)this.mContextEntityRef.get()) != null) {
            return bpelEntity.getBpelModel();
        }
        return null;
    }

    public String toString() {
        return "ContextEntity: " + this.mContextEntityRef + "GraphEntity: " + this.mGraphEntityRef + "SelectedEntity: " + this.mSelectedEntityRef + " Lookup: " + this.mLookup;
    }

    public boolean equals(Object object) {
        BpelDesignContext bpelDesignContext;
        return object instanceof BpelDesignContext && (bpelDesignContext = (BpelDesignContext)object).getContextEntity() == this.getContextEntity() && bpelDesignContext.getGraphEntity() == this.getGraphEntity() && bpelDesignContext.getSelectedEntity() == this.getSelectedEntity() && bpelDesignContext.getLookup() == this.getLookup();
    }

    public String getMessage() {
        return this.mMessage;
    }

    public synchronized VisibilityScope getVisibilityScope() {
        if (this.mVisibilityScope == null) {
            this.mVisibilityScope = new VisibilityScope(this.getSelectedEntity());
        }
        return this.mVisibilityScope;
    }

    public StringBuffer getValidationErrMsgBuffer() {
        return this.validationErrMsgBuffer;
    }
}

