/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.model.CopyToProcessor;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.tree.models.ConditionValueTreeModel;
import org.netbeans.modules.bpel.mapper.tree.models.DateValueTreeModel;
import org.netbeans.modules.bpel.mapper.tree.models.ForEachConditionsTreeModel;
import org.netbeans.modules.bpel.mapper.tree.search.ResultNodeFinder;
import org.netbeans.modules.bpel.mapper.tree.search.SimpleFinder;
import org.netbeans.modules.bpel.mapper.tree.search.TreeFinderProcessor;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTcContext;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTreeModel;
import org.netbeans.modules.bpel.mapper.tree.spi.TreeItemFinder;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.CompletionCondition;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.DeadlineExpression;
import org.netbeans.modules.bpel.model.api.ElseIf;
import org.netbeans.modules.bpel.model.api.FinalCounterValue;
import org.netbeans.modules.bpel.model.api.For;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.OnAlarmEvent;
import org.netbeans.modules.bpel.model.api.OnAlarmPick;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.RepeatUntil;
import org.netbeans.modules.bpel.model.api.StartCounterValue;
import org.netbeans.modules.bpel.model.api.TimeEvent;
import org.netbeans.modules.bpel.model.api.TimeEventHolder;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.Wait;
import org.netbeans.modules.bpel.model.api.While;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphExpandProcessor {
    public static void expandGraph(MapperTcContext mapperTcContext, BpelDesignContext bpelDesignContext) {
        if (mapperTcContext == null || bpelDesignContext == null) {
            return;
        }
        Mapper mapper = mapperTcContext.getMapper();
        MapperModel mapperModel = mapper.getModel();
        BpelEntity bpelEntity = bpelDesignContext.getContextEntity();
        GraphExpandProcessor.expandVariablesNode(mapper, bpelEntity.getBpelModel(), true, true);
        BpelEntity bpelEntity2 = bpelDesignContext.getGraphEntity();
        List<TreePath> list = GraphExpandProcessor.getTargetPathes(mapperTcContext, bpelEntity2);
        boolean bl = bpelEntity instanceof ForEach;
        boolean bl2 = true;
        for (TreePath treePath : list) {
            Graph graph = ((BpelMapperModel)mapperModel).getGraphsInside(null).get(treePath);
            mapper.setExpandedState(treePath, true);
            if (graph != null) {
                mapper.setExpandedGraphState(treePath, true);
            }
            if (bl || bl2) {
                mapper.setSelected(treePath);
                if (graph != null) {
                    mapper.getRightTree().scrollRectToVisible(graph.getBounds());
                    LeftTree leftTree = mapper.getLeftTree();
                    GraphExpandProcessor.expandIngoingLinks(graph, leftTree);
                }
            }
            bl2 = false;
        }
    }

    public static void expandAllGraphs(Mapper mapper, MapperModel mapperModel) {
        Map<TreePath, Graph> map = ((BpelMapperModel)mapperModel).getGraphsInside(null);
        for (TreePath treePath : map.keySet()) {
            Graph graph = map.get(treePath);
            mapper.setExpandedState(treePath, true);
            if (graph == null) continue;
            mapper.setExpandedGraphState(treePath, true);
            LeftTree leftTree = mapper.getLeftTree();
            GraphExpandProcessor.expandIngoingLinks(graph, leftTree);
        }
    }

    public static void selectGraph(Mapper mapper, TreePath treePath, Graph graph) {
        mapper.setSelected(treePath);
        if (graph != null) {
            mapper.getRightTree().scrollRectToVisible(graph.getBounds());
        }
    }

    private static List<TreePath> getTargetPathes(MapperTcContext mapperTcContext, BpelEntity bpelEntity) {
        List<TreeItemFinder> list;
        TreePath treePath;
        Mapper mapper = mapperTcContext.getMapper();
        MapperModel mapperModel = mapper.getModel();
        assert (mapperModel instanceof BpelMapperModel);
        BpelMapperModel bpelMapperModel = (BpelMapperModel)mapperModel;
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        TreeFinderProcessor treeFinderProcessor = new TreeFinderProcessor(bpelMapperModel.getRightTreeModel());
        Class clazz = bpelEntity.getElementType();
        if (clazz == Copy.class) {
            Copy copy = (Copy)bpelEntity;
            To to = copy.getTo();
            CopyToProcessor.CopyToForm copyToForm = CopyToProcessor.getCopyToForm(to);
            ArrayList<TreeItemFinder> arrayList2 = CopyToProcessor.constructFindersList(copyToForm, (BpelEntity)copy, to, null, null, null);
            TreePath treePath2 = treeFinderProcessor.findFirstNode(arrayList2);
            if (treePath2 != null) {
                arrayList.add(treePath2);
            }
        } else if (clazz == Assign.class) {
            Assign assign = (Assign)bpelEntity;
            List list2 = assign.getChildren(Copy.class);
            if (!list2.isEmpty()) {
                Copy copy = (Copy)list2.iterator().next();
                return GraphExpandProcessor.getTargetPathes(mapperTcContext, (BpelEntity)copy);
            }
        } else if (clazz == Wait.class || clazz == OnAlarmPick.class || clazz == OnAlarmEvent.class) {
            TimeEventHolder timeEventHolder = (TimeEventHolder)bpelEntity;
            TimeEvent timeEvent = timeEventHolder.getTimeEvent();
            if (timeEvent != null) {
                String string = null;
                if (timeEvent instanceof For) {
                    string = DateValueTreeModel.DURATION_CONDITION;
                } else if (timeEvent instanceof DeadlineExpression) {
                    string = DateValueTreeModel.DEADLINE_CONDITION;
                }
                List<TreeItemFinder> list3 = Collections.singletonList(new ResultNodeFinder(string));
                TreePath treePath3 = treeFinderProcessor.findFirstNode(list3);
                if (treePath3 != null) {
                    arrayList.add(treePath3);
                }
            }
        } else if (clazz == If.class || clazz == ElseIf.class || clazz == While.class || clazz == RepeatUntil.class) {
            List<TreeItemFinder> list4 = Collections.singletonList(new ResultNodeFinder(ConditionValueTreeModel.BOOLEAN_CONDITION));
            TreePath treePath4 = treeFinderProcessor.findFirstNode(list4);
            if (treePath4 != null) {
                arrayList.add(treePath4);
            }
        } else if (clazz == ForEach.class) {
            List<TreeItemFinder> list5 = Collections.singletonList(new ResultNodeFinder(ForEachConditionsTreeModel.START_VALUE));
            TreePath treePath5 = treeFinderProcessor.findFirstNode(list5);
            if (treePath5 != null) {
                arrayList.add(treePath5);
            }
            if ((treePath5 = treeFinderProcessor.findFirstNode(list5 = Collections.singletonList(new ResultNodeFinder(ForEachConditionsTreeModel.FINAL_VALUE)))) != null) {
                arrayList.add(treePath5);
            }
            if ((treePath5 = treeFinderProcessor.findFirstNode(list5 = Collections.singletonList(new ResultNodeFinder(ForEachConditionsTreeModel.COMPLETION_CONDITION)))) != null) {
                arrayList.add(treePath5);
            }
        } else if (clazz == StartCounterValue.class) {
            List<TreeItemFinder> list6 = Collections.singletonList(new ResultNodeFinder(ForEachConditionsTreeModel.START_VALUE));
            TreePath treePath6 = treeFinderProcessor.findFirstNode(list6);
            if (treePath6 != null) {
                arrayList.add(treePath6);
            }
        } else if (clazz == FinalCounterValue.class) {
            List<TreeItemFinder> list7 = Collections.singletonList(new ResultNodeFinder(ForEachConditionsTreeModel.FINAL_VALUE));
            TreePath treePath7 = treeFinderProcessor.findFirstNode(list7);
            if (treePath7 != null) {
                arrayList.add(treePath7);
            }
        } else if (clazz == CompletionCondition.class && (treePath = treeFinderProcessor.findFirstNode(list = Collections.singletonList(new ResultNodeFinder(ForEachConditionsTreeModel.COMPLETION_CONDITION)))) != null) {
            arrayList.add(treePath);
        }
        return arrayList;
    }

    public static void expandIngoingLinks(Graph graph, LeftTree leftTree) {
        List list = graph.getIngoingLinks();
        for (Link link : list) {
            TreePath treePath;
            SourcePin sourcePin = link.getSource();
            if (sourcePin == null || !(sourcePin instanceof TreeSourcePin) || (treePath = ((TreeSourcePin)sourcePin).getTreePath()) == null) continue;
            leftTree.expandPath(treePath.getParentPath());
        }
    }

    public static void expandVariablesNode(Mapper mapper, final BpelModel bpelModel, boolean bl, boolean bl2) {
        TreeFinderProcessor treeFinderProcessor;
        TreePath treePath;
        SimpleFinder simpleFinder = new SimpleFinder(){

            protected boolean isFit(Object object) {
                return object instanceof Process && bpelModel.getProcess().equals(object);
            }

            protected boolean drillDeeper(Object object) {
                return object == MapperTreeModel.TREE_ROOT;
            }
        };
        MapperModel mapperModel = mapper.getModel();
        assert (mapperModel instanceof BpelMapperModel);
        BpelMapperModel bpelMapperModel = (BpelMapperModel)mapperModel;
        if (bl && (treePath = (treeFinderProcessor = new TreeFinderProcessor(bpelMapperModel.getLeftTreeModel())).findFirstNode(Collections.singletonList(simpleFinder))) != null) {
            mapper.getLeftTree().expandPath(treePath);
        }
        if (bl2 && (treePath = (treeFinderProcessor = new TreeFinderProcessor(bpelMapperModel.getRightTreeModel())).findFirstNode(Collections.singletonList(simpleFinder))) != null) {
            mapper.setExpandedGraphState(treePath, true);
        }
    }
}

