/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreePath;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.mapper.cast.AbstractTypeCast;
import org.netbeans.modules.bpel.mapper.cast.CastManager;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.model.GraphInfoCollector;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.predicates.AbstractPredicate;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.models.VariableDeclarationWrapper;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTcContext;
import org.netbeans.modules.bpel.model.api.AbstractVariableDeclaration;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.ExtensibleElements;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.VariableDeclarationScope;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.support.BpelXPathModelFactory;
import org.netbeans.modules.bpel.model.api.support.Roles;
import org.netbeans.modules.bpel.model.api.support.XPathBpelVariable;
import org.netbeans.modules.soa.mappercore.model.Constant;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xpath.ext.CoreFunctionType;
import org.netbeans.modules.xml.xpath.ext.CoreOperationType;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.StepNodeNameTest;
import org.netbeans.modules.xml.xpath.ext.StepNodeTest;
import org.netbeans.modules.xml.xpath.ext.XPathAxis;
import org.netbeans.modules.xml.xpath.ext.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathNumericLiteral;
import org.netbeans.modules.xml.xpath.ext.XPathOperationOrFuntion;
import org.netbeans.modules.xml.xpath.ext.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.ext.XPathStringLiteral;
import org.netbeans.modules.xml.xpath.ext.XPathVariableReference;
import org.netbeans.modules.xml.xpath.ext.metadata.ArgumentDescriptor;
import org.netbeans.modules.xml.xpath.ext.metadata.ExtFunctionMetadata;
import org.netbeans.modules.xml.xpath.ext.metadata.StubExtFunction;
import org.netbeans.modules.xml.xpath.ext.metadata.XPathType;
import org.netbeans.modules.xml.xpath.ext.schema.ExNamespaceContext;
import org.netbeans.modules.xml.xpath.ext.schema.InvalidNamespaceException;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBpelModelUpdater {
    protected MapperTcContext mMapperTcContext;

    public AbstractBpelModelUpdater(MapperTcContext mapperTcContext) {
        assert (mapperTcContext != null);
        this.mMapperTcContext = mapperTcContext;
    }

    public BpelDesignContext getDesignContext() {
        return this.mMapperTcContext.getDesignContextController().getContext();
    }

    public BpelMapperModel getMapperModel() {
        MapperModel mapperModel = this.mMapperTcContext.getMapper().getModel();
        assert (mapperModel instanceof BpelMapperModel);
        return (BpelMapperModel)mapperModel;
    }

    public XPathExprList buildXPathExprList(XPathModel xPathModel, GraphInfoCollector graphInfoCollector, Set<AbstractTypeCast> set) {
        TreeSourcePin treeSourcePin;
        ArrayList<XPathExpression> arrayList = new ArrayList<XPathExpression>();
        boolean bl = false;
        for (Link link : graphInfoCollector.getTransitLinks()) {
            treeSourcePin = (TreeSourcePin)link.getSource();
            TreePath treePath = treeSourcePin.getTreePath();
            TreePathInfo treePathInfo = this.collectTreeInfo(treePath, set);
            XPathExpression xPathExpression = this.createVariableXPath(xPathModel, treePathInfo, set);
            if (xPathExpression == null) continue;
            xPathModel.fillInStubs(xPathExpression);
            arrayList.add(xPathExpression);
            bl = true;
        }
        for (Vertex vertex : graphInfoCollector.getPrimaryRoots()) {
            treeSourcePin = this.createXPathRecursive(xPathModel, vertex, set);
            if (treeSourcePin == null) continue;
            xPathModel.fillInStubs((XPathExpression)treeSourcePin);
            arrayList.add((XPathExpression)treeSourcePin);
            bl = true;
        }
        for (Vertex vertex : graphInfoCollector.getSecondryRoots()) {
            treeSourcePin = this.createXPathRecursive(xPathModel, vertex, set);
            if (treeSourcePin == null) continue;
            xPathModel.fillInStubs((XPathExpression)treeSourcePin);
            arrayList.add((XPathExpression)treeSourcePin);
        }
        XPathExprList xPathExprList = new XPathExprList(arrayList, bl);
        return xPathExprList;
    }

    protected void populateContentHolder(ContentElement contentElement, GraphInfoCollector graphInfoCollector, Set<AbstractTypeCast> set) {
        XPathModel xPathModel = BpelXPathModelFactory.create((BpelEntity)((BpelEntity)contentElement));
        XPathExprList xPathExprList = this.buildXPathExprList(xPathModel, graphInfoCollector, set);
        String string = xPathExprList.toString();
        try {
            if (string != null && string.length() != 0) {
                contentElement.setContent(string);
            } else {
                contentElement.setContent(null);
            }
        }
        catch (VetoException vetoException) {
            // empty catch block
        }
    }

    protected XPathExpression createVariableXPath(XPathModel xPathModel, TreePathInfo treePathInfo, Set<AbstractTypeCast> set) {
        if (treePathInfo == null || treePathInfo.varDecl == null) {
            return null;
        }
        XPathBpelVariable xPathBpelVariable = new XPathBpelVariable((AbstractVariableDeclaration)treePathInfo.varDecl, treePathInfo.part);
        QName qName = xPathBpelVariable.constructXPathName();
        XPathVariableReference xPathVariableReference = xPathModel.getFactory().newXPathVariableReference(qName);
        if (treePathInfo.schemaCompList.isEmpty()) {
            return xPathVariableReference;
        }
        List<LocationStep> list = this.constructLSteps(xPathModel, treePathInfo.schemaCompList, set);
        if (list != null && !list.isEmpty()) {
            XPathExpressionPath xPathExpressionPath = xPathModel.getFactory().newXPathExpressionPath((XPathExpression)xPathVariableReference, list.toArray(new LocationStep[list.size()]));
            return xPathExpressionPath;
        }
        return null;
    }

    protected List<LocationStep> constructLSteps(XPathModel xPathModel, List<Object> list, Set<AbstractTypeCast> set) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<LocationStep> arrayList = new ArrayList<LocationStep>();
        for (Object object : list) {
            SchemaComponent schemaComponent;
            Object object2;
            LocationStep locationStep = null;
            if (object instanceof SchemaComponent) {
                locationStep = this.constructLStep(xPathModel, (SchemaComponent)object, null);
            } else if (object instanceof AbstractPredicate) {
                object2 = (AbstractPredicate)object;
                schemaComponent = ((AbstractPredicate)object2).getPredicates();
                SchemaComponent schemaComponent2 = ((AbstractPredicate)object2).getSComponent();
                locationStep = this.constructLStep(xPathModel, schemaComponent2, (XPathPredicateExpression[])schemaComponent);
            } else if (object instanceof AbstractTypeCast) {
                object2 = (AbstractTypeCast)object;
                schemaComponent = ((AbstractTypeCast)object2).getSComponent();
                locationStep = this.constructLStep(xPathModel, schemaComponent, null);
                if (set != null) {
                    set.add((AbstractTypeCast)object2);
                }
            } else if (object instanceof LocationStep) {
                locationStep = (LocationStep)object;
            } else if (object instanceof AbstractTypeCast) {
                object2 = ((AbstractTypeCast)object).getSComponent();
                locationStep = this.constructLStep(xPathModel, (SchemaComponent)object2, null);
            }
            if (locationStep == null) continue;
            arrayList.add(locationStep);
        }
        return arrayList;
    }

    protected LocationStep constructLStep(XPathModel xPathModel, SchemaComponent schemaComponent, XPathPredicateExpression[] xPathPredicateExpressionArray) {
        if (!(schemaComponent instanceof Named)) {
            return null;
        }
        XPathAxis xPathAxis = null;
        xPathAxis = schemaComponent instanceof Attribute ? XPathAxis.ATTRIBUTE : XPathAxis.CHILD;
        StepNodeNameTest stepNodeNameTest = new StepNodeNameTest(xPathModel, schemaComponent);
        LocationStep locationStep = xPathModel.getFactory().newLocationStep(xPathAxis, (StepNodeTest)stepNodeNameTest, xPathPredicateExpressionArray);
        return locationStep;
    }

    protected TreePathInfo collectTreeInfo(TreePath treePath, Set<AbstractTypeCast> set) {
        List<Object> list = MapperSwingTreeModel.convertTreePath(treePath);
        TreePathInfo treePathInfo = new TreePathInfo();
        for (Object object : list) {
            this.processItem(object, treePathInfo, set);
        }
        return treePathInfo;
    }

    private void processItem(Object object, TreePathInfo treePathInfo, Set<AbstractTypeCast> set) {
        if (object instanceof SchemaComponent || object instanceof AbstractPredicate || object instanceof LocationStep) {
            treePathInfo.schemaCompList.add(object);
        } else if (object instanceof AbstractTypeCast) {
            AbstractTypeCast abstractTypeCast = (AbstractTypeCast)object;
            set.add(abstractTypeCast);
            Object object2 = abstractTypeCast.getCastedObject();
            this.processItem(object2, treePathInfo, set);
        } else if (object instanceof AbstractVariableDeclaration) {
            if (object instanceof VariableDeclarationScope) {
                return;
            }
            if (object instanceof VariableDeclarationWrapper) {
                treePathInfo.varDecl = ((VariableDeclarationWrapper)object).getDelegate();
            } else if (object instanceof VariableDeclaration) {
                treePathInfo.varDecl = (VariableDeclaration)object;
            }
        } else if (object instanceof Part) {
            treePathInfo.part = (Part)object;
        } else if (object instanceof PartnerLink) {
            treePathInfo.pLink = (PartnerLink)object;
        } else if (object instanceof Roles) {
            treePathInfo.roles = (Roles)object;
        }
    }

    protected XPathExpression createXPathRecursive(XPathModel xPathModel, Vertex vertex, Set<AbstractTypeCast> set) {
        XPathExpression xPathExpression = this.createXPath(xPathModel, vertex);
        if (xPathExpression instanceof XPathOperationOrFuntion) {
            Link link;
            Object object;
            VertexItem vertexItem;
            int n;
            int n2 = -1;
            for (n = 0; n < vertex.getItemCount(); ++n) {
                vertexItem = vertex.getItem(n);
                if (vertexItem.isHairline()) continue;
                object = vertexItem.getValue();
                if (object != null) {
                    n2 = n;
                    continue;
                }
                link = vertexItem.getIngoingLink();
                if (link == null) continue;
                n2 = n;
            }
            for (n = 0; n < vertex.getItemCount(); ++n) {
                Object object2;
                Object object3;
                vertexItem = vertex.getItem(n);
                if (vertexItem.isHairline()) continue;
                object = null;
                link = vertexItem.getIngoingLink();
                if (link == null) {
                    boolean bl = false;
                    object3 = vertexItem.getValue();
                    if (object3 != null) {
                        object2 = vertexItem.getDataObject();
                        assert (object2 instanceof ArgumentDescriptor);
                        XPathType xPathType = ((ArgumentDescriptor)object2).getArgumentType();
                        if (xPathType == XPathType.NUMBER_TYPE) {
                            if (object3 instanceof Number) {
                                object = xPathModel.getFactory().newXPathNumericLiteral((Number)object3);
                                bl = true;
                            }
                        } else if (xPathType == XPathType.STRING_TYPE) {
                            if (object3 instanceof String && ((String)object3).length() != 0) {
                                object = xPathModel.getFactory().newXPathStringLiteral((String)object3);
                                bl = true;
                            }
                        } else assert (false) : "Unsupported constant's type";
                    }
                    if (!bl) {
                        if (n >= n2) break;
                        object = new StubExtFunction(xPathModel);
                    }
                } else {
                    SourcePin sourcePin = link.getSource();
                    if (sourcePin instanceof Vertex) {
                        object3 = (Vertex)sourcePin;
                        object = this.createXPathRecursive(xPathModel, (Vertex)object3, set);
                    } else if (sourcePin instanceof TreeSourcePin) {
                        object3 = ((TreeSourcePin)sourcePin).getTreePath();
                        object2 = this.collectTreeInfo((TreePath)object3, set);
                        object = this.createVariableXPath(xPathModel, (TreePathInfo)object2, set);
                    }
                }
                if (object == null) continue;
                ((XPathOperationOrFuntion)xPathExpression).addChild((XPathExpression)object);
            }
        }
        return xPathExpression;
    }

    protected XPathExpression createXPath(XPathModel xPathModel, Vertex vertex) {
        Object object = vertex.getDataObject();
        XPathCoreOperation xPathCoreOperation = null;
        if (object instanceof CoreOperationType) {
            CoreOperationType coreOperationType = (CoreOperationType)object;
            xPathCoreOperation = xPathModel.getFactory().newXPathCoreOperation(coreOperationType);
        } else if (object instanceof CoreFunctionType) {
            CoreFunctionType coreFunctionType = (CoreFunctionType)object;
            xPathCoreOperation = xPathModel.getFactory().newXPathCoreFunction(coreFunctionType);
        } else if (object instanceof ExtFunctionMetadata) {
            BpelModel bpelModel;
            Process process;
            ExtFunctionMetadata extFunctionMetadata = (ExtFunctionMetadata)object;
            QName qName = (QName)extFunctionMetadata.getName();
            String string = qName.getNamespaceURI();
            if (string != null && string.length() != 0 && (process = (bpelModel = this.getDesignContext().getBpelModel()).getProcess()) != null) {
                ExNamespaceContext exNamespaceContext = process.getNamespaceContext();
                try {
                    exNamespaceContext.addNamespace(string);
                }
                catch (InvalidNamespaceException invalidNamespaceException) {
                    ErrorManager.getDefault().notify((Throwable)invalidNamespaceException);
                    return null;
                }
            }
            xPathCoreOperation = xPathModel.getFactory().newXPathExtensionFunction(qName);
        } else if (vertex instanceof Constant) {
            Constant constant = (Constant)vertex;
            VertexItem vertexItem = constant.getItem(0);
            String string = vertexItem.getText();
            if (object == XPathStringLiteral.class) {
                xPathCoreOperation = xPathModel.getFactory().newXPathStringLiteral(string);
            } else if (object == XPathNumericLiteral.class) {
                Number number;
                try {
                    number = Integer.valueOf(string);
                    xPathCoreOperation = xPathModel.getFactory().newXPathNumericLiteral(number);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (xPathCoreOperation == null) {
                    try {
                        number = Double.valueOf(string);
                        xPathCoreOperation = xPathModel.getFactory().newXPathNumericLiteral(number);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (xPathCoreOperation == null) {
                    try {
                        number = Float.valueOf(string);
                        xPathCoreOperation = xPathModel.getFactory().newXPathNumericLiteral(number);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        return xPathCoreOperation;
    }

    public void registerTypeCasts(ExtensibleElements extensibleElements, Collection<AbstractTypeCast> collection, boolean bl) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        CastManager castManager = CastManager.getCastManager(this.getMapperModel(), bl);
        if (castManager != null) {
            castManager.registerTypeCasts(extensibleElements, collection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XPathExprList {
        private ArrayList<XPathExpression> mExprList;
        private boolean mIsFirstConnected;

        public XPathExprList(ArrayList<XPathExpression> arrayList, boolean bl) {
            this.mExprList = arrayList;
            this.mIsFirstConnected = bl;
        }

        public XPathExpression getConnectedExpression() {
            if (!this.mIsFirstConnected) {
                return null;
            }
            return this.mExprList.get(0);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = this.mIsFirstConnected;
            for (XPathExpression xPathExpression : this.mExprList) {
                String string = xPathExpression.getExpressionString();
                if (string == null || string.length() == 0) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(";");
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
    }

    protected class TreePathInfo {
        public VariableDeclaration varDecl;
        public Part part;
        public ArrayList<Object> schemaCompList = new ArrayList();
        public PartnerLink pLink;
        public Roles roles;

        protected TreePathInfo() {
        }
    }
}

