/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.logging.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.bpel.mapper.logging.tree.AlertItem;
import org.netbeans.modules.bpel.mapper.logging.tree.LogItem;
import org.netbeans.modules.bpel.mapper.logging.tree.LoggingTreeItem;
import org.netbeans.modules.bpel.model.ext.logging.api.AlertLevel;
import org.netbeans.modules.bpel.model.ext.logging.api.Location;
import org.netbeans.modules.bpel.model.ext.logging.api.LogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogAlertType
extends Enum<LogAlertType> {
    public static final /* enum */ LogAlertType LOG = new LogAlertType();
    public static final /* enum */ LogAlertType ALERT = new LogAlertType();
    private Map<Location, List<LoggingTreeItem>> myChildren = new HashMap<Location, List<LoggingTreeItem>>();
    private static final /* synthetic */ LogAlertType[] $VALUES;

    public static final LogAlertType[] values() {
        return (LogAlertType[])$VALUES.clone();
    }

    public static LogAlertType valueOf(String string) {
        return Enum.valueOf(LogAlertType.class, string);
    }

    public List<LoggingTreeItem> getChildren(Location location) {
        assert (location != null);
        if (this.myChildren.get(location) == null) {
            List<Object> list = new ArrayList();
            switch (this) {
                case LOG: {
                    list = this.getLogLevelItems(location);
                    break;
                }
                case ALERT: {
                    list = this.getAlertLevelItems(location);
                }
            }
            this.myChildren.put(location, list);
        }
        return this.myChildren.get(location);
    }

    private List<LoggingTreeItem> getLogLevelItems(Location location) {
        LogLevel[] logLevelArray;
        ArrayList<LoggingTreeItem> arrayList = new ArrayList<LoggingTreeItem>();
        for (LogLevel logLevel : logLevelArray = LogLevel.values()) {
            if (LogLevel.INVALID.equals((Object)logLevel)) continue;
            arrayList.add(new LogItem(logLevel, location));
        }
        return arrayList;
    }

    private List<LoggingTreeItem> getAlertLevelItems(Location location) {
        AlertLevel[] alertLevelArray;
        ArrayList<LoggingTreeItem> arrayList = new ArrayList<LoggingTreeItem>();
        for (AlertLevel alertLevel : alertLevelArray = AlertLevel.values()) {
            if (AlertLevel.INVALID.equals((Object)alertLevel)) continue;
            arrayList.add(new AlertItem(alertLevel, location));
        }
        return arrayList;
    }

    static {
        $VALUES = new LogAlertType[]{LOG, ALERT};
    }
}

