/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.logging.multiview;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContextImpl;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextFactory;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.CatchAll;
import org.netbeans.modules.bpel.model.api.Compensate;
import org.netbeans.modules.bpel.model.api.CompensateScope;
import org.netbeans.modules.bpel.model.api.Empty;
import org.netbeans.modules.bpel.model.api.Exit;
import org.netbeans.modules.bpel.model.api.ExtensibleElements;
import org.netbeans.modules.bpel.model.api.Flow;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.Pick;
import org.netbeans.modules.bpel.model.api.ReThrow;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.RepeatUntil;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.Sequence;
import org.netbeans.modules.bpel.model.api.Throw;
import org.netbeans.modules.bpel.model.api.Validate;
import org.netbeans.modules.bpel.model.api.Wait;
import org.netbeans.modules.bpel.model.api.While;
import org.netbeans.modules.bpel.model.ext.logging.api.Alert;
import org.netbeans.modules.bpel.model.ext.logging.api.Log;
import org.netbeans.modules.bpel.model.ext.logging.api.Trace;
import org.netbeans.modules.soa.ui.nodes.InstanceRef;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class LoggingDesignContextFactory
implements DesignContextFactory {
    private static final LoggingDesignContextFactory INSTANCE = new LoggingDesignContextFactory();
    private final DesignContextFactory.ContextCreator[] contextCreators = new DesignContextFactory.ContextCreator[]{new LoggingContextCreatorImpl(), new DesignContextFactory.EmptyContextCreator()};
    private static Set<Class<? extends ExtensibleElements>> sSupportedParents = new HashSet<Class>(Arrays.asList(Catch.class, CatchAll.class, Assign.class, Compensate.class, CompensateScope.class, Empty.class, Exit.class, Flow.class, ForEach.class, If.class, Invoke.class, Pick.class, Receive.class, RepeatUntil.class, Reply.class, ReThrow.class, Scope.class, Sequence.class, Throw.class, Validate.class, Wait.class, While.class));

    private LoggingDesignContextFactory() {
    }

    public static LoggingDesignContextFactory getInstance() {
        return INSTANCE;
    }

    public BpelDesignContext createBpelDesignContext(BpelEntity bpelEntity, Node node, Lookup lookup) {
        if (bpelEntity == null || node == null || lookup == null) {
            return null;
        }
        BpelDesignContext bpelDesignContext = null;
        assert (this.contextCreators != null);
        for (DesignContextFactory.ContextCreator contextCreator : this.contextCreators) {
            if (!contextCreator.accepted(bpelEntity)) continue;
            bpelDesignContext = contextCreator.create(bpelEntity, node, lookup);
            break;
        }
        return bpelDesignContext;
    }

    public BpelDesignContext getActivatedContext(BpelModel bpelModel) {
        Object object;
        if (bpelModel == null) {
            return null;
        }
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        BpelEntity bpelEntity = null;
        if (nodeArray[0] instanceof InstanceRef) {
            object = ((InstanceRef)nodeArray[0]).getReference();
            if (object instanceof BpelEntity && bpelModel.equals(((BpelEntity)object).getBpelModel())) {
                bpelEntity = (BpelEntity)object;
            }
        } else {
            return null;
        }
        object = nodeArray[0].getLookup();
        BpelDesignContext bpelDesignContext = this.createBpelDesignContext(bpelEntity, nodeArray[0], (Lookup)object);
        return bpelDesignContext;
    }

    public static boolean canExtend(ExtensibleElements extensibleElements) {
        return sSupportedParents.contains(extensibleElements.getElementType());
    }

    private class LoggingContextCreatorImpl
    implements DesignContextFactory.ContextCreator {
        private LoggingContextCreatorImpl() {
        }

        public boolean accepted(BpelEntity bpelEntity) {
            if (bpelEntity == null) {
                return false;
            }
            boolean bl = false;
            Class clazz = bpelEntity.getElementType();
            if (clazz == From.class) {
                BpelContainer bpelContainer = bpelEntity.getParent();
                Class clazz2 = bpelContainer != null ? bpelContainer.getElementType() : null;
                bl = clazz2 == Log.class || clazz2 == Alert.class;
            } else if (bpelEntity instanceof ExtensibleElements) {
                bl = LoggingDesignContextFactory.canExtend((ExtensibleElements)bpelEntity);
            }
            if (!bl) {
                bl = clazz == Trace.class || clazz == Log.class || clazz == Alert.class;
            }
            return bl;
        }

        public BpelDesignContext create(BpelEntity bpelEntity, Node node, Lookup lookup) {
            if (!this.accepted(bpelEntity)) {
                return null;
            }
            BpelDesignContextImpl bpelDesignContextImpl = null;
            Class clazz = bpelEntity.getElementType();
            if (clazz == From.class) {
                BpelContainer bpelContainer = bpelEntity.getParent();
                if (bpelContainer != null) {
                    BpelContainer bpelContainer2 = bpelContainer.getParent();
                    BpelContainer bpelContainer3 = bpelContainer2 = bpelContainer2 != null ? bpelContainer2.getParent() : null;
                    if (bpelContainer2 != null) {
                        bpelDesignContextImpl = new BpelDesignContextImpl((BpelEntity)bpelContainer2, (BpelEntity)bpelContainer, bpelEntity, node, lookup);
                    }
                }
            } else if (clazz == Trace.class) {
                BpelContainer bpelContainer = bpelEntity.getParent();
                if (bpelContainer != null && bpelContainer instanceof ExtensibleElements) {
                    bpelDesignContextImpl = new BpelDesignContextImpl((BpelEntity)bpelContainer, null, bpelEntity, node, lookup);
                }
            } else if (clazz == Log.class || clazz == Alert.class) {
                BpelContainer bpelContainer;
                BpelContainer bpelContainer4 = bpelEntity.getParent();
                if (bpelContainer4 != null && bpelContainer4.getElementType() == Trace.class && (bpelContainer = bpelContainer4.getParent()) instanceof ExtensibleElements) {
                    bpelDesignContextImpl = new BpelDesignContextImpl((BpelEntity)bpelContainer, bpelEntity, bpelEntity, node, lookup);
                }
            } else {
                bpelDesignContextImpl = new BpelDesignContextImpl(bpelEntity, null, bpelEntity, node, lookup);
            }
            return bpelDesignContextImpl;
        }
    }
}

