/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.logging.multiview;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.editors.api.utils.Util;
import org.netbeans.modules.bpel.mapper.logging.model.LoggingMapperModelFactory;
import org.netbeans.modules.bpel.mapper.logging.multiview.LoggingDesignContextFactory;
import org.netbeans.modules.bpel.mapper.model.GraphExpandProcessor;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.multiview.BpelModelSynchListener;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextController;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextUtil;
import org.netbeans.modules.bpel.mapper.multiview.MapperMultiviewElement;
import org.netbeans.modules.bpel.mapper.multiview.MapperStateManager;
import org.netbeans.modules.bpel.mapper.multiview.ShowMapperCookie;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTcContext;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class DesignContextControllerImpl2
implements DesignContextController,
PropertyChangeListener {
    private BpelDesignContext mContext;
    private MapperTcContext mMapperTcContext;
    private BpelModelSynchListener mBpelModelSynchListener;
    private BpelModel myBpelModel;
    private boolean isMapperShown;
    private BpelDesignContext mNewContext;
    private MapperStateManager myMapperStateManager;
    private static final int ACTION_NODE_CHANGE_TASK_DELAY = 150;
    private transient RequestProcessor.Task myPreviousTask;
    private int myDelay = 150;
    private WeakReference<Object> mBpelModelUpdateSourceRef;

    public DesignContextControllerImpl2(TopComponent topComponent) {
        assert (topComponent != null);
        assert (topComponent instanceof MapperTcContext);
        this.mMapperTcContext = (MapperTcContext)topComponent;
        this.myBpelModel = (BpelModel)topComponent.getLookup().lookup(BpelModel.class);
        assert (this.myBpelModel != null);
        this.mBpelModelSynchListener = new BpelModelSynchListener(this);
        this.mBpelModelSynchListener.register(this.myBpelModel);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.initContext();
    }

    public void cleanup() {
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        this.mBpelModelSynchListener.unregisterAll();
        this.myBpelModel = null;
        this.mMapperTcContext = null;
    }

    public synchronized void setBpelModelUpdateSource(Object object) {
        this.mBpelModelUpdateSourceRef = new WeakReference<Object>(object);
    }

    public synchronized BpelDesignContext getContext() {
        return this.mContext;
    }

    public synchronized void setContext(BpelDesignContext bpelDesignContext) {
        assert (EventQueue.isDispatchThread());
        this.setContext(bpelDesignContext, false);
    }

    public synchronized void setContext(BpelDesignContext bpelDesignContext, boolean bl) {
        assert (EventQueue.isDispatchThread());
        if (this.mNewContext == null && bl) {
            this.reloadMapper(new EventObject(new Object()));
            return;
        }
        this.mNewContext = bpelDesignContext;
        boolean bl2 = DesignContextUtil.isValidContext(this.mContext);
        if (bpelDesignContext == null && bl2) {
            return;
        }
        if (bpelDesignContext == null && !bl2) {
            if (this.isMapperShown) {
                this.showNotValidContext(this.mContext);
            }
            return;
        }
        BpelEntity bpelEntity = bpelDesignContext.getSelectedEntity();
        if (bpelEntity != null && !this.myBpelModel.equals(bpelEntity.getBpelModel()) || bpelEntity == null) {
            return;
        }
        if (bpelDesignContext.equals(this.mContext) && !bl) {
            return;
        }
        this.setActivatedNodes(bpelDesignContext == null ? null : bpelDesignContext.getActivatedNode());
        if (this.isMapperShown) {
            this.setContextImpl(bl);
        }
    }

    public void reloadMapper(EventObject eventObject) {
        if (eventObject.getSource() == this.getBpelModelUpdateSource()) {
            return;
        }
        if (this.myPreviousTask != null) {
            this.myPreviousTask.cancel();
        }
        if (this.myPreviousTask != null && !this.myPreviousTask.isFinished() && RequestProcessor.getDefault().isRequestProcessorThread()) {
            this.myPreviousTask.waitFinished();
            this.myPreviousTask = null;
        }
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DesignContextControllerImpl2.this.performReloadMapperInAwt();
                }
            });
        } else {
            this.performReloadMapperInAwt();
        }
    }

    synchronized void performReloadMapperInAwt() {
        assert (EventQueue.isDispatchThread());
        if (!DesignContextUtil.isValidContext(this.mContext)) {
            this.setDelay(0);
            this.updateContext(-1, false);
            return;
        }
        if (this.isMapperShown) {
            this.reloadMapperImpl();
        }
    }

    private void setDelay(int n) {
        this.myDelay = n;
    }

    private int getDelay() {
        return this.myDelay;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (!string.equals("activatedNodes")) {
            return;
        }
        this.updateContext();
    }

    public void showMapper() {
        Mapper mapper;
        assert (EventQueue.isDispatchThread());
        this.isMapperShown = true;
        Mapper mapper2 = mapper = this.mMapperTcContext != null ? this.mMapperTcContext.getMapper() : null;
        if (mapper != null) {
            mapper.setVisible(true);
        }
        this.updateContext(-1, true);
    }

    public void hideMapper() {
        Mapper mapper;
        assert (EventQueue.isDispatchThread());
        this.isMapperShown = false;
        Mapper mapper2 = mapper = this.mMapperTcContext != null ? this.mMapperTcContext.getMapper() : null;
        if (mapper != null) {
            mapper.setVisible(false);
        }
    }

    public MapperTcContext getMapperTcContext() {
        return this.mMapperTcContext;
    }

    private synchronized void initContext() {
        this.setContext(LoggingDesignContextFactory.getInstance().getActivatedContext(this.myBpelModel));
        this.myMapperStateManager = new MapperStateManager(this.mMapperTcContext);
    }

    private void updateContext(int n, boolean bl) {
        assert (EventQueue.isDispatchThread());
        if (n <= 0) {
            this.setDelay(150);
        }
        if (this.myPreviousTask != null) {
            this.myPreviousTask.cancel();
        }
        if (this.myPreviousTask != null && !this.myPreviousTask.isFinished() && RequestProcessor.getDefault().isRequestProcessorThread()) {
            this.myPreviousTask.waitFinished();
            this.myPreviousTask = null;
        }
        if (n <= 0) {
            this.setContext(LoggingDesignContextFactory.getInstance().getActivatedContext(this.myBpelModel), bl);
        } else {
            this.myPreviousTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DesignContextControllerImpl2.this.setContext(LoggingDesignContextFactory.getInstance().getActivatedContext(DesignContextControllerImpl2.this.myBpelModel));
                        }
                    });
                }
            }, n);
        }
    }

    private void updateContext() {
        this.updateContext(this.getDelay(), false);
    }

    private void setContextImpl() {
        this.setContextImpl(false);
    }

    private void setContextImpl(boolean bl) {
        BpelDesignContext bpelDesignContext = this.mNewContext;
        if (bpelDesignContext == null) {
            return;
        }
        if (this.isModelInvalid()) {
            this.myMapperStateManager.storeOldEntityContext(this.mContext);
            this.showModelIsInvalid();
            return;
        }
        BpelEntity bpelEntity = this.mContext != null ? this.mContext.getContextEntity() : null;
        BpelEntity bpelEntity2 = bpelDesignContext.getContextEntity();
        if (bpelEntity2 == null) {
            this.myMapperStateManager.storeOldEntityContext(this.mContext);
            this.showUnsupportedEntity(bpelDesignContext);
            return;
        }
        if (bl || !bpelDesignContext.equals(this.mContext)) {
            if (bl || !bpelEntity2.equals(bpelEntity)) {
                this.myMapperStateManager.storeOldEntityContext(this.mContext);
                MapperModel mapperModel = new LoggingMapperModelFactory(this.mMapperTcContext, bpelDesignContext).constructModel();
                this.mContext = bpelDesignContext;
                this.setMapperModel(mapperModel);
                this.myMapperStateManager.restoreOldEntityContext(this.mContext);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GraphExpandProcessor.expandGraph(DesignContextControllerImpl2.this.mMapperTcContext, DesignContextControllerImpl2.this.mContext);
                }
            });
        }
    }

    private void reloadMapperImpl() {
        if (this.mContext == null) {
            return;
        }
        if (this.isModelInvalid()) {
            this.myMapperStateManager.storeOldEntityContext(this.mContext);
            this.showModelIsInvalid();
            return;
        }
        MapperModel mapperModel = new LoggingMapperModelFactory(this.mMapperTcContext, this.mContext).constructModel();
        this.myMapperStateManager.storeOldEntityContext(this.mContext);
        this.setMapperModel(mapperModel);
        this.myMapperStateManager.restoreOldEntityContext(this.mContext);
    }

    private synchronized Object getBpelModelUpdateSource() {
        if (this.mBpelModelUpdateSourceRef == null) {
            return this.mMapperTcContext.getMapper();
        }
        return this.mBpelModelUpdateSourceRef.get();
    }

    private void setActivatedNodes(Node node) {
        TopComponent topComponent;
        assert (EventQueue.isDispatchThread());
        if (this.mMapperTcContext != null && (topComponent = this.mMapperTcContext.getTopComponent()) != null) {
            if (node != null) {
                topComponent.setActivatedNodes(new Node[]{node});
            } else {
                topComponent.setActivatedNodes(new Node[0]);
            }
        }
    }

    private void setMapperModel(MapperModel mapperModel) {
        assert (mapperModel != null);
        this.mMapperTcContext.setMapperModel(mapperModel);
    }

    private void showModelIsInvalid() {
        this.disableMapper(NbBundle.getMessage(MapperMultiviewElement.class, (String)"LBL_LoggingInvalid_BpelModel"));
    }

    private void showUnsupportedEntity(BpelDesignContext bpelDesignContext) {
        assert (bpelDesignContext != null);
        String string = null;
        Node node = bpelDesignContext.getActivatedNode();
        String string2 = string = node != null ? node.getDisplayName() : null;
        if (string == null) {
            BpelEntity bpelEntity = bpelDesignContext.getSelectedEntity();
            string = bpelEntity instanceof Nameable ? ((Nameable)bpelEntity).getName() : Util.getTagName((DocumentComponent)bpelEntity);
        }
        string = string == null ? "" : string;
        this.disableMapper(NbBundle.getMessage(MapperMultiviewElement.class, (String)"LBL_LoggingEmptyMapper", (Object)string));
    }

    private void showNotValidContext(BpelDesignContext bpelDesignContext) {
        assert (bpelDesignContext != null);
        String string = null;
        Node node = bpelDesignContext.getActivatedNode();
        String string2 = string = node != null ? node.getDisplayName() : null;
        if (string == null) {
            BpelEntity bpelEntity = bpelDesignContext.getSelectedEntity();
            string = bpelEntity instanceof Nameable ? ((Nameable)bpelEntity).getName() : Util.getTagName((DocumentComponent)bpelEntity);
        }
        string = string == null ? "" : string;
        this.disableMapper(NbBundle.getMessage(MapperMultiviewElement.class, (String)"LBL_LoggingInValidMapperContext", (Object)string));
    }

    private void disableMapper(String string) {
        TopComponent topComponent = this.mMapperTcContext.getTopComponent();
        if (topComponent == null) {
            return;
        }
        ShowMapperCookie showMapperCookie = (ShowMapperCookie)topComponent.getLookup().lookup(ShowMapperCookie.class);
        if (showMapperCookie != null) {
            showMapperCookie.show(string);
        }
        this.mContext = null;
    }

    private boolean isModelInvalid() {
        BpelModel bpelModel = this.myBpelModel;
        if (bpelModel != null) {
            return bpelModel.getState().equals((Object)Model.State.NOT_WELL_FORMED);
        }
        return false;
    }

    public void processDataObject(Object object) {
        this.mBpelModelSynchListener.processDataObject(object);
    }
}

