/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.netbeans.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.reverseengineering.reintegration.ReverseEngineerTask;
import org.netbeans.modules.uml.core.support.umlsupport.IStrings;
import org.netbeans.modules.uml.core.support.umlsupport.Strings;
import org.netbeans.modules.uml.integration.netbeans.actions.ui.ReverseEngineerDescriptor;
import org.netbeans.modules.uml.integration.netbeans.actions.ui.ReverseEngineerPanel;
import org.netbeans.modules.uml.project.ProjectUtil;
import org.netbeans.modules.uml.project.UMLProject;
import org.netbeans.modules.uml.project.UMLProjectGenerator;
import org.netbeans.modules.uml.project.UMLProjectHelper;
import org.netbeans.modules.uml.project.ui.common.JavaSourceRootsUI;
import org.netbeans.modules.uml.project.ui.java.UMLJavaAssociationUtil;
import org.netbeans.modules.uml.project.ui.nodes.ModelRootNodeCookie;
import org.netbeans.modules.uml.project.ui.nodes.UMLPhysicalViewProvider;
import org.netbeans.modules.uml.util.ITaskFinishListener;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.cookies.SaveCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReverseEngineerAction
extends AbstractAction
implements ContextAwareAction,
ITaskFinishListener {
    ArrayList<String> sourceFiles;
    WeakReference<Project> sourceProjectRef = null;
    boolean projectSelected = false;
    IProject umlIProject;

    public ReverseEngineerAction() {
        this.putValue("Name", this.getName());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAction(lookup);
    }

    private boolean enable(Lookup lookup) {
        this.projectSelected = false;
        this.sourceProjectRef = null;
        Project project = null;
        Collection collection = lookup.lookupAll(Project.class);
        if (collection.size() > 1) {
            return false;
        }
        if (collection.size() == 1) {
            this.projectSelected = true;
            project = (Project)collection.toArray()[0];
            if (!this.hasSourceGroups(project)) {
                return false;
            }
            project = (Project)collection.toArray()[0];
        }
        for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
            SourceGroup[] sourceGroupArray;
            if (project == null && (project = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile())) == null) {
                return false;
            }
            if (project != FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile())) {
                return false;
            }
            if (this.projectSelected && project != null) {
                this.sourceProjectRef = new WeakReference<Project>(project);
                return true;
            }
            Sources sources = (Sources)project.getLookup().lookup(Sources.class);
            if (sources == null) {
                return false;
            }
            boolean bl = false;
            for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("java")) {
                FileObject fileObject;
                FileObject fileObject2 = sourceGroup.getRootFolder();
                if (!FileUtil.isParentOf((FileObject)fileObject2, (FileObject)(fileObject = dataObject.getPrimaryFile())) && fileObject2 != fileObject || !fileObject.isFolder() && (!fileObject.isData() || !"java".equals(fileObject.getExt()))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        if (project == null) {
            return false;
        }
        this.sourceProjectRef = new WeakReference<Project>(project);
        return true;
    }

    private void perform(Project project, boolean bl, Lookup lookup) {
        ReverseEngineerPanel reverseEngineerPanel;
        assert (project != null);
        if (bl) {
            reverseEngineerPanel = new ReverseEngineerPanel(project, UMLJavaAssociationUtil.getAssociatedUMLProject((Project)project));
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
                arrayList.add(dataObject.getPrimaryFile().getName());
            }
            reverseEngineerPanel = new ReverseEngineerPanel(project, arrayList, UMLJavaAssociationUtil.getAssociatedUMLProject((Project)project));
        }
        boolean bl2 = this.displayDialogDescriptor(reverseEngineerPanel);
        if (bl2) {
            this.saveSourceFiles(project);
            this.sourceFiles = bl ? this.findJavaFiles(reverseEngineerPanel) : this.findJavaFiles(lookup);
            this.doReverseEngineer(reverseEngineerPanel);
        }
    }

    private void saveSourceFiles(Project project) {
        try {
            DataObject[] dataObjectArray = DataObject.getRegistry().getModified();
            for (int i = 0; i < dataObjectArray.length; ++i) {
                SaveCookie saveCookie;
                if (FileOwnerQuery.getOwner((FileObject)dataObjectArray[i].getPrimaryFile()) != project || (saveCookie = (SaveCookie)dataObjectArray[i].getCookie(SaveCookie.class)) == null) continue;
                saveCookie.save();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private boolean displayDialogDescriptor(ReverseEngineerPanel reverseEngineerPanel) {
        ReverseEngineerDescriptor reverseEngineerDescriptor = new ReverseEngineerDescriptor(reverseEngineerPanel, NbBundle.getMessage(ReverseEngineerAction.class, (String)"LBL_ReverseEngineerDialog_Title"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx("uml_reverse_eng_reverse_eng_dialog_box"), reverseEngineerPanel);
        reverseEngineerPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReverseEngineerAction.class, (String)"ACSN_RevEngDialog"));
        reverseEngineerPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReverseEngineerAction.class, (String)"ACSD_RevEngDialog"));
        reverseEngineerPanel.requestFocus();
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)reverseEngineerDescriptor) == NotifyDescriptor.OK_OPTION;
    }

    private String getLocalizedMessage(String string) {
        return NbBundle.getMessage(ReverseEngineerAction.class, (String)string);
    }

    public String getName() {
        String string = this.getLocalizedMessage("CTL_ReverseEngineerAction");
        this.putValue("Name", string);
        return string;
    }

    private void doReverseEngineer(ReverseEngineerPanel reverseEngineerPanel) {
        if (reverseEngineerPanel.isCreateNewProject()) {
            this.reverseEngineerIntoNewProject(reverseEngineerPanel);
        } else {
            this.reverseEngineerIntoExistingProject(reverseEngineerPanel);
        }
    }

    private void reverseEngineerIntoNewProject(final ReverseEngineerPanel reverseEngineerPanel) {
        Thread thread = new Thread(){

            public void run() {
                File file = ReverseEngineerAction.this.createNewUMLProject(reverseEngineerPanel);
                ReverseEngineerAction.this.openUMLProject(file);
            }
        };
        SwingUtilities.invokeLater(thread);
    }

    private void reverseEngineerIntoExistingProject(final ReverseEngineerPanel reverseEngineerPanel) {
        Thread thread = new Thread(){

            public void run() {
                ReverseEngineerAction.this.useExistingUMLProject((UMLProject)reverseEngineerPanel.getUMLProject());
            }
        };
        SwingUtilities.invokeLater(thread);
    }

    private File createNewUMLProject(ReverseEngineerPanel reverseEngineerPanel) {
        try {
            JavaSourceRootsUI.JavaSourceRootsModel javaSourceRootsModel = null;
            ArrayList<String> arrayList = this.sourceFiles;
            if (reverseEngineerPanel.isShowSourceRoots()) {
                arrayList = null;
                javaSourceRootsModel = reverseEngineerPanel.getSourceRoots();
            }
            AntProjectHelper antProjectHelper = UMLProjectGenerator.createRevEngProject((File)new File(reverseEngineerPanel.getProjectFolder()), (String)reverseEngineerPanel.getProjectName(), (Project)reverseEngineerPanel.getJavaProject(), (JavaSourceRootsUI.JavaSourceRootsModel)javaSourceRootsModel, this.sourceFiles, (int)2);
            return FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private void useExistingUMLProject(UMLProject uMLProject) {
        Strings strings = new Strings();
        Iterator<String> iterator = this.sourceFiles.iterator();
        UMLProjectHelper uMLProjectHelper = (UMLProjectHelper)uMLProject.getLookup().lookup(UMLProjectHelper.class);
        this.umlIProject = uMLProjectHelper.getProject();
        while (iterator.hasNext()) {
            strings.add(iterator.next().toString());
        }
        this.reverseEngineerIntoExistingUMLProject(this.umlIProject, (IStrings)strings);
    }

    private void reverseEngineerIntoExistingUMLProject(IProject iProject, IStrings iStrings) {
        ReverseEngineerTask reverseEngineerTask = new ReverseEngineerTask((INamespace)iProject, iStrings, false, false, true, true, (ITaskFinishListener)this);
        RequestProcessor requestProcessor = new RequestProcessor("uml/ReverseEngineer");
        requestProcessor.post((Runnable)reverseEngineerTask);
    }

    public void taskFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Project project = ProjectUtil.findNetBeansProjectForModel((IProject)ReverseEngineerAction.this.umlIProject);
                UMLPhysicalViewProvider uMLPhysicalViewProvider = (UMLPhysicalViewProvider)project.getLookup().lookup(UMLPhysicalViewProvider.class);
                ModelRootNodeCookie modelRootNodeCookie = uMLPhysicalViewProvider.getModelRootNodeCookie();
                if (modelRootNodeCookie != null) {
                    modelRootNodeCookie.recalculateChildren();
                }
            }
        });
    }

    private boolean hasSourceGroups(Project project) {
        SourceGroup[] sourceGroupArray;
        if (project == null) {
            throw new IllegalArgumentException("Parameter \"project\" cannot be null.");
        }
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        return sources != null && (sourceGroupArray = sources.getSourceGroups("java")) != null && sourceGroupArray.length > 0;
    }

    private void openUMLProject(File file) {
        final File file2 = file;
        if (file2 == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    File file = file2;
                    synchronized (file) {
                        FileObject fileObject = FileUtil.toFileObject((File)file2);
                        final Project project = ProjectManager.getDefault().findProject(fileObject);
                        if (project instanceof UMLProject) {
                            OpenProjects.getDefault().open(new Project[]{project}, false);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    TopComponent topComponent = WindowManager.getDefault().findTopComponent("projectTabLogical_tc");
                                    if (topComponent == null) {
                                        return;
                                    }
                                    ExplorerManager explorerManager = ((ExplorerManager.Provider)topComponent).getExplorerManager();
                                    Node node = explorerManager.getRootContext();
                                    Node node2 = node.getChildren().findChild(ProjectUtils.getInformation((Project)project).getName());
                                    if (node2 != null) {
                                        try {
                                            explorerManager.setSelectedNodes(new Node[]{node2});
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        });
    }

    protected ArrayList<String> findJavaFiles(Lookup lookup) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
            if (dataObject == null) continue;
            this.findJavaFiles(dataObject, hashSet, arrayList);
        }
        return arrayList;
    }

    protected ArrayList<String> findJavaFiles(ReverseEngineerPanel reverseEngineerPanel) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (reverseEngineerPanel.isShowSourceRoots()) {
            JavaSourceRootsUI.JavaSourceRootsModel javaSourceRootsModel = reverseEngineerPanel.getSourceRoots();
            for (int i = 0; i < javaSourceRootsModel.getRowCount(); ++i) {
                boolean bl = (Boolean)javaSourceRootsModel.getValueAt(i, 0);
                if (!bl) continue;
                SourceGroup sourceGroup = javaSourceRootsModel.getSourceGroup(i);
                FileObject fileObject = sourceGroup.getRootFolder();
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    if (dataObject == null) continue;
                    this.findJavaFiles(dataObject, hashSet, arrayList);
                    continue;
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().log(exception.getMessage());
                }
            }
        }
        return arrayList;
    }

    protected void findJavaFiles(DataObject dataObject, HashSet<String> hashSet, ArrayList<String> arrayList) {
        if (dataObject instanceof DataFolder) {
            DataFolder dataFolder = (DataFolder)dataObject;
            DataObject[] dataObjectArray = dataFolder.getChildren();
            for (int i = 0; i < dataObjectArray.length; ++i) {
                this.findJavaFiles(dataObjectArray[i], hashSet, arrayList);
            }
        } else {
            String string;
            String string2;
            FileObject fileObject = dataObject.getPrimaryFile();
            if (ReverseEngineerAction.isJavaFile(fileObject) && !hashSet.contains(string2 = (string = FileUtil.toFile((FileObject)fileObject).toString()).toLowerCase())) {
                hashSet.add(string2);
                arrayList.add(string);
            }
        }
    }

    public static boolean isJavaFile(FileObject fileObject) {
        return fileObject != null && fileObject.isValid() && fileObject.isData() && fileObject.getExt().equals("java");
    }

    private final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private Lookup context;
        private boolean isEnabled = false;

        public ContextAction(Lookup lookup) {
            this.context = lookup;
            this.isEnabled = ReverseEngineerAction.this.enable(lookup);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ReverseEngineerAction.this.sourceProjectRef != null) {
                ReverseEngineerAction.this.perform((Project)ReverseEngineerAction.this.sourceProjectRef.get(), ReverseEngineerAction.this.projectSelected, this.context);
            }
        }

        public JMenuItem getPopupPresenter() {
            class Presenter
            extends JMenuItem
            implements DynamicMenuContent {
                public Presenter() {
                    super(ContextAction.this);
                }

                public JComponent[] getMenuPresenters() {
                    if (ContextAction.this.isEnabled) {
                        Mnemonics.setLocalizedText((AbstractButton)this, (String)ReverseEngineerAction.this.getName());
                        return new JComponent[]{this};
                    }
                    return new JComponent[0];
                }

                public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
                    return this.getMenuPresenters();
                }
            }
            return new Presenter();
        }
    }
}

