/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.netbeans;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.integration.ide.events.ClassInfo;
import org.netbeans.modules.uml.integration.ide.events.MemberInfo;
import org.netbeans.modules.uml.integration.ide.events.MethodInfo;
import org.netbeans.modules.uml.integration.ide.events.MethodParameterInfo;
import org.netbeans.modules.uml.integration.netbeans.ElementAndFile;
import org.netbeans.modules.uml.integration.netbeans.NBFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NBUtils {
    public static final int ERROR_NOSPAM_TIME = 1500;
    private static Frame retFrame;
    private static ResourceBundle bundle;
    public static final String EDITOR_MODE_ID;
    public static final String NETBEANS_PREFIX = "NB:";
    private static String lastError;
    private static long lastErrorTime;
    private static final NBFileUtils fileUtils;
    private static final String CAPTURED_WILDCARD = "<captured wildcard>";
    private static final String ERROR = "<error>";
    private static final String UNKNOWN = "<unknown>";

    public static Frame getMainFrame() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    retFrame = WindowManager.getDefault().getMainWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return retFrame;
    }

    public static boolean isUIBusy() {
        int n;
        Frame frame = NBUtils.getMainFrame();
        if (frame == null || !frame.isVisible()) {
            return true;
        }
        Window[] windowArray = frame.getOwnedWindows();
        if (windowArray == null || windowArray.length == 0) {
            return false;
        }
        for (n = 0; n < windowArray.length; ++n) {
            if (!windowArray[n].isShowing() || !(windowArray[n] instanceof Dialog)) continue;
            return true;
        }
        Log.out((String)"Open windows are :");
        for (n = 0; n < windowArray.length; ++n) {
            Log.out((String)(n + ") " + windowArray[n].getClass().getName()));
        }
        return false;
    }

    public static TopComponent getComponent(Mode mode, Class clazz) {
        if (mode == null || clazz == null) {
            return null;
        }
        TopComponent[] topComponentArray = mode.getTopComponents();
        for (int i = 0; i < topComponentArray.length; ++i) {
            if (!topComponentArray[i].getClass().equals(clazz)) continue;
            return topComponentArray[i];
        }
        return null;
    }

    public static TopComponent getComponent(Mode mode, String string) {
        if (mode == null || string == null) {
            return null;
        }
        TopComponent[] topComponentArray = mode.getTopComponents();
        for (int i = 0; i < topComponentArray.length; ++i) {
            if (!topComponentArray[i].getClass().getName().equals(string)) continue;
            return topComponentArray[i];
        }
        return null;
    }

    public static TopComponent getComponent(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Set set = WindowManager.getDefault().getModes();
        for (Object e : set) {
            Mode mode;
            TopComponent topComponent;
            if (!(e instanceof Mode) || (topComponent = NBUtils.getComponent(mode = (Mode)e, clazz)) == null) continue;
            return topComponent;
        }
        return null;
    }

    public static TopComponent getComponent(String string) {
        if (string == null) {
            return null;
        }
        Set set = WindowManager.getDefault().getModes();
        for (Object e : set) {
            Mode mode;
            TopComponent topComponent;
            if (!(e instanceof Mode) || (topComponent = NBUtils.getComponent(mode = (Mode)e, string)) == null) continue;
            return topComponent;
        }
        return null;
    }

    public static Mode getMode(String string) {
        try {
            Mode mode = WindowManager.getDefault().findMode(string);
            return mode;
        }
        catch (Exception exception) {
            Log.stackTrace((Throwable)exception);
            return null;
        }
    }

    public static void dumpMode(Mode mode) {
        TopComponent[] topComponentArray = mode.getTopComponents();
        Log.out((String)("Dumping mode " + mode));
        if (topComponentArray != null) {
            for (int i = 0; i < topComponentArray.length; ++i) {
                Log.out((String)("         " + i + ") " + topComponentArray[i].getName() + " (" + topComponentArray[i].getClass().getName() + ")"));
            }
        }
    }

    public static void installActions(DataFolder dataFolder, Class[] classArray) {
        if (dataFolder == null || classArray == null) {
            return;
        }
        InstanceDataObject[] instanceDataObjectArray = new InstanceDataObject[classArray.length];
        try {
            for (int i = 0; i < instanceDataObjectArray.length; ++i) {
                instanceDataObjectArray[i] = NBUtils.createAction(classArray[i], dataFolder, i);
            }
            dataFolder.setOrder((DataObject[])instanceDataObjectArray);
        }
        catch (IOException iOException) {
            Log.stackTrace((Throwable)iOException);
        }
    }

    public static InstanceDataObject createAction(Class clazz, DataFolder dataFolder, int n) throws IOException {
        String string;
        String string2 = string = clazz.getName();
        if (clazz == JToolBar.Separator.class) {
            string2 = string2 + n;
        }
        return InstanceDataObject.create((DataFolder)dataFolder, (String)string2, (String)string);
    }

    public static void showErrCode(String string, Object[] objectArray, String string2, boolean bl) {
        String string3 = bundle.getString(string);
        if (objectArray != null) {
            string3 = MessageFormat.format(string3, objectArray);
        }
        if (string2 == null) {
            string2 = "Errors.title";
        }
        if (bl) {
            long l = lastErrorTime;
            lastErrorTime = System.currentTimeMillis();
            if (lastError != null && lastError.equals(string3) && lastErrorTime - l < 1500L) {
                return;
            }
            lastError = string3;
        }
        final String string4 = string2;
        final String string5 = string3;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(NBUtils.getMainFrame(), string5, bundle.getString(string4), 0);
            }
        });
    }

    public static void showSpamlessErrCode(String string, Object[] objectArray, String string2) {
        NBUtils.showErrCode(string, objectArray, string2, true);
    }

    public static void dumpComponent(Component component) {
        NBUtils.dumpComponent(component, 0);
    }

    public static Component getComponent(Component component, Class clazz) {
        if (component == null || clazz == null) {
            return null;
        }
        if (clazz.isInstance(component)) {
            return component;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component2 = NBUtils.getComponent(componentArray[i], clazz);
                if (component2 == null) continue;
                return component2;
            }
        }
        return null;
    }

    public static String stripAmpersand(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(38);
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n);
            return stringBuffer.toString();
        }
        return string;
    }

    public static String stripExt(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(0, n);
    }

    public static char getMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n = string.indexOf(38);
        return n == -1 || n == string.length() - 1 ? (char)'\u0000' : string.charAt(n + 1);
    }

    public static String getPackageName(String string) {
        String string2 = "";
        if (string == null || string.length() <= 0) {
            return string2;
        }
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static ElementAndFile getMethod(MethodInfo methodInfo, boolean bl) {
        Log.out((String)"Entering method NBEventProcessor :: methodExists");
        Log.out((String)("Looking for method " + methodInfo.toString()));
        String string = methodInfo.getName();
        if (string == null) {
            return null;
        }
        MethodParameterInfo[] methodParameterInfoArray = methodInfo.getParameters();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < methodParameterInfoArray.length; ++i) {
            arrayList.add(methodParameterInfoArray[i].getCodeGenType(true));
            arrayList2.add(methodParameterInfoArray[i].getCodeGenType(false));
        }
        ClassInfo classInfo = methodInfo.getContainingClass();
        ElementAndFile elementAndFile = NBFileUtils.findJavaClass(classInfo);
        if (elementAndFile == null || elementAndFile.getElementHandle() == null || elementAndFile.getFileObject() == null) {
            return null;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)elementAndFile.getFileObject());
        if (javaSource == null) {
            return null;
        }
        ElementAndFile elementAndFile2 = NBUtils.getMethod(string, arrayList, bl, javaSource, elementAndFile, true);
        if (elementAndFile2 == null) {
            elementAndFile2 = NBUtils.getMethod(string, arrayList2, bl, javaSource, elementAndFile, false);
        }
        return elementAndFile2;
    }

    public static ElementAndFile getMethod(final String string, final List<String> list, final boolean bl, JavaSource javaSource, final ElementAndFile elementAndFile, final boolean bl2) {
        final ElementAndFile[] elementAndFileArray = new ElementAndFile[1];
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) {
                    Element element = elementAndFile.getElementHandle().resolve((CompilationInfo)compilationController);
                    List<? extends Element> list4 = element.getEnclosedElements();
                    if (list4 == null) {
                        return;
                    }
                    List<ExecutableElement> list2 = bl ? ElementFilter.constructorsIn(list4) : ElementFilter.methodsIn(list4);
                    if (list2 == null) {
                        return;
                    }
                    int n = list.size();
                    for (ExecutableElement executableElement : list2) {
                        if (executableElement.getSimpleName() == null || !bl && !executableElement.getSimpleName().contentEquals(string)) continue;
                        List<? extends VariableElement> list3 = executableElement.getParameters();
                        if (executableElement.getParameters().size() != n) continue;
                        boolean bl3 = true;
                        Iterator iterator = list.iterator();
                        Iterator<? extends VariableElement> iterator2 = list3.iterator();
                        while (iterator.hasNext() && iterator2.hasNext()) {
                            VariableElement variableElement = iterator2.next();
                            String string2 = (String)iterator.next();
                            if (string2.contentEquals(NBUtils.getTypeName(variableElement.asType(), bl2))) continue;
                            bl3 = false;
                            break;
                        }
                        if (!bl3) continue;
                        elementAndFileArray[0] = new ElementAndFile(ElementHandle.create((Element)executableElement), compilationController.getFileObject());
                        return;
                    }
                }

                public void cancel() {
                }
            }, true);
        }
        catch (Exception exception) {
            Log.stackTrace((Throwable)exception);
        }
        return elementAndFileArray[0];
    }

    private static String umlTypeToType(String string) {
        String string2;
        String string3 = string;
        string3 = string3.replaceAll("::", ".");
        int n = string.indexOf(91);
        String string4 = string2 = n > -1 ? string.substring(0, n) : string;
        if ("String".equals(string2)) {
            String string5 = n > -1 ? string.substring(n) : "";
            string3 = "java.lang.String" + string5;
        }
        return string3;
    }

    public static ElementAndFile getField(final MemberInfo memberInfo) {
        if (memberInfo == null || memberInfo.getName() == null) {
            return null;
        }
        ClassInfo classInfo = memberInfo.getContainingClass();
        if (classInfo == null) {
            return null;
        }
        final ElementAndFile elementAndFile = NBFileUtils.findJavaClass(classInfo);
        if (elementAndFile == null || elementAndFile.getElementHandle() == null || elementAndFile.getFileObject() == null) {
            return null;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)elementAndFile.getFileObject());
        if (javaSource == null) {
            return null;
        }
        final ElementAndFile[] elementAndFileArray = new ElementAndFile[1];
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) {
                    Element element = elementAndFile.getElementHandle().resolve((CompilationInfo)compilationController);
                    List<? extends Element> list = element.getEnclosedElements();
                    if (list == null) {
                        return;
                    }
                    List<VariableElement> list2 = ElementFilter.fieldsIn(list);
                    if (list2 == null) {
                        return;
                    }
                    for (VariableElement variableElement : list2) {
                        if (variableElement.getSimpleName() == null || !variableElement.getSimpleName().contentEquals(memberInfo.getName())) continue;
                        elementAndFileArray[0] = new ElementAndFile(ElementHandle.create((Element)variableElement), compilationController.getFileObject());
                        return;
                    }
                }

                public void cancel() {
                }
            }, true);
        }
        catch (Exception exception) {
            Log.stackTrace((Throwable)exception);
        }
        return elementAndFileArray[0];
    }

    private NBUtils() {
    }

    private static String getIndent(int n) {
        char[] cArray = new char[n * 2];
        return new String(cArray);
    }

    private static void dumpComponent(Component component, int n) {
        if (component != null) {
            Log.out((String)("DC: " + NBUtils.getIndent(n) + component.getClass().getName()));
            if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                ++n;
                for (int i = 0; i < componentArray.length; ++i) {
                    NBUtils.dumpComponent(componentArray[i], n);
                }
            }
        }
    }

    public static CharSequence getTypeName(TypeMirror typeMirror, boolean bl) {
        if (typeMirror == null) {
            return "";
        }
        return (CharSequence)new TypeNameVisitor(false).visit(typeMirror, bl);
    }

    static {
        try {
            bundle = ResourceBundle.getBundle("org.netbeans.modules.uml.integration.Bundle");
        }
        catch (MissingResourceException missingResourceException) {
            Log.stackTrace((Throwable)missingResourceException);
        }
        EDITOR_MODE_ID = bundle != null ? bundle.getString("EDITOR_MODE_NAME") : "explorer";
        lastError = null;
        lastErrorTime = 0L;
        fileUtils = new NBFileUtils();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeNameVisitor
    extends SimpleTypeVisitor6<StringBuilder, Boolean> {
        private boolean varArg;

        private TypeNameVisitor(boolean bl) {
            super(new StringBuilder());
            this.varArg = bl;
        }

        @Override
        public StringBuilder defaultAction(TypeMirror typeMirror, Boolean bl) {
            return ((StringBuilder)this.DEFAULT_VALUE).append(typeMirror);
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType declaredType, Boolean bl) {
            Element element = declaredType.asElement();
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? typeElement.getQualifiedName() : typeElement.getSimpleName()).toString());
                Iterator<? extends TypeMirror> iterator = declaredType.getTypeArguments().iterator();
                if (iterator.hasNext()) {
                    ((StringBuilder)this.DEFAULT_VALUE).append("<");
                    while (iterator.hasNext()) {
                        this.visit(iterator.next(), bl);
                        if (!iterator.hasNext()) continue;
                        ((StringBuilder)this.DEFAULT_VALUE).append(", ");
                    }
                    ((StringBuilder)this.DEFAULT_VALUE).append(">");
                }
                return (StringBuilder)this.DEFAULT_VALUE;
            }
            return ((StringBuilder)this.DEFAULT_VALUE).append(NBUtils.UNKNOWN);
        }

        @Override
        public StringBuilder visitArray(ArrayType arrayType, Boolean bl) {
            boolean bl2 = this.varArg;
            this.varArg = false;
            this.visit(arrayType.getComponentType(), bl);
            return ((StringBuilder)this.DEFAULT_VALUE).append(bl2 ? "..." : "[]");
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable typeVariable, Boolean bl) {
            Object object;
            Element element = typeVariable.asElement();
            if (element != null && !NBUtils.CAPTURED_WILDCARD.equals(object = element.getSimpleName().toString())) {
                return ((StringBuilder)this.DEFAULT_VALUE).append((String)object);
            }
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            object = typeVariable.getLowerBound();
            if (object != null && object.getKind() != TypeKind.NULL) {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit((TypeMirror)object, bl);
            } else {
                object = typeVariable.getUpperBound();
                if (object != null && object.getKind() != TypeKind.NULL) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (object.getKind() == TypeKind.TYPEVAR) {
                        object = ((TypeVariable)object).getLowerBound();
                    }
                    this.visit((TypeMirror)object, bl);
                }
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitWildcard(WildcardType wildcardType, Boolean bl) {
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            TypeMirror typeMirror = wildcardType.getSuperBound();
            if (typeMirror == null) {
                typeMirror = wildcardType.getExtendsBound();
                if (typeMirror != null) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (typeMirror.getKind() == TypeKind.WILDCARD) {
                        typeMirror = ((WildcardType)typeMirror).getSuperBound();
                    }
                    this.visit(typeMirror, bl);
                } else {
                    typeMirror = SourceUtils.getBound((WildcardType)wildcardType);
                    if (typeMirror != null) {
                        ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                        this.visit(typeMirror, bl);
                    } else {
                        ((StringBuilder)this.DEFAULT_VALUE).append(bl != false ? " extends java.lang.Object" : " extends Object");
                    }
                }
            } else {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit(typeMirror, bl);
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitError(ErrorType errorType, Boolean bl) {
            Element element = errorType.asElement();
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                return ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? typeElement.getQualifiedName() : typeElement.getSimpleName()).toString());
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }
    }
}

